/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.lookup;

import java.util.NavigableMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.storage.hbase.lookup.HBaseLookupRowEncoder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HBaseLookupRowEncoderTest
extends LocalFileMetadataTestCase {
    private TableDesc tableDesc;

    @Before
    public void setup() throws Exception {
        this.createTestMetadata(new String[0]);
        TableMetadataManager metadataManager = TableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        this.tableDesc = metadataManager.getTableDesc("TEST_COUNTRY", "default");
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testEnDeCode() {
        HBaseLookupRowEncoder lookupRowEncoder = new HBaseLookupRowEncoder(this.tableDesc, new String[]{"COUNTRY"}, 1);
        Object[] row = new String[]{"AD", "42.546245", "1.601554", "Andorra"};
        HBaseLookupRowEncoder.HBaseRow hBaseRow = lookupRowEncoder.encode((String[])row);
        Assert.assertEquals((long)6L, (long)hBaseRow.getRowKey().length);
        Assert.assertEquals((long)3L, (long)hBaseRow.getQualifierValMap().size());
        NavigableMap qualifierMap = hBaseRow.getQualifierValMap();
        Assert.assertEquals((Object)"42.546245", (Object)Bytes.toString((byte[])((byte[])qualifierMap.get(Bytes.toBytes((String)"1")))));
        Assert.assertEquals((Object)"1.601554", (Object)Bytes.toString((byte[])((byte[])qualifierMap.get(Bytes.toBytes((String)"2")))));
        Object[] decodeRow = lookupRowEncoder.decode(hBaseRow);
        Assert.assertArrayEquals((Object[])row, (Object[])decodeRow);
    }

    @Test
    public void testEnDeCodeWithNullValue() {
        HBaseLookupRowEncoder lookupRowEncoder = new HBaseLookupRowEncoder(this.tableDesc, new String[]{"COUNTRY"}, 1);
        Object[] row = new String[]{"AD", "42.546245", "1.601554", null};
        HBaseLookupRowEncoder.HBaseRow hBaseRow = lookupRowEncoder.encode((String[])row);
        Assert.assertEquals((long)6L, (long)hBaseRow.getRowKey().length);
        Assert.assertEquals((long)3L, (long)hBaseRow.getQualifierValMap().size());
        NavigableMap qualifierMap = hBaseRow.getQualifierValMap();
        Assert.assertEquals((Object)"42.546245", (Object)Bytes.toString((byte[])((byte[])qualifierMap.get(Bytes.toBytes((String)"1")))));
        Assert.assertEquals((Object)"1.601554", (Object)Bytes.toString((byte[])((byte[])qualifierMap.get(Bytes.toBytes((String)"2")))));
        Object[] decodeRow = lookupRowEncoder.decode(hBaseRow);
        Assert.assertNull((Object)decodeRow[3]);
        Assert.assertArrayEquals((Object[])row, (Object[])decodeRow);
    }

    @Test
    public void testEnDeCodeWithMultiKeys() {
        HBaseLookupRowEncoder lookupRowEncoder = new HBaseLookupRowEncoder(this.tableDesc, new String[]{"COUNTRY", "NAME"}, 1);
        Object[] row = new String[]{"AD", "42.546245", "1.601554", "Andorra"};
        HBaseLookupRowEncoder.HBaseRow hBaseRow = lookupRowEncoder.encode((String[])row);
        Assert.assertEquals((long)2L, (long)hBaseRow.getQualifierValMap().size());
        NavigableMap qualifierMap = hBaseRow.getQualifierValMap();
        Assert.assertEquals((Object)"42.546245", (Object)Bytes.toString((byte[])((byte[])qualifierMap.get(Bytes.toBytes((String)"1")))));
        Assert.assertEquals((Object)"1.601554", (Object)Bytes.toString((byte[])((byte[])qualifierMap.get(Bytes.toBytes((String)"2")))));
        Object[] decodeRow = lookupRowEncoder.decode(hBaseRow);
        Assert.assertArrayEquals((Object[])row, (Object[])decodeRow);
    }
}

