/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.lookup;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.cube.model.SnapshotTableDesc;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfoManager;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.LookupMaterializeContext;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.lookup.LookupExecutableUtil;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.SourceManager;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.lookup.LookupTableHFilesBulkLoadJob;
import org.apache.kylin.storage.hbase.lookup.LookupTableToHFileJob;
import org.apache.kylin.storage.hbase.lookup.UpdateSnapshotCacheForQueryServersStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseLookupMRSteps {
    protected static final Logger logger = LoggerFactory.getLogger(HBaseLookupMRSteps.class);
    private CubeInstance cube;
    private JobEngineConfig config;

    public HBaseLookupMRSteps(CubeInstance cube) {
        this.cube = cube;
        this.config = new JobEngineConfig(cube.getConfig());
    }

    public void addMaterializeLookupTablesSteps(LookupMaterializeContext context) {
        CubeDesc cubeDesc = this.cube.getDescriptor();
        HashSet allLookupTables = Sets.newHashSet();
        for (DimensionDesc dim : cubeDesc.getDimensions()) {
            TableRef table = dim.getTableRef();
            if (!cubeDesc.getModel().isLookupTable(table)) continue;
            allLookupTables.add(table.getTableIdentity());
        }
        List<SnapshotTableDesc> snapshotTableDescs = cubeDesc.getSnapshotTableDescList();
        for (SnapshotTableDesc snapshotTableDesc : snapshotTableDescs) {
            if (!"hbase".equals(snapshotTableDesc.getStorageType()) || !allLookupTables.contains(snapshotTableDesc.getTableName())) continue;
            this.addMaterializeLookupTableSteps(context, snapshotTableDesc.getTableName(), snapshotTableDesc);
        }
    }

    public void addMaterializeLookupTableSteps(LookupMaterializeContext context, String tableName, SnapshotTableDesc snapshotTableDesc) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ExtTableSnapshotInfoManager extTableSnapshotInfoManager = ExtTableSnapshotInfoManager.getInstance(kylinConfig);
        TableDesc tableDesc = TableMetadataManager.getInstance(kylinConfig).getTableDesc(tableName, this.cube.getProject());
        IReadableTable sourceTable = SourceManager.createReadableTable(tableDesc, context.getJobFlow().getId());
        try {
            ExtTableSnapshotInfo latestSnapshot = extTableSnapshotInfoManager.getLatestSnapshot(sourceTable.getSignature(), tableName);
            if (latestSnapshot != null) {
                logger.info("there is latest snapshot exist for table:{}, skip build snapshot step.", (Object)tableName);
                context.addLookupSnapshotPath(tableName, latestSnapshot.getResourcePath());
                return;
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        logger.info("add build snapshot steps for table:{}", (Object)tableName);
        String snapshotID = this.genLookupSnapshotID();
        context.addLookupSnapshotPath(tableName, ExtTableSnapshotInfo.getResourcePath(tableName, snapshotID));
        this.addLookupTableConvertToHFilesStep(context.getJobFlow(), tableName, snapshotID);
        this.addLookupTableHFilesBulkLoadStep(context.getJobFlow(), tableName, snapshotID);
        if (snapshotTableDesc != null && snapshotTableDesc.isEnableLocalCache()) {
            this.addUpdateSnapshotQueryCacheStep(context.getJobFlow(), tableName, snapshotID);
        }
    }

    private String genLookupSnapshotID() {
        return RandomUtil.randomUUID().toString();
    }

    private void addLookupTableConvertToHFilesStep(DefaultChainedExecutable jobFlow, String tableName, String snapshotID) {
        MapReduceExecutable createHFilesStep = new MapReduceExecutable();
        createHFilesStep.setName("Convert Lookup Table to HFile:" + tableName);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        JobBuilderSupport.appendExecCmdParameters((StringBuilder)cmd, (String)"cubename", (String)this.cube.getName());
        JobBuilderSupport.appendExecCmdParameters((StringBuilder)cmd, (String)"output", (String)this.getLookupTableHFilePath(tableName, jobFlow.getId()));
        JobBuilderSupport.appendExecCmdParameters((StringBuilder)cmd, (String)"tableName", (String)tableName);
        JobBuilderSupport.appendExecCmdParameters((StringBuilder)cmd, (String)"cubingJobId", (String)jobFlow.getId());
        JobBuilderSupport.appendExecCmdParameters((StringBuilder)cmd, (String)"snapshotID", (String)snapshotID);
        JobBuilderSupport.appendExecCmdParameters((StringBuilder)cmd, (String)"jobname", (String)("Kylin_LookupTable_HFile_Generator_" + tableName + "_Step"));
        createHFilesStep.setMapReduceParams(cmd.toString());
        createHFilesStep.setMapReduceJobClass(LookupTableToHFileJob.class);
        createHFilesStep.setCounterSaveAs("lookup.ext.snapshot.src.record.cnt." + tableName);
        jobFlow.addTask((AbstractExecutable)createHFilesStep);
    }

    private void addLookupTableHFilesBulkLoadStep(DefaultChainedExecutable jobFlow, String tableName, String snapshotID) {
        HadoopShellExecutable bulkLoadStep = new HadoopShellExecutable();
        bulkLoadStep.setName("Load HFile to HBase Table:" + tableName);
        StringBuilder cmd = new StringBuilder();
        JobBuilderSupport.appendExecCmdParameters((StringBuilder)cmd, (String)"input", (String)this.getLookupTableHFilePath(tableName, jobFlow.getId()));
        JobBuilderSupport.appendExecCmdParameters((StringBuilder)cmd, (String)"tableName", (String)tableName);
        JobBuilderSupport.appendExecCmdParameters((StringBuilder)cmd, (String)"cubingJobId", (String)jobFlow.getId());
        JobBuilderSupport.appendExecCmdParameters((StringBuilder)cmd, (String)"snapshotID", (String)snapshotID);
        bulkLoadStep.setJobParams(cmd.toString());
        bulkLoadStep.setJobClass(LookupTableHFilesBulkLoadJob.class);
        jobFlow.addTask((AbstractExecutable)bulkLoadStep);
    }

    private void addUpdateSnapshotQueryCacheStep(DefaultChainedExecutable jobFlow, String tableName, String snapshotID) {
        UpdateSnapshotCacheForQueryServersStep updateSnapshotCacheStep = new UpdateSnapshotCacheForQueryServersStep();
        updateSnapshotCacheStep.setName("Update Lookup Snapshot Cache to Query Engine:" + tableName);
        LookupExecutableUtil.setProjectName((String)this.cube.getProject(), (Map)updateSnapshotCacheStep.getParams());
        LookupExecutableUtil.setLookupTableName((String)tableName, (Map)updateSnapshotCacheStep.getParams());
        LookupExecutableUtil.setLookupSnapshotID((String)snapshotID, (Map)updateSnapshotCacheStep.getParams());
        jobFlow.addTask((AbstractExecutable)updateSnapshotCacheStep);
    }

    private String getLookupTableHFilePath(String tableName, String jobId) {
        return HBaseConnection.makeQualifiedPathInHBaseCluster(JobBuilderSupport.getJobWorkingDir((JobEngineConfig)this.config, (String)jobId) + "/" + tableName + "/hfile/");
    }

    public void appendMapReduceParameters(StringBuilder buf) {
        this.appendMapReduceParameters(buf, "");
    }

    public void appendMapReduceParameters(StringBuilder buf, String jobType) {
        try {
            String jobConf = this.config.getHadoopJobConfFilePath(jobType);
            if (jobConf != null && jobConf.length() > 0) {
                buf.append(" -conf ").append(jobConf);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

