/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.model.DynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class SumDynamicFunctionDesc
extends DynamicFunctionDesc {
    public static final TblColRef mockCntCol = TblColRef.newInnerColumn("COUNT", TblColRef.InnerDataTypeEnum.DERIVED);
    private Set<TblColRef> measureColumnSet;

    public SumDynamicFunctionDesc(ParameterDesc parameter, TupleExpression tupleExpression) {
        super(parameter, tupleExpression);
        this.setExpression("SUM");
        this.setReturnType("decimal");
    }

    @Override
    public String getRewriteFieldName() {
        return "_KY_SUM_" + this.tupleExpression.toString();
    }

    @Override
    public DataType getRewriteFieldType() {
        return this.getReturnDataType();
    }

    @Override
    public Set<TblColRef> getMeasureColumnSet() {
        if (this.measureColumnSet == null) {
            this.measureColumnSet = Sets.newHashSet(super.getMeasureColumnSet());
            this.measureColumnSet.remove(mockCntCol);
        }
        return this.measureColumnSet;
    }

    @Override
    protected FunctionDesc constructRuntimeFunction(TblColRef column) {
        return column == mockCntCol ? this.constructCountFunction() : this.constructSumFunction(column);
    }

    private FunctionDesc constructCountFunction() {
        return FunctionDesc.newInstance("COUNT", null, null);
    }

    private FunctionDesc constructSumFunction(TblColRef column) {
        FunctionDesc function = new FunctionDesc();
        function.setParameter(ParameterDesc.newInstance(column));
        function.setExpression("SUM");
        function.setReturnType("decimal");
        return function;
    }
}

