/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.ISegmentAdvisor;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Segments<T extends ISegment>
extends ArrayList<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Segments.class);

    public static ISegmentAdvisor newSegmentAdvisor(ISegment seg) {
        try {
            Class<ISegmentAdvisor> clz = ClassUtil.forName(seg.getConfig().getSegmentAdvisor(), ISegmentAdvisor.class);
            return clz.getConstructor(ISegment.class).newInstance(seg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Segments() {
    }

    public Segments(List<T> copy) {
        super(copy);
    }

    public T getFirstSegment() {
        if (this == null || this.size() == 0) {
            return null;
        }
        return (T)((ISegment)this.get(0));
    }

    public long getTSStart() {
        Segments<T> readySegs = this.getSegments(SegmentStatusEnum.READY);
        long startTime = Long.MAX_VALUE;
        for (ISegment seg : readySegs) {
            startTime = Math.min(startTime, (Long)seg.getTSRange().start.v);
        }
        return startTime;
    }

    public long getTSEnd() {
        Segments<T> readySegs = this.getSegments(SegmentStatusEnum.READY);
        long endTime = Long.MIN_VALUE;
        for (ISegment seg : readySegs) {
            endTime = Math.max(endTime, (Long)seg.getTSRange().end.v);
        }
        return endTime;
    }

    public T getLatestReadySegment() {
        ISegment latest = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            ISegment seg = (ISegment)this.get(i);
            if (seg.getStatus() != SegmentStatusEnum.READY || latest != null && (Long)latest.getTSRange().end.v >= (Long)seg.getTSRange().end.v) continue;
            latest = seg;
        }
        return (T)latest;
    }

    public T getLatestBuiltSegment() {
        ISegment latest = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            ISegment seg = (ISegment)this.get(i);
            if (seg.getLastBuildTime() <= 0L || latest != null && seg.getLastBuildTime() <= latest.getLastBuildTime()) continue;
            latest = seg;
        }
        return (T)latest;
    }

    public Segments<T> getSegments(SegmentStatusEnum status) {
        Segments<T> result = new Segments<T>();
        for (ISegment segment : this) {
            if (segment.getStatus() != status) continue;
            result.add(segment);
        }
        return result;
    }

    public T getSegment(String name, SegmentStatusEnum status) {
        for (ISegment segment : this) {
            if (null == segment.getName() || !segment.getName().equals(name) || status != null && segment.getStatus() != status) continue;
            return (T)segment;
        }
        return null;
    }

    public Segments<T> getBuildingSegments() {
        Segments<T> buildingSegments = new Segments<T>();
        if (null != this) {
            for (ISegment segment : this) {
                if (SegmentStatusEnum.NEW != segment.getStatus() && SegmentStatusEnum.READY_PENDING != segment.getStatus()) continue;
                buildingSegments.add(segment);
            }
        }
        return buildingSegments;
    }

    public Segments<T> getMergingSegments(T mergedSegment) {
        Segments<T> result = new Segments<T>();
        if (mergedSegment == null) {
            return result;
        }
        long maxSegMergeSpan = KylinConfig.getInstanceFromEnv().getMaxSegmentMergeSpan();
        for (ISegment seg : this) {
            if (seg.getStatus() != SegmentStatusEnum.READY && seg.getStatus() != SegmentStatusEnum.READY_PENDING || seg == mergedSegment || maxSegMergeSpan > 0L && seg.getTSRange().duration() > maxSegMergeSpan || !mergedSegment.getSegRange().contains(seg.getSegRange())) continue;
            result.add(seg);
        }
        return result;
    }

    public void removeLatestSegmentByVolatileRange(Segments<T> segs, long volatileRange) {
        if (volatileRange <= 0L) {
            return;
        }
        long latestSegEndTs = Long.MIN_VALUE;
        for (ISegment seg : segs) {
            latestSegEndTs = Math.max(latestSegEndTs, (Long)seg.getTSRange().end.v);
        }
        Segments<T> volatileSegs = new Segments<T>();
        for (ISegment seg : segs) {
            if ((Long)seg.getTSRange().end.v + volatileRange <= latestSegEndTs) continue;
            logger.warn("Segment in volatile range, seg: {}, rangeStart:{}, rangeEnd {}.", new Object[]{seg, seg.getTSRange().start.v, seg.getTSRange().end.v});
            volatileSegs.add(seg);
        }
        segs.removeAll(volatileSegs);
    }

    public void removeMaxSpanSegment(Segments<T> segs, long maxSegSpan) {
        if (maxSegSpan <= 0L) {
            return;
        }
        Segments<T> maxSpanSegs = new Segments<T>();
        for (ISegment seg : segs) {
            if (seg.getTSRange().duration() < maxSegSpan) continue;
            logger.warn("segment with max span: seg:" + seg.toString() + "rangeStart:" + seg.getTSRange().start.v + ", rangeEnd" + seg.getTSRange().end.v);
            maxSpanSegs.add(seg);
        }
        segs.removeAll(maxSpanSegs);
    }

    public SegmentRange autoMergeCubeSegments(boolean needAutoMerge, String cubeName, long[] timeRanges, long volatileRange) throws IOException {
        if (!needAutoMerge) {
            logger.debug("Cube " + cubeName + " doesn't need auto merge");
            return null;
        }
        int buildingSize = this.getBuildingSegments().size();
        if (buildingSize > 0) {
            logger.debug("Cube " + cubeName + " has " + buildingSize + " building segments");
        }
        Segments<T> readySegs = this.getSegments(SegmentStatusEnum.READY);
        Segments<T> mergingSegs = new Segments<T>();
        if (buildingSize > 0) {
            for (ISegment building : this.getBuildingSegments()) {
                for (ISegment ready : readySegs) {
                    if (!building.getSegRange().contains(ready.getSegRange())) continue;
                    mergingSegs.add(ready);
                }
            }
        }
        this.removeLatestSegmentByVolatileRange(readySegs, volatileRange);
        this.removeMaxSpanSegment(readySegs, KylinConfig.getInstanceFromEnv().getMaxSegmentMergeSpan());
        readySegs.removeAll(mergingSegs);
        Arrays.parallelSort(timeRanges);
        for (int i = timeRanges.length - 1; i >= 0; --i) {
            long toMergeRange = timeRanges[i];
            for (int s = 0; s < readySegs.size(); ++s) {
                ISegment seg = (ISegment)readySegs.get(s);
                SegmentRange.TSRange tsRange = new SegmentRange.TSRange((Long)seg.getTSRange().start.v, (Long)seg.getTSRange().start.v + toMergeRange);
                Pair<T, T> p = super.getSubList(s, readySegs.size()).findMergeOffsetsByDateRange(tsRange, toMergeRange);
                if (p == null || (Long)((ISegment)p.getSecond()).getTSRange().end.v - (Long)((ISegment)p.getFirst()).getTSRange().start.v < toMergeRange) continue;
                return new SegmentRange(((ISegment)p.getFirst()).getSegRange().start.v, ((ISegment)p.getSecond()).getSegRange().end.v);
            }
        }
        return null;
    }

    public Pair<T, T> findMergeOffsetsByDateRange(SegmentRange.TSRange tsRange, long skipSegDateRangeCap) {
        Segments<T> result = new Segments<T>();
        for (ISegment seg : this) {
            if (!tsRange.overlaps(seg.getTSRange())) continue;
            if (seg.getTSRange().duration() > skipSegDateRangeCap || result.size() > 0 && !super.getLast().getSegRange().connects(seg.getSegRange())) break;
            result.add(seg);
        }
        if (result.size() <= 1) {
            return null;
        }
        return Pair.newPair(super.getFirst(), super.getLast());
    }

    public Segments calculateToBeSegments(ISegment newSegment) {
        Segments tobe = (Segments)this.clone();
        if (newSegment != null && !tobe.contains(newSegment)) {
            tobe.add(newSegment);
        }
        if (tobe.size() == 0) {
            return tobe;
        }
        Collections.sort(tobe);
        T firstSeg = tobe.getFirst();
        firstSeg.validate();
        int i = 0;
        int j = 1;
        while (j < tobe.size()) {
            ISegment is = (ISegment)tobe.get(i);
            ISegment js = (ISegment)tobe.get(j);
            js.validate();
            if (!this.isNew(is) && !this.isReady(is)) {
                tobe.remove(i);
                continue;
            }
            if (!this.isNew(js) && !this.isReady(js)) {
                tobe.remove(j);
                continue;
            }
            if (is.getSegRange().start.compareTo(js.getSegRange().start) == 0) {
                if (this.isReady(is) && this.isReady(js) || this.isNew(is) && this.isNew(js)) {
                    if (is.getSegRange().end.compareTo(js.getSegRange().end) <= 0) {
                        tobe.remove(i);
                        continue;
                    }
                    tobe.remove(j);
                    continue;
                }
                if (this.isNew(is) && is.equals(newSegment)) {
                    tobe.remove(j);
                    continue;
                }
                if (js.equals(newSegment)) {
                    tobe.remove(i);
                    continue;
                }
            }
            if (is.getSegRange().end.compareTo(js.getSegRange().start) <= 0) {
                ++i;
                ++j;
                continue;
            }
            if (is.equals(newSegment)) {
                tobe.remove(j);
                continue;
            }
            ++i;
            ++j;
        }
        return tobe;
    }

    private boolean isReady(ISegment seg) {
        return seg.getStatus() == SegmentStatusEnum.READY;
    }

    private boolean isNew(ISegment seg) {
        return seg.getStatus() == SegmentStatusEnum.NEW || seg.getStatus() == SegmentStatusEnum.READY_PENDING;
    }

    @Override
    private T getLast() {
        assert (this.size() != 0);
        return (T)((ISegment)this.get(this.size() - 1));
    }

    @Override
    private T getFirst() {
        assert (this.size() != 0);
        return (T)((ISegment)this.get(0));
    }

    private Segments<T> getSubList(int from, int to) {
        Segments<T> result = new Segments<T>();
        for (ISegment seg : this.subList(from, to)) {
            result.add(seg);
        }
        return result;
    }

    public void validate() {
        if (this.isEmpty()) {
            return;
        }
        Segments<T> all = new Segments<T>(this);
        Collections.sort(all);
        boolean isOffsetCube = ((ISegment)all.get(0)).isOffsetCube();
        for (ISegment seg : all) {
            seg.validate();
            if (seg.isOffsetCube() == isOffsetCube) continue;
            throw new IllegalStateException("Inconsistent isOffsetsOn for segment " + seg);
        }
        ArrayList ready = Lists.newArrayListWithCapacity((int)all.size());
        ArrayList news = Lists.newArrayListWithCapacity((int)all.size());
        for (ISegment seg : all) {
            if (seg.getStatus() == SegmentStatusEnum.READY) {
                ready.add(seg);
                continue;
            }
            news.add(seg);
        }
        ISegment pre = null;
        for (ISegment seg : ready) {
            if (pre != null) {
                if (pre.getSegRange().overlaps(seg.getSegRange())) {
                    throw new IllegalStateException("Segments overlap: " + pre + " and " + seg);
                }
                if (pre.getSegRange().apartBefore(seg.getSegRange())) {
                    logger.warn("Hole between adjacent READY segments " + pre + " and " + seg);
                }
            }
            pre = seg;
        }
        pre = null;
        for (ISegment seg : news) {
            if (pre != null && pre.getSegRange().overlaps(seg.getSegRange())) {
                throw new IllegalStateException("Segments overlap: " + pre + " and " + seg);
            }
            pre = seg;
            for (ISegment aReady : ready) {
                if (!seg.getSegRange().overlaps(aReady.getSegRange()) || seg.getSegRange().contains(aReady.getSegRange())) continue;
                throw new IllegalStateException("Segments overlap: " + aReady + " and " + seg);
            }
        }
        for (ISegment seg : news) {
            Pair<Boolean, Boolean> pair = all.fitInSegments(seg);
            boolean startFit = pair.getFirst();
            boolean endFit = pair.getSecond();
            if (!startFit) {
                logger.warn("NEW segment start does not fit/connect with other segments: " + seg);
            }
            if (endFit) continue;
            logger.warn("NEW segment end does not fit/connect with other segments: " + seg);
        }
    }

    public Pair<Boolean, Boolean> fitInSegments(ISegment newOne) {
        if (this.isEmpty()) {
            return null;
        }
        ISegment first = (ISegment)this.get(0);
        ISegment last = (ISegment)this.get(this.size() - 1);
        SegmentRange.Endpoint start = newOne.getSegRange().start;
        SegmentRange.Endpoint end = newOne.getSegRange().end;
        boolean startFit = false;
        boolean endFit = false;
        for (ISegment sss : this) {
            if (sss == newOne) continue;
            startFit = startFit || start.equals(sss.getSegRange().start) || start.equals(sss.getSegRange().end);
            endFit = endFit || end.equals(sss.getSegRange().start) || end.equals(sss.getSegRange().end);
        }
        if (!startFit && endFit && newOne == first) {
            startFit = true;
        }
        if (!endFit && startFit && newOne == last) {
            endFit = true;
        }
        return Pair.newPair(startFit, endFit);
    }

    public boolean isOperative(ISegment seg) {
        if (seg.getStatus() != SegmentStatusEnum.READY) {
            return false;
        }
        for (ISegment other : this) {
            if (other == seg || !other.getSegRange().overlaps(seg.getSegRange())) continue;
            return false;
        }
        return true;
    }
}

