/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.percentile;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.percentile.PercentileAggFunc;
import org.apache.kylin.measure.percentile.PercentileAggregator;
import org.apache.kylin.measure.percentile.PercentileCounter;
import org.apache.kylin.measure.percentile.PercentileSerializer;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class PercentileMeasureType
extends MeasureType<PercentileCounter> {
    private final DataType dataType;
    public static final String FUNC_PERCENTILE = "PERCENTILE";
    public static final String FUNC_PERCENTILE_APPROX = "PERCENTILE_APPROX";
    public static final String DATATYPE_PERCENTILE = "percentile";
    static final Map<String, Class<?>> UDAF_MAP = ImmutableMap.of((Object)"PERCENTILE", PercentileAggFunc.class, (Object)"PERCENTILE_APPROX", PercentileAggFunc.class);

    public PercentileMeasureType(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public MeasureIngester<PercentileCounter> newIngester() {
        return new MeasureIngester<PercentileCounter>(){
            PercentileCounter current;
            {
                this.current = new PercentileCounter(PercentileMeasureType.this.dataType.getPrecision());
            }

            @Override
            public PercentileCounter valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                PercentileCounter counter = this.current;
                counter.clear();
                for (String v : values) {
                    if (v == null) continue;
                    counter.add(Double.parseDouble(v));
                }
                return counter;
            }

            @Override
            public void reset() {
                this.current = new PercentileCounter(PercentileMeasureType.this.dataType.getPrecision());
            }
        };
    }

    @Override
    public MeasureAggregator<PercentileCounter> newAggregator() {
        return new PercentileAggregator(this.dataType.getPrecision());
    }

    @Override
    public boolean needRewrite() {
        return true;
    }

    @Override
    public Map<String, Class<?>> getRewriteCalciteAggrFunctions() {
        return UDAF_MAP;
    }

    public static class Factory
    extends MeasureTypeFactory<PercentileCounter> {
        @Override
        public MeasureType<PercentileCounter> createMeasureType(String funcName, DataType dataType) {
            return new PercentileMeasureType(dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return PercentileMeasureType.FUNC_PERCENTILE_APPROX;
        }

        @Override
        public String getAggrDataTypeName() {
            return PercentileMeasureType.DATATYPE_PERCENTILE;
        }

        @Override
        public Class<? extends DataTypeSerializer<PercentileCounter>> getAggrDataTypeSerializer() {
            return PercentileSerializer.class;
        }
    }
}

