/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.hllc.HLLCAggregator;
import org.apache.kylin.measure.hllc.HLLCSerializer;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.measure.hllc.HLLDistinctCountAggFunc;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class HLLCMeasureType
extends MeasureType<HLLCounter> {
    private static final long serialVersionUID = 1L;
    public static final String FUNC_COUNT_DISTINCT = "COUNT_DISTINCT";
    public static final String DATATYPE_HLLC = "hllc";
    private final DataType dataType;
    static final Map<String, Class<?>> UDAF_MAP = ImmutableMap.of((Object)"COUNT_DISTINCT", HLLDistinctCountAggFunc.class);

    public HLLCMeasureType(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void validate(FunctionDesc functionDesc) throws IllegalArgumentException {
        this.validate(functionDesc.getExpression(), functionDesc.getReturnDataType(), true);
    }

    private void validate(String funcName, DataType dataType, boolean checkDataType) {
        if (!FUNC_COUNT_DISTINCT.equals(funcName)) {
            throw new IllegalArgumentException();
        }
        if (!DATATYPE_HLLC.equals(dataType.getName())) {
            throw new IllegalArgumentException();
        }
        if (dataType.getPrecision() < 1 || dataType.getPrecision() > 5000) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isMemoryHungry() {
        return true;
    }

    @Override
    public MeasureIngester<HLLCounter> newIngester() {
        return new MeasureIngester<HLLCounter>(){
            private static final long serialVersionUID = 1L;
            HLLCounter current;
            {
                this.current = new HLLCounter(HLLCMeasureType.this.dataType.getPrecision());
            }

            @Override
            public HLLCounter valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                HLLCounter hllc = this.current;
                hllc.clear();
                if (values.length == 1) {
                    if (values[0] != null) {
                        hllc.add(values[0]);
                    }
                } else {
                    boolean allNull = true;
                    StringBuilder buf = new StringBuilder();
                    for (String v : values) {
                        allNull = allNull && v == null;
                        buf.append(v);
                    }
                    if (!allNull) {
                        hllc.add(buf.toString());
                    }
                }
                return hllc;
            }

            @Override
            public void reset() {
                this.current = new HLLCounter(HLLCMeasureType.this.dataType.getPrecision());
            }
        };
    }

    @Override
    public MeasureAggregator<HLLCounter> newAggregator() {
        return new HLLCAggregator(this.dataType.getPrecision());
    }

    @Override
    public boolean needRewrite() {
        return true;
    }

    @Override
    public Map<String, Class<?>> getRewriteCalciteAggrFunctions() {
        return UDAF_MAP;
    }

    public static boolean isCountDistinct(FunctionDesc func) {
        return FUNC_COUNT_DISTINCT.equalsIgnoreCase(func.getExpression());
    }

    public static class Factory
    extends MeasureTypeFactory<HLLCounter> {
        @Override
        public MeasureType<HLLCounter> createMeasureType(String funcName, DataType dataType) {
            return new HLLCMeasureType(dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return HLLCMeasureType.FUNC_COUNT_DISTINCT;
        }

        @Override
        public String getAggrDataTypeName() {
            return HLLCMeasureType.DATATYPE_HLLC;
        }

        @Override
        public Class<? extends DataTypeSerializer<HLLCounter>> getAggrDataTypeSerializer() {
            return HLLCSerializer.class;
        }
    }
}

