/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;

public abstract class LookupTable<T> {
    protected TableDesc tableDesc;
    protected String[] keyColumns;
    protected IReadableTable table;
    protected Map<org.apache.kylin.common.util.Array<T>, T[]> data;

    public LookupTable(TableDesc tableDesc, String[] keyColumns, IReadableTable table) throws IOException {
        this.tableDesc = tableDesc;
        this.keyColumns = keyColumns;
        this.table = table;
        this.data = new HashMap<org.apache.kylin.common.util.Array<T>, T[]>();
        this.init();
    }

    protected void init() throws IOException {
        int[] keyIndex = new int[this.keyColumns.length];
        for (int i = 0; i < this.keyColumns.length; ++i) {
            keyIndex[i] = this.tableDesc.findColumnByName(this.keyColumns[i]).getZeroBasedIndex();
        }
        IReadableTable.TableReader reader = this.table.getReader();
        try {
            while (reader.next()) {
                this.initRow(reader.getRow(), keyIndex);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
    }

    private void initRow(String[] cols, int[] keyIndex) {
        T[] value = this.convertRow(cols);
        Object[] keyCols = (Object[])Array.newInstance(this.getType(), keyIndex.length);
        for (int i = 0; i < keyCols.length; ++i) {
            keyCols[i] = value[keyIndex[i]];
        }
        org.apache.kylin.common.util.Array<Object> key = new org.apache.kylin.common.util.Array<Object>(keyCols);
        if (this.data.containsKey(key)) {
            throw new IllegalStateException("The table: " + this.tableDesc.getName() + " Dup key found, key=" + this.toString((T)keyCols) + ", value1=" + this.toString((T)this.data.get(key)) + ", value2=" + this.toString((T)value));
        }
        this.data.put(key, value);
    }

    protected abstract T[] convertRow(String[] var1);

    public T[] getRow(org.apache.kylin.common.util.Array<T> key) {
        return this.data.get(key);
    }

    public Collection<T[]> getAllRows() {
        return this.data.values();
    }

    public List<T> scan(String col, List<T> values, String returnCol) {
        ArrayList<T> result = new ArrayList<T>();
        int colIdx = this.tableDesc.findColumnByName(col).getZeroBasedIndex();
        int returnIdx = this.tableDesc.findColumnByName(returnCol).getZeroBasedIndex();
        for (T[] row : this.data.values()) {
            if (!values.contains(row[colIdx])) continue;
            result.add(row[returnIdx]);
        }
        return result;
    }

    public Pair<T, T> mapRange(String col, T beginValue, T endValue, String returnCol) {
        int colIdx = this.tableDesc.findColumnByName(col).getZeroBasedIndex();
        int returnIdx = this.tableDesc.findColumnByName(returnCol).getZeroBasedIndex();
        Comparator<T> colComp = this.getComparator(colIdx);
        Comparator<Object> returnComp = this.getComparator(returnIdx);
        Object returnBegin = null;
        Object returnEnd = null;
        for (T[] row : this.data.values()) {
            if (!this.between(beginValue, row[colIdx], endValue, colComp)) continue;
            T returnValue = row[returnIdx];
            if (returnBegin == null || returnComp.compare(returnValue, returnBegin) < 0) {
                returnBegin = returnValue;
            }
            if (returnEnd != null && returnComp.compare(returnValue, returnEnd) <= 0) continue;
            returnEnd = returnValue;
        }
        if (returnBegin == null && returnEnd == null) {
            return null;
        }
        return Pair.newPair(returnBegin, returnEnd);
    }

    public Set<T> mapValues(String col, Set<T> values, String returnCol) {
        int colIdx = this.tableDesc.findColumnByName(col).getZeroBasedIndex();
        int returnIdx = this.tableDesc.findColumnByName(returnCol).getZeroBasedIndex();
        HashSet result = Sets.newHashSetWithExpectedSize((int)values.size());
        for (T[] row : this.data.values()) {
            if (!values.contains(row[colIdx])) continue;
            result.add(row[returnIdx]);
        }
        return result;
    }

    private boolean between(T beginValue, T v, T endValue, Comparator<T> comp) {
        return !(beginValue != null && comp.compare(beginValue, v) > 0 || endValue != null && comp.compare(v, endValue) > 0);
    }

    protected abstract Comparator<T> getComparator(int var1);

    public String toString() {
        return "LookupTable [path=" + this.table + "]";
    }

    protected String toString(T[] cols) {
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                b.append(",");
            }
            b.append(this.toString(cols[i]));
        }
        b.append("]");
        return b.toString();
    }

    protected abstract String toString(T var1);

    public abstract Class<?> getType();

    public void dump() {
        for (org.apache.kylin.common.util.Array<T> key : this.data.keySet()) {
            System.out.println(this.toString((T)key.data) + " => " + this.toString((T)this.data.get(key)));
        }
    }
}

