/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.source.IReadableTable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ExtTableSnapshotInfo
extends RootPersistentEntity {
    public static final String STORAGE_TYPE_HBASE = "hbase";
    @JsonProperty(value="tableName")
    private String tableName;
    @JsonProperty(value="signature")
    private IReadableTable.TableSignature signature;
    @JsonProperty(value="key_columns")
    private String[] keyColumns;
    @JsonProperty(value="storage_type")
    private String storageType;
    @JsonProperty(value="storage_location_identifier")
    private String storageLocationIdentifier;
    @JsonProperty(value="shard_num")
    private int shardNum;
    @JsonProperty(value="row_cnt")
    private long rowCnt;
    @JsonProperty(value="last_build_time")
    private long lastBuildTime;

    public ExtTableSnapshotInfo() {
    }

    public ExtTableSnapshotInfo(IReadableTable.TableSignature signature, String tableName) throws IOException {
        this.signature = signature;
        this.tableName = tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getResourcePath() {
        return ExtTableSnapshotInfo.getResourcePath(this.tableName, this.uuid);
    }

    public String getResourceDir() {
        return ExtTableSnapshotInfo.getResourceDir(this.tableName);
    }

    public static String getResourcePath(String tableName, String uuid) {
        return ExtTableSnapshotInfo.getResourceDir(tableName) + "/" + uuid + ".snapshot";
    }

    public static String getResourceDir(String tableName) {
        return "/ext_table_snapshot/" + tableName;
    }

    public IReadableTable.TableSignature getSignature() {
        return this.signature;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getStorageLocationIdentifier() {
        return this.storageLocationIdentifier;
    }

    public void setStorageLocationIdentifier(String storageLocationIdentifier) {
        this.storageLocationIdentifier = storageLocationIdentifier;
    }

    public String[] getKeyColumns() {
        return this.keyColumns;
    }

    public void setKeyColumns(String[] keyColumns) {
        this.keyColumns = keyColumns;
    }

    public int getShardNum() {
        return this.shardNum;
    }

    public void setShardNum(int shardNum) {
        this.shardNum = shardNum;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setSignature(IReadableTable.TableSignature signature) {
        this.signature = signature;
    }

    public long getRowCnt() {
        return this.rowCnt;
    }

    public void setRowCnt(long rowCnt) {
        this.rowCnt = rowCnt;
    }

    public long getLastBuildTime() {
        return this.lastBuildTime;
    }

    public void setLastBuildTime(long lastBuildTime) {
        this.lastBuildTime = lastBuildTime;
    }
}

