/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.DateStrDictionary;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.IDictionaryBuilder;
import org.apache.kylin.dict.IDictionaryValueEnumerator;
import org.apache.kylin.dict.MultipleDictionaryValueEnumerator;
import org.apache.kylin.dict.NumberDictionaryBuilder;
import org.apache.kylin.dict.NumberDictionaryForestBuilder;
import org.apache.kylin.dict.StringBytesConverter;
import org.apache.kylin.dict.TimeStrDictionary;
import org.apache.kylin.dict.TrieDictionaryBuilder;
import org.apache.kylin.dict.TrieDictionaryForestBuilder;
import org.apache.kylin.metadata.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryGenerator.class);

    public static IDictionaryBuilder newDictionaryBuilder(DataType dataType) {
        IDictionaryBuilder builder;
        Preconditions.checkNotNull((Object)dataType, (Object)"dataType cannot be null");
        if (dataType.isDateTimeFamily()) {
            builder = dataType.isDate() ? new DateDictBuilder() : new TimeDictBuilder();
        } else {
            boolean useForest = KylinConfig.getInstanceFromEnv().isUseForestTrieDictionary();
            builder = dataType.isNumberFamily() ? (useForest ? new NumberTrieDictForestBuilder() : new NumberTrieDictBuilder()) : (useForest ? new StringTrieDictForestBuilder() : new StringTrieDictBuilder());
        }
        return builder;
    }

    public static Dictionary<String> buildDictionary(DataType dataType, IDictionaryValueEnumerator valueEnumerator) throws IOException {
        return DictionaryGenerator.buildDictionary(DictionaryGenerator.newDictionaryBuilder(dataType), null, valueEnumerator);
    }

    static Dictionary<String> buildDictionary(IDictionaryBuilder builder, DictionaryInfo dictInfo, IDictionaryValueEnumerator valueEnumerator) throws IOException {
        int baseId = 0;
        int nSamples = 5;
        ArrayList<String> samples = new ArrayList<String>(nSamples);
        builder.init(dictInfo, baseId, null);
        try {
            while (valueEnumerator.moveNext()) {
                String value = valueEnumerator.current();
                boolean accept = builder.addValue(value);
                if (!accept || samples.size() >= nSamples || samples.contains(value)) continue;
                samples.add(value);
            }
        }
        catch (IOException e) {
            logger.error("Error during adding dict value.", (Throwable)e);
            builder.clear();
            throw e;
        }
        Dictionary<String> dict = builder.build();
        logger.debug("Dictionary cardinality: " + dict.getSize());
        logger.debug("Dictionary builder class: " + builder.getClass().getName());
        logger.debug("Dictionary class: " + dict.getClass().getName());
        StringBuilder buf = new StringBuilder();
        for (String s : samples) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(s.toString()).append("=>").append(dict.getIdFromValue(s));
        }
        logger.debug("Dictionary value samples: " + buf.toString());
        return dict;
    }

    public static Dictionary mergeDictionaries(DataType dataType, List<DictionaryInfo> sourceDicts) throws IOException {
        List dictList = Lists.transform(sourceDicts, (Function)new Function<DictionaryInfo, Dictionary<String>>(){

            @Nullable
            public Dictionary<String> apply(@Nullable DictionaryInfo input) {
                return input.dictionaryObject;
            }
        });
        return DictionaryGenerator.buildDictionary(dataType, new MultipleDictionaryValueEnumerator(dataType, dictList));
    }

    private static class NumberTrieDictForestBuilder
    implements IDictionaryBuilder {
        NumberDictionaryForestBuilder builder;

        private NumberTrieDictForestBuilder() {
        }

        @Override
        public void init(DictionaryInfo info, int baseId, String hdfsDir) throws IOException {
            this.builder = new NumberDictionaryForestBuilder(baseId);
        }

        @Override
        public boolean addValue(String value) {
            if (StringUtils.isBlank((String)value)) {
                return false;
            }
            this.builder.addValue(value);
            return true;
        }

        @Override
        public Dictionary<String> build() throws IOException {
            return this.builder.build();
        }

        @Override
        public void clear() {
        }
    }

    private static class NumberTrieDictBuilder
    implements IDictionaryBuilder {
        int baseId;
        NumberDictionaryBuilder builder;

        private NumberTrieDictBuilder() {
        }

        @Override
        public void init(DictionaryInfo info, int baseId, String hdfsDir) throws IOException {
            this.baseId = baseId;
            this.builder = new NumberDictionaryBuilder();
        }

        @Override
        public boolean addValue(String value) {
            if (StringUtils.isBlank((String)value)) {
                return false;
            }
            this.builder.addValue(value);
            return true;
        }

        @Override
        public Dictionary<String> build() throws IOException {
            return this.builder.build(this.baseId);
        }

        @Override
        public void clear() {
        }
    }

    private static class StringTrieDictForestBuilder
    implements IDictionaryBuilder {
        TrieDictionaryForestBuilder builder;

        private StringTrieDictForestBuilder() {
        }

        @Override
        public void init(DictionaryInfo info, int baseId, String hdfsDir) throws IOException {
            this.builder = new TrieDictionaryForestBuilder<String>(new StringBytesConverter(), baseId);
        }

        @Override
        public boolean addValue(String value) {
            if (value == null) {
                return false;
            }
            this.builder.addValue(value);
            return true;
        }

        @Override
        public Dictionary<String> build() throws IOException {
            return this.builder.build();
        }

        @Override
        public void clear() {
        }
    }

    private static class StringTrieDictBuilder
    implements IDictionaryBuilder {
        int baseId;
        TrieDictionaryBuilder builder;

        private StringTrieDictBuilder() {
        }

        @Override
        public void init(DictionaryInfo info, int baseId, String hdfsDir) throws IOException {
            this.baseId = baseId;
            this.builder = new TrieDictionaryBuilder<String>(new StringBytesConverter());
        }

        @Override
        public boolean addValue(String value) {
            if (value == null) {
                return false;
            }
            this.builder.addValue(value);
            return true;
        }

        @Override
        public Dictionary<String> build() throws IOException {
            return this.builder.build(this.baseId);
        }

        @Override
        public void clear() {
        }
    }

    private static class TimeDictBuilder
    implements IDictionaryBuilder {
        private TimeDictBuilder() {
        }

        @Override
        public void init(DictionaryInfo info, int baseId, String hdfsDir) throws IOException {
        }

        @Override
        public boolean addValue(String value) {
            if (StringUtils.isBlank((String)value)) {
                return false;
            }
            DateFormat.stringToMillis(value);
            return true;
        }

        @Override
        public Dictionary<String> build() throws IOException {
            return new TimeStrDictionary();
        }

        @Override
        public void clear() {
        }
    }

    private static class DateDictBuilder
    implements IDictionaryBuilder {
        private static final String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyyMMdd"};
        private int baseId;
        private String datePattern;

        private DateDictBuilder() {
        }

        @Override
        public void init(DictionaryInfo info, int baseId, String hdfsDir) throws IOException {
            this.baseId = baseId;
        }

        @Override
        public boolean addValue(String value) {
            if (StringUtils.isBlank((String)value)) {
                return false;
            }
            if (this.datePattern == null) {
                for (String p : DATE_PATTERNS) {
                    try {
                        DateFormat.stringToDate(value, p);
                        this.datePattern = p;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                if (this.datePattern == null) {
                    throw new IllegalArgumentException("Unknown date pattern for input value: " + value);
                }
            }
            DateFormat.stringToDate(value, this.datePattern);
            return true;
        }

        @Override
        public Dictionary<String> build() throws IOException {
            if (this.datePattern == null) {
                this.datePattern = DATE_PATTERNS[0];
            }
            return new DateStrDictionary(this.datePattern, this.baseId);
        }

        @Override
        public void clear() {
        }
    }
}

