/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.gridtable;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.cube.gridtable.CubeCodeSystem;
import org.apache.kylin.cube.gridtable.TrimmedDimEnc;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.gridtable.IGTCodeSystem;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class TrimmedCubeCodeSystem
extends CubeCodeSystem {
    public static final BytesSerializer<IGTCodeSystem> serializer = new BytesSerializer<IGTCodeSystem>(){

        @Override
        public void serialize(IGTCodeSystem ivalue, ByteBuffer out) {
            TrimmedCubeCodeSystem value = (TrimmedCubeCodeSystem)ivalue;
            BytesUtil.writeVInt(value.dependentMetricsMap.size(), out);
            for (Map.Entry x : value.dependentMetricsMap.entrySet()) {
                BytesUtil.writeVInt((Integer)x.getKey(), out);
                BytesUtil.writeVInt((Integer)x.getValue(), out);
            }
            BytesUtil.writeVInt(value.dimEncs.length, out);
            for (int i = 0; i < value.dimEncs.length; ++i) {
                DimensionEncoding enc = value.dimEncs[i];
                TrimmedCubeCodeSystem.writeDimensionEncoding(enc, out);
            }
        }

        @Override
        public IGTCodeSystem deserialize(ByteBuffer in) {
            HashMap dependentMetricsMap = Maps.newHashMap();
            int size = BytesUtil.readVInt(in);
            for (int i = 0; i < size; ++i) {
                int key = BytesUtil.readVInt(in);
                int value = BytesUtil.readVInt(in);
                dependentMetricsMap.put(key, value);
            }
            DimensionEncoding[] dimEncs = new DimensionEncoding[BytesUtil.readVInt(in)];
            for (int i = 0; i < dimEncs.length; ++i) {
                dimEncs[i] = TrimmedCubeCodeSystem.readDimensionEncoding(in);
            }
            return new TrimmedCubeCodeSystem(dimEncs, dependentMetricsMap);
        }
    };

    public TrimmedCubeCodeSystem(DimensionEncoding[] dimEncs, Map<Integer, Integer> dependentMetricsMap) {
        super(dimEncs, dependentMetricsMap);
    }

    @Override
    public void encodeColumnValue(int col, Object value, int roundingFlag, ByteBuffer buf) {
        DataTypeSerializer serializer = this.serializers[col];
        serializer.serialize(value, buf);
    }

    public static void writeDimensionEncoding(DimensionEncoding encoding, ByteBuffer out) {
        try {
            if (encoding == null) {
                BytesUtil.writeVInt(1, out);
            } else {
                BytesUtil.writeVInt(0, out);
                if (encoding instanceof DictionaryDimEnc) {
                    encoding = new TrimmedDimEnc(encoding.getLengthOfEncoding());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(encoding);
                BytesUtil.writeByteArray(baos.toByteArray(), out);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DimensionEncoding readDimensionEncoding(ByteBuffer in) {
        try {
            int isNull = BytesUtil.readVInt(in);
            if (isNull == 1) {
                return null;
            }
            byte[] bytes = BytesUtil.readByteArray(in);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            DimensionEncoding ret = (DimensionEncoding)ois.readObject();
            return ret;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

