/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cli;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryInfoSerializer;
import org.apache.kylin.dict.DictionaryProvider;
import org.apache.kylin.dict.DistinctColumnValuesProvider;
import org.apache.kylin.dict.lookup.ILookupTable;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.dict.lookup.SnapshotTableSerializer;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.source.IReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryGeneratorCLI {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryGeneratorCLI.class);

    private DictionaryGeneratorCLI() {
    }

    public static void processSegment(KylinConfig config, String cubeName, String segmentID, String uuid, DistinctColumnValuesProvider factTableValueProvider, DictionaryProvider dictProvider) throws IOException {
        int retryTime;
        CubeInstance cube = CubeManager.getInstance(config).getCube(cubeName);
        CubeSegment segment = cube.getSegmentById(segmentID);
        for (retryTime = 0; retryTime < 3; ++retryTime) {
            if (retryTime > 0) {
                logger.info("Rebuild dictionary and snapshot for Cube: {}, Segment: {}, {} times.", new Object[]{cubeName, segmentID, retryTime});
            }
            DictionaryGeneratorCLI.processSegment(config, segment, uuid, factTableValueProvider, dictProvider);
            if (DictionaryGeneratorCLI.isAllDictsAndSnapshotsReady(config, cubeName, segmentID)) break;
        }
        if (retryTime >= 3) {
            logger.error("Not all dictionaries and snapshots ready for cube segment: {}", (Object)segmentID);
        } else {
            logger.info("Succeed to build all dictionaries and snapshots for cube segment: {}", (Object)segmentID);
        }
    }

    private static void processSegment(KylinConfig config, CubeSegment cubeSeg, String uuid, DistinctColumnValuesProvider factTableValueProvider, DictionaryProvider dictProvider) throws IOException {
        CubeManager cubeMgr = CubeManager.getInstance(config);
        for (TblColRef col : cubeSeg.getCubeDesc().getAllColumnsNeedDictionaryBuilt()) {
            logger.info("Building dictionary for {}", (Object)col);
            Iterator inpTable = factTableValueProvider.getDistinctValuesFor(col);
            Dictionary<String> preBuiltDict = null;
            if (dictProvider != null) {
                preBuiltDict = dictProvider.getDictionary(col);
            }
            if (preBuiltDict != null) {
                logger.debug("Dict for '{}' has already been built, save it", (Object)col.getName());
                cubeMgr.saveDictionary(cubeSeg, col, (IReadableTable)((Object)inpTable), preBuiltDict);
                continue;
            }
            logger.debug("Dict for '{}' not pre-built, build it from {}", (Object)col.getName(), inpTable);
            cubeMgr.buildDictionary(cubeSeg, col, (IReadableTable)((Object)inpTable));
        }
        HashSet toSnapshot = Sets.newHashSet();
        HashSet toCheckLookup = Sets.newHashSet();
        for (DimensionDesc dim : cubeSeg.getCubeDesc().getDimensions()) {
            TableRef table = dim.getTableRef();
            if (!cubeSeg.getModel().isLookupTable(table) || cubeSeg.getCubeDesc().isExtSnapshotTable(table.getTableIdentity())) continue;
            toSnapshot.add(table.getTableIdentity());
            toCheckLookup.add(table);
        }
        for (String tableIdentity : toSnapshot) {
            logger.info("Building snapshot of {}", (Object)tableIdentity);
            cubeMgr.buildSnapshotTable(cubeSeg, tableIdentity, uuid);
        }
        CubeInstance updatedCube = cubeMgr.getCube(cubeSeg.getCubeInstance().getName());
        cubeSeg = updatedCube.getSegmentById(cubeSeg.getUuid());
        for (TableRef lookup : toCheckLookup) {
            logger.info("Checking snapshot of {}", (Object)lookup);
            try {
                JoinDesc join = cubeSeg.getModel().getJoinsTree().getJoinByPKSide(lookup);
                ILookupTable table = cubeMgr.getLookupTable(cubeSeg, join);
                if (table == null) continue;
                IOUtils.closeStream((Closeable)table);
            }
            catch (Throwable th) {
                throw new RuntimeException(String.format(Locale.ROOT, "Checking snapshot of %s failed.", lookup), th);
            }
        }
    }

    private static boolean isAllDictsAndSnapshotsReady(KylinConfig config, String cubeName, String segmentID) {
        CubeInstance cube = CubeManager.getInstance(config).reloadCube(cubeName);
        CubeSegment segment = cube.getSegmentById(segmentID);
        ResourceStore store = ResourceStore.getStore(config);
        logger.info("Begin to check if all dictionaries exist of Segment: {}", (Object)segmentID);
        Map<String, String> dictionaries = segment.getDictionaries();
        for (Map.Entry<String, String> entry : dictionaries.entrySet()) {
            String dictResPath = entry.getValue();
            String dictKey = entry.getKey();
            try {
                DictionaryInfo dictInfo = store.getResource(dictResPath, DictionaryInfoSerializer.INFO_SERIALIZER);
                if (dictInfo != null) continue;
                logger.warn("Dictionary=[key: {}, resource path: {}] doesn't exist in resource store", (Object)dictKey, (Object)dictResPath);
                return false;
            }
            catch (IOException e) {
                logger.warn("Dictionary=[key: {}, path: {}] failed to check, details: {}", new Object[]{dictKey, dictResPath, e});
                return false;
            }
        }
        logger.info("Begin to check if all snapshots exist of Segment: {}", (Object)segmentID);
        Map<String, String> snapshots = segment.getSnapshots();
        for (Map.Entry<String, String> entry : snapshots.entrySet()) {
            String snapshotKey = entry.getKey();
            String snapshotResPath = entry.getValue();
            try {
                SnapshotTable snapshot = store.getResource(snapshotResPath, SnapshotTableSerializer.INFO_SERIALIZER);
                if (snapshot != null) continue;
                logger.info("SnapshotTable=[key: {}, resource path: {}] doesn't exist in resource store", (Object)snapshotKey, (Object)snapshotResPath);
                return false;
            }
            catch (IOException e) {
                logger.warn("SnapshotTable=[key: {}, resource path: {}]  failed to check, details: {}", new Object[]{snapshotKey, snapshotResPath, e});
                return false;
            }
        }
        logger.info("All dictionaries and snapshots exist checking succeed for Cube Segment: {}", (Object)segmentID);
        return true;
    }
}

