/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.List;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.kylin.common.KylinConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailService {
    private static final Logger logger = LoggerFactory.getLogger(MailService.class);
    private Boolean enabled = Boolean.TRUE;
    private Boolean starttlsEnabled = Boolean.FALSE;
    private String host;
    private String port;
    private String username;
    private String password;
    private String sender;

    public MailService(KylinConfig config) {
        this(config.isMailEnabled(), config.isStarttlsEnabled(), config.getMailHost(), config.getSmtpPort(), config.getMailUsername(), config.getMailPassword(), config.getMailSender());
    }

    private MailService(boolean enabled, boolean starttlsEnabled, String host, String port, String username, String password, String sender) {
        this.enabled = enabled;
        this.starttlsEnabled = starttlsEnabled;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.sender = sender;
        if (enabled && host.isEmpty()) {
            throw new RuntimeException("mail service host is empty");
        }
    }

    public boolean sendMail(List<String> receivers, String subject, String content) {
        return this.sendMail(receivers, subject, content, true);
    }

    public boolean sendMail(List<String> receivers, String subject, String content, boolean isHtmlMsg) {
        if (!this.enabled.booleanValue()) {
            logger.info("Email service is disabled; this mail will not be delivered: " + subject);
            logger.info("To enable mail service, set 'kylin.job.notification-enabled=true' in kylin.properties");
            return false;
        }
        HtmlEmail email = new HtmlEmail();
        email.setHostName(this.host);
        email.setStartTLSEnabled(this.starttlsEnabled.booleanValue());
        if (this.starttlsEnabled.booleanValue()) {
            email.setSslSmtpPort(this.port);
        } else {
            email.setSmtpPort(Integer.parseInt(this.port));
        }
        if (this.username != null && !this.username.trim().isEmpty()) {
            email.setAuthentication(this.username, this.password);
        }
        try {
            for (String receiver : receivers) {
                email.addTo(receiver);
            }
            email.setFrom(this.sender);
            email.setSubject(subject);
            email.setCharset("UTF-8");
            if (isHtmlMsg) {
                email.setHtmlMsg(content);
            } else {
                email.setTextMsg(content);
            }
            email.send();
            email.getMailSession();
        }
        catch (EmailException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

