/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.SourceConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCmdBuilder {
    public static final Logger logger = LoggerFactory.getLogger(HiveCmdBuilder.class);
    static final String CREATE_HQL_TMP_FILE_TEMPLATE = "cat >%s<<EOL\n%sEOL";
    private KylinConfig kylinConfig;
    private final Map<String, String> hiveConfProps;
    private final List<String> statements = Lists.newArrayList();

    public HiveCmdBuilder() {
        this("");
    }

    public HiveCmdBuilder(String jobName) {
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.hiveConfProps = SourceConfigurationUtil.loadHiveConfiguration();
        this.hiveConfProps.putAll(this.kylinConfig.getHiveConfigOverride());
        if (StringUtils.isNotEmpty((String)jobName)) {
            this.addStatement("set mapreduce.job.name=" + jobName + ";");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String build() {
        HiveClientMode clientMode = HiveClientMode.valueOf(this.kylinConfig.getHiveClientMode().toUpperCase(Locale.ROOT));
        String beelineShell = this.kylinConfig.getHiveBeelineShell();
        String beelineParams = this.kylinConfig.getHiveBeelineParams();
        if (this.kylinConfig.getEnableSparkSqlForTableOps()) {
            clientMode = HiveClientMode.BEELINE;
            beelineShell = this.kylinConfig.getSparkSqlBeelineShell();
            beelineParams = this.kylinConfig.getSparkSqlBeelineParams();
            if (StringUtils.isBlank((String)beelineShell)) {
                throw new IllegalStateException("Missing config 'kylin.source.hive.sparksql-beeline-shell', please check kylin.properties");
            }
        }
        StringBuilder buf = new StringBuilder();
        switch (clientMode) {
            case CLI: {
                buf.append("hive -e \"");
                for (String statement : this.statements) {
                    buf.append(statement.replaceAll("`", "\\\\`")).append("\n");
                }
                buf.append("\"");
                buf.append(this.parseProps());
                break;
            }
            case BEELINE: {
                String tmpHqlPath = null;
                StringBuilder hql = new StringBuilder();
                try {
                    tmpHqlPath = "/tmp/" + UUID.randomUUID().toString() + ".hql";
                    for (String statement : this.statements) {
                        hql.append(statement.replaceAll("`", "\\\\`"));
                        hql.append("\n");
                    }
                    String createFileCmd = String.format(Locale.ROOT, CREATE_HQL_TMP_FILE_TEMPLATE, tmpHqlPath, hql);
                    buf.append(createFileCmd);
                    buf.append("\n");
                    buf.append(beelineShell);
                    buf.append(" ");
                    buf.append(beelineParams);
                    buf.append(this.parseProps());
                    buf.append(" -f ");
                    buf.append(tmpHqlPath);
                    buf.append(";ret_code=$?;rm -f ");
                    buf.append(tmpHqlPath);
                    buf.append(";exit $ret_code");
                    break;
                }
                finally {
                    if (tmpHqlPath != null && logger.isDebugEnabled()) {
                        logger.debug("The SQL to execute in beeline: {} \n", (Object)hql);
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Hive client cannot be recognized: " + (Object)((Object)clientMode));
            }
        }
        return buf.toString();
    }

    private String parseProps() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<String, String> prop : this.hiveConfProps.entrySet()) {
            s.append(" --hiveconf ");
            s.append(prop.getKey());
            s.append("=");
            s.append(prop.getValue());
        }
        return s.toString();
    }

    public void reset() {
        this.statements.clear();
        this.hiveConfProps.clear();
    }

    public void setHiveConfProps(Map<String, String> hiveConfProps) {
        this.hiveConfProps.clear();
        this.hiveConfProps.putAll(hiveConfProps);
    }

    public void overwriteHiveProps(Map<String, String> overwrites) {
        this.hiveConfProps.putAll(overwrites);
    }

    public void addStatement(String statement) {
        this.statements.add(statement);
    }

    public List<String> getStatements() {
        return this.statements;
    }

    public void addStatements(String[] stats) {
        for (String s : stats) {
            this.statements.add(s);
        }
    }

    public String toString() {
        return this.build();
    }

    public static enum HiveClientMode {
        CLI,
        BEELINE;

    }
}

