/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.BackwardCompatibilityConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.lock.DistributedLockFactory;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KylinConfigBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(KylinConfigBase.class);
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String DEFAULT = "default";
    private static final String KYLIN_ENGINE_MR_JOB_JAR = "kylin.engine.mr.job-jar";
    private static final String KYLIN_STORAGE_HBASE_COPROCESSOR_LOCAL_JAR = "kylin.storage.hbase.coprocessor-local-jar";
    private static final String FILE_SCHEME = "file:";
    private static final String MAPRFS_SCHEME = "maprfs:";
    static BackwardCompatibilityConfig BCC = new BackwardCompatibilityConfig();
    volatile Properties properties = new Properties();
    private String cachedHdfsWorkingDirectory;
    private String cachedBigCellDirectory;
    private static final Pattern COPROCESSOR_JAR_NAME_PATTERN = Pattern.compile("kylin-coprocessor-(.+)\\.jar");
    private static final Pattern JOB_JAR_NAME_PATTERN = Pattern.compile("kylin-job-(.+)\\.jar");

    public static String getKylinHome() {
        String kylinHome = KylinConfigBase.getKylinHomeWithoutWarn();
        if (StringUtils.isEmpty((String)kylinHome)) {
            logger.warn("KYLIN_HOME was not set");
        }
        return kylinHome;
    }

    public static String getKylinHomeWithoutWarn() {
        String kylinHome = System.getenv("KYLIN_HOME");
        if (StringUtils.isEmpty((String)kylinHome)) {
            kylinHome = System.getProperty("KYLIN_HOME");
        }
        return kylinHome;
    }

    public static String getSparkHome() {
        String sparkHome = System.getenv("SPARK_HOME");
        if (StringUtils.isNotEmpty((String)sparkHome)) {
            logger.info("SPARK_HOME was set to {}", (Object)sparkHome);
            return sparkHome;
        }
        sparkHome = System.getProperty("SPARK_HOME");
        if (StringUtils.isNotEmpty((String)sparkHome)) {
            logger.info("SPARK_HOME was set to {}", (Object)sparkHome);
            return sparkHome;
        }
        return KylinConfigBase.getKylinHome() + File.separator + "spark";
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public KylinConfigBase() {
        this(new Properties());
    }

    public KylinConfigBase(Properties props) {
        this.properties = BCC.check(props);
    }

    protected KylinConfigBase(Properties props, boolean force) {
        this.properties = force ? props : BCC.check(props);
    }

    protected final String getOptional(String prop) {
        return this.getOptional(prop, null);
    }

    protected String getOptional(String prop, String dft) {
        String property = System.getProperty(prop);
        return property != null ? StrSubstitutor.replace((Object)property, System.getenv()) : StrSubstitutor.replace((Object)this.properties.getProperty(prop, dft), System.getenv());
    }

    protected Properties getAllProperties() {
        return this.getProperties(null);
    }

    protected Properties getProperties(Collection<String> propertyKeys) {
        Map<String, String> envMap = System.getenv();
        StrSubstitutor sub = new StrSubstitutor(envMap);
        Properties filteredProperties = new Properties();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            if (propertyKeys != null && !propertyKeys.contains(entry.getKey())) continue;
            filteredProperties.put(entry.getKey(), sub.replace((String)entry.getValue()));
        }
        return filteredProperties;
    }

    protected Properties getRawAllProperties() {
        return this.properties;
    }

    protected final Map<String, String> getPropertiesByPrefix(String prefix) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<Object, Object> entry : this.getAllProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            result.put(key.substring(prefix.length()), (String)entry.getValue());
        }
        return result;
    }

    protected final String[] getOptionalStringArray(String prop, String[] dft) {
        String property = this.getOptional(prop);
        if (!StringUtils.isBlank((String)property)) {
            return property.split("\\s*,\\s*");
        }
        return dft;
    }

    protected final int[] getOptionalIntArray(String prop, String[] dft) {
        String[] strArray = this.getOptionalStringArray(prop, dft);
        int[] intArray = new int[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            intArray[i] = Integer.parseInt(strArray[i]);
        }
        return intArray;
    }

    protected final String getRequired(String prop) {
        String r = this.getOptional(prop);
        if (StringUtils.isEmpty((String)r)) {
            throw new IllegalArgumentException("missing '" + prop + "' in conf/kylin.properties");
        }
        return r;
    }

    public final void setProperty(String key, String value) {
        logger.info("Kylin Config was updated with {} : {}", (Object)key, (Object)value);
        this.properties.setProperty(BCC.check(key), value);
    }

    protected final void reloadKylinConfig(Properties properties) {
        this.properties = BCC.check(properties);
    }

    private Map<Integer, String> convertKeyToInteger(Map<String, String> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(Integer.valueOf(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public String toString() {
        return this.getMetadataUrl().toString();
    }

    public boolean isDevEnv() {
        return "DEV".equals(this.getOptional("kylin.env", "DEV"));
    }

    public String getDeployEnv() {
        return this.getOptional("kylin.env", "DEV");
    }

    public String getHdfsWorkingDirectory() {
        if (this.cachedHdfsWorkingDirectory != null) {
            return this.cachedHdfsWorkingDirectory;
        }
        String root = this.getOptional("kylin.env.hdfs-working-dir", "/kylin");
        Path path = new Path(root);
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("kylin.env.hdfs-working-dir must be absolute, but got " + root);
        }
        try {
            FileSystem fs = path.getFileSystem(HadoopUtil.getCurrentConfiguration());
            path = fs.makeQualified(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        root = new Path(path, StringUtils.replaceChars((String)this.getMetadataUrlPrefix(), (char)':', (char)'-')).toString();
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        this.cachedHdfsWorkingDirectory = root;
        if (this.cachedHdfsWorkingDirectory.startsWith(FILE_SCHEME)) {
            this.cachedHdfsWorkingDirectory = this.cachedHdfsWorkingDirectory.replace(FILE_SCHEME, "file://");
        } else if (this.cachedHdfsWorkingDirectory.startsWith(MAPRFS_SCHEME)) {
            this.cachedHdfsWorkingDirectory = this.cachedHdfsWorkingDirectory.replace(MAPRFS_SCHEME, "maprfs://");
        }
        return this.cachedHdfsWorkingDirectory;
    }

    public String getMetastoreBigCellHdfsDirectory() {
        if (this.cachedBigCellDirectory != null) {
            return this.cachedBigCellDirectory;
        }
        String root = this.getOptional("kylin.env.hdfs-metastore-bigcell-dir");
        if (root == null) {
            return this.getJdbcHdfsWorkingDirectory();
        }
        Path path = new Path(root);
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("kylin.env.hdfs-metastore-bigcell-dir must be absolute, but got " + root);
        }
        try {
            FileSystem fs = HadoopUtil.getReadFileSystem();
            path = fs.makeQualified(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        root = new Path(path, StringUtils.replaceChars((String)this.getMetadataUrlPrefix(), (char)':', (char)'-')).toString();
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        this.cachedBigCellDirectory = root;
        if (this.cachedBigCellDirectory.startsWith(FILE_SCHEME)) {
            this.cachedBigCellDirectory = this.cachedBigCellDirectory.replace(FILE_SCHEME, "file://");
        } else if (this.cachedBigCellDirectory.startsWith(MAPRFS_SCHEME)) {
            this.cachedBigCellDirectory = this.cachedBigCellDirectory.replace(MAPRFS_SCHEME, "maprfs://");
        }
        return this.cachedBigCellDirectory;
    }

    public String getReadHdfsWorkingDirectory() {
        if (StringUtils.isNotEmpty((String)this.getHBaseClusterFs())) {
            Path workingDir = new Path(this.getHdfsWorkingDirectory());
            return new Path(this.getHBaseClusterFs(), Path.getPathWithoutSchemeAndAuthority((Path)workingDir)).toString() + "/";
        }
        return this.getHdfsWorkingDirectory();
    }

    private String getJdbcHdfsWorkingDirectory() {
        if (StringUtils.isNotEmpty((String)this.getJdbcFileSystem())) {
            Path workingDir = new Path(this.getReadHdfsWorkingDirectory());
            return new Path(this.getJdbcFileSystem(), Path.getPathWithoutSchemeAndAuthority((Path)workingDir)).toString() + "/";
        }
        return this.getReadHdfsWorkingDirectory();
    }

    private String getJdbcFileSystem() {
        return this.getOptional("kylin.storage.columnar.jdbc.file-system", "");
    }

    public String getHdfsWorkingDirectory(String project) {
        if (this.isProjectIsolationEnabled() && project != null) {
            return new Path(this.getHdfsWorkingDirectory(), project).toString() + "/";
        }
        return this.getHdfsWorkingDirectory();
    }

    public String getZookeeperBasePath() {
        return this.getOptional("kylin.env.zookeeper-base-path", "/kylin");
    }

    public String getZookeeperConnectString() {
        return this.getOptional("kylin.env.zookeeper-connect-string");
    }

    public int getZKBaseSleepTimeMs() {
        return Integer.parseInt(this.getOptional("kylin.env.zookeeper-base-sleep-time", "3000"));
    }

    public int getZKMaxRetries() {
        return Integer.parseInt(this.getOptional("kylin.env.zookeeper-max-retries", "3"));
    }

    public int getZKMonitorInterval() {
        return Integer.parseInt(this.getOptional("kylin.job.zookeeper-monitor-interval", "30"));
    }

    public boolean isZookeeperAclEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.env.zookeeper-acl-enabled", FALSE));
    }

    public String getZKAuths() {
        return this.getOptional("kylin.env.zookeeper.zk-auth", "digest:ADMIN:KYLIN");
    }

    public String getZKAcls() {
        return this.getOptional("kylin.env.zookeeper.zk-acl", "world:anyone:rwcda");
    }

    public String[] getRestServersWithMode() {
        return this.getOptionalStringArray("kylin.server.cluster-servers-with-mode", new String[0]);
    }

    public StorageURL getMetadataUrl() {
        return StorageURL.valueOf(this.getOptional("kylin.metadata.url", "kylin_metadata@hbase"));
    }

    public int getCacheSyncRetrys() {
        return Integer.parseInt(this.getOptional("kylin.metadata.sync-retries", "3"));
    }

    public String getCacheSyncErrorHandler() {
        return this.getOptional("kylin.metadata.sync-error-handler");
    }

    public void setMetadataUrl(String metadataUrl) {
        this.setProperty("kylin.metadata.url", metadataUrl);
    }

    public String getMetadataUrlPrefix() {
        return this.getMetadataUrl().getIdentifier();
    }

    public Map<String, String> getResourceStoreImpls() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put("", "org.apache.kylin.common.persistence.FileResourceStore");
        r.put("hbase", "org.apache.kylin.storage.hbase.HBaseResourceStore");
        r.put("hdfs", "org.apache.kylin.common.persistence.HDFSResourceStore");
        r.put("ifile", "org.apache.kylin.common.persistence.IdentifierFileResourceStore");
        r.put("jdbc", "org.apache.kylin.common.persistence.JDBCResourceStore");
        r.putAll(this.getPropertiesByPrefix("kylin.metadata.resource-store-provider."));
        return r;
    }

    public boolean isResourceStoreReconnectEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.resourcestore.reconnect-enabled", FALSE));
    }

    public int getResourceStoreReconnectBaseMs() {
        return Integer.parseInt(this.getOptional("kylin.resourcestore.reconnect-base-ms", "1000"));
    }

    public int getResourceStoreReconnectMaxMs() {
        return Integer.parseInt(this.getOptional("kylin.resourcestore.reconnect-max-ms", "60000"));
    }

    public int getResourceStoreReconnectTimeoutMs() {
        return Integer.parseInt(this.getOptional("kylin.resourcestore.reconnect-timeout-ms", "3600000"));
    }

    public String getResourceStoreConnectionExceptions() {
        return this.getOptional("kylin.resourcestore.connection-exceptions", "");
    }

    public String getDataModelImpl() {
        return this.getOptional("kylin.metadata.data-model-impl", null);
    }

    public String getDataModelManagerImpl() {
        return this.getOptional("kylin.metadata.data-model-manager-impl", null);
    }

    public String[] getRealizationProviders() {
        return this.getOptionalStringArray("kylin.metadata.realization-providers", new String[]{"org.apache.kylin.cube.CubeManager", "org.apache.kylin.storage.hybrid.HybridManager"});
    }

    public String[] getCubeDimensionCustomEncodingFactories() {
        return this.getOptionalStringArray("kylin.metadata.custom-dimension-encodings", new String[0]);
    }

    public Map<String, String> getCubeCustomMeasureTypes() {
        return this.getPropertiesByPrefix("kylin.metadata.custom-measure-types.");
    }

    public DistributedLockFactory getDistributedLockFactory() {
        String clsName = this.getOptional("kylin.metadata.distributed-lock-impl", "org.apache.kylin.job.lock.zookeeper.ZookeeperDistributedLock$Factory");
        return (DistributedLockFactory)ClassUtil.newInstance(clsName);
    }

    public String getHBaseMappingAdapter() {
        return this.getOptional("kylin.metadata.hbasemapping-adapter");
    }

    public boolean isCheckCopyOnWrite() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.check-copy-on-write", FALSE));
    }

    public String getHbaseClientScannerTimeoutPeriod() {
        return this.getOptional("kylin.metadata.hbase-client-scanner-timeout-period", "10000");
    }

    public String getHbaseRpcTimeout() {
        return this.getOptional("kylin.metadata.hbase-rpc-timeout", "5000");
    }

    public String getHbaseClientRetriesNumber() {
        return this.getOptional("kylin.metadata.hbase-client-retries-number", "1");
    }

    public boolean isUseForestTrieDictionary() {
        return Boolean.parseBoolean(this.getOptional("kylin.dictionary.use-forest-trie", TRUE));
    }

    public long getTrieDictionaryForestMaxTrieSizeMB() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.forest-trie-max-mb", "500"));
    }

    public long getCachedDictMaxEntrySize() {
        return Long.parseLong(this.getOptional("kylin.dictionary.max-cache-entry", "3000"));
    }

    public int getCachedDictMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.max-cache-size", "-1"));
    }

    public boolean isGrowingDictEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.dictionary.growing-enabled", FALSE));
    }

    public boolean isDictResuable() {
        return Boolean.parseBoolean(this.getOptional("kylin.dictionary.resuable", FALSE));
    }

    public long getCachedDictionaryMaxEntrySize() {
        return Long.parseLong(this.getOptional("kylin.dictionary.cached-dict-max-cache-entry", "50000"));
    }

    public int getAppendDictEntrySize() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.append-entry-size", "10000000"));
    }

    public int getAppendDictMaxVersions() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.append-max-versions", "3"));
    }

    public int getAppendDictVersionTTL() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.append-version-ttl", "259200000"));
    }

    public int getCachedSnapshotMaxEntrySize() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.max-cache-entry", "500"));
    }

    public int getTableSnapshotMaxMB() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.max-mb", "300"));
    }

    public int getExtTableSnapshotShardingMB() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.ext.shard-mb", "500"));
    }

    public String getExtTableSnapshotLocalCachePath() {
        return this.getOptional("kylin.snapshot.ext.local.cache.path", "lookup_cache");
    }

    public double getExtTableSnapshotLocalCacheMaxSizeGB() {
        return Double.parseDouble(this.getOptional("kylin.snapshot.ext.local.cache.max-size-gb", "200"));
    }

    public long getExtTableSnapshotLocalCacheCheckVolatileRange() {
        return Long.parseLong(this.getOptional("kylin.snapshot.ext.local.cache.check.volatile", "3600000"));
    }

    public boolean isShrunkenDictFromGlobalEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.dictionary.shrunken-from-global-enabled", TRUE));
    }

    public int getDictionarySliceEvicationThreshold() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.slice.eviction.threshold", "5"));
    }

    public String[] getMrHiveDictColumns() {
        String columnStr = this.getOptional("kylin.dictionary.mr-hive.columns", "");
        if (!columnStr.equals("")) {
            return columnStr.split(",");
        }
        return new String[0];
    }

    public String getMrHiveDictDB() {
        return this.getOptional("kylin.dictionary.mr-hive.database", this.getHiveDatabaseForIntermediateTable());
    }

    public String getMrHiveDictTableSuffix() {
        return this.getOptional("kylin.dictionary.mr-hive.table.suffix", "_global_dict");
    }

    public String getCuboidScheduler() {
        return this.getOptional("kylin.cube.cuboid-scheduler", "org.apache.kylin.cube.cuboid.DefaultCuboidScheduler");
    }

    public String getSegmentAdvisor() {
        return this.getOptional("kylin.cube.segment-advisor", "org.apache.kylin.cube.CubeSegmentAdvisor");
    }

    public double getJobCuboidSizeRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.size-estimate-ratio", "0.25"));
    }

    @Deprecated
    public double getJobCuboidSizeMemHungryRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.size-estimate-memhungry-ratio", "0.05"));
    }

    public double getJobCuboidSizeCountDistinctRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.size-estimate-countdistinct-ratio", "0.5"));
    }

    public double getJobCuboidSizeTopNRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.size-estimate-topn-ratio", "0.5"));
    }

    public String getCubeAlgorithm() {
        return this.getOptional("kylin.cube.algorithm", "auto");
    }

    public double getCubeAlgorithmAutoThreshold() {
        return Double.parseDouble(this.getOptional("kylin.cube.algorithm.layer-or-inmem-threshold", "7"));
    }

    public boolean isAutoInmemToOptimize() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.algorithm.inmem-auto-optimize", TRUE));
    }

    public int getCubeAlgorithmAutoMapperLimit() {
        return Integer.parseInt(this.getOptional("kylin.cube.algorithm.inmem-split-limit", "500"));
    }

    public int getCubeAlgorithmInMemConcurrentThreads() {
        return Integer.parseInt(this.getOptional("kylin.cube.algorithm.inmem-concurrent-threads", "1"));
    }

    public boolean isIgnoreCubeSignatureInconsistency() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.ignore-signature-inconsistency", FALSE));
    }

    public long getCubeAggrGroupMaxCombination() {
        return Long.parseLong(this.getOptional("kylin.cube.aggrgroup.max-combination", "32768"));
    }

    public boolean getCubeAggrGroupIsMandatoryOnlyValid() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.aggrgroup.is-mandatory-only-valid", FALSE));
    }

    public int getCubeRowkeyMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.cube.rowkey.max-size", "63"));
    }

    public int getDimensionEncodingMaxLength() {
        return Integer.parseInt(this.getOptional("kylin.metadata.dimension-encoding-max-length", "256"));
    }

    public int getMaxBuildingSegments() {
        return Integer.parseInt(this.getOptional("kylin.cube.max-building-segments", "10"));
    }

    public long getMaxSegmentMergeSpan() {
        return Long.parseLong(this.getOptional("kylin.cube.max-segment-merge.span", "-1"));
    }

    public boolean allowCubeAppearInMultipleProjects() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.allow-appear-in-multiple-projects", FALSE));
    }

    public int getGTScanRequestSerializationLevel() {
        return Integer.parseInt(this.getOptional("kylin.cube.gtscanrequest-serialization-level", "1"));
    }

    public boolean isAutoMergeEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.is-automerge-enabled", TRUE));
    }

    public String[] getCubeMetadataExtraValidators() {
        return this.getOptionalStringArray("kylin.cube.metadata-extra-validators", new String[0]);
    }

    public boolean isCubePlannerEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.cubeplanner.enabled", TRUE));
    }

    public boolean isCubePlannerEnabledForExistingCube() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.cubeplanner.enabled-for-existing-cube", TRUE));
    }

    public double getCubePlannerExpansionRateThreshold() {
        return Double.parseDouble(this.getOptional("kylin.cube.cubeplanner.expansion-threshold", "15.0"));
    }

    public int getCubePlannerRecommendCuboidCacheMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.cube.cubeplanner.recommend-cache-max-size", "200"));
    }

    public double getCubePlannerQueryUncertaintyRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.cubeplanner.query-uncertainty-ratio", "0.1"));
    }

    public double getCubePlannerBPUSMinBenefitRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.cubeplanner.bpus-min-benefit-ratio", "0.01"));
    }

    public int getCubePlannerAgreedyAlgorithmAutoThreshold() {
        return Integer.parseInt(this.getOptional("kylin.cube.cubeplanner.algorithm-threshold-greedy", "8"));
    }

    public int getCubePlannerGeneticAlgorithmAutoThreshold() {
        return Integer.parseInt(this.getOptional("kylin.cube.cubeplanner.algorithm-threshold-genetic", "23"));
    }

    public CliCommandExecutor getCliCommandExecutor() {
        CliCommandExecutor exec = new CliCommandExecutor();
        if (this.getRunAsRemoteCommand()) {
            exec.setRunAtRemote(this.getRemoteHadoopCliHostname(), this.getRemoteHadoopCliPort(), this.getRemoteHadoopCliUsername(), this.getRemoteHadoopCliPassword());
        }
        return exec;
    }

    public String getKylinJobLogDir() {
        return this.getOptional("kylin.job.log-dir", "/tmp/kylin/logs");
    }

    public boolean getRunAsRemoteCommand() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.use-remote-cli"));
    }

    public int getRemoteHadoopCliPort() {
        return Integer.parseInt(this.getOptional("kylin.job.remote-cli-port", "22"));
    }

    public String getRemoteHadoopCliHostname() {
        return this.getOptional("kylin.job.remote-cli-hostname");
    }

    public String getRemoteHadoopCliUsername() {
        return this.getOptional("kylin.job.remote-cli-username");
    }

    public String getRemoteHadoopCliPassword() {
        return this.getOptional("kylin.job.remote-cli-password");
    }

    public String getCliWorkingDir() {
        return this.getOptional("kylin.job.remote-cli-working-dir");
    }

    public boolean isEmptySegmentAllowed() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.allow-empty-segment", TRUE));
    }

    public int getMaxConcurrentJobLimit() {
        return Integer.parseInt(this.getOptional("kylin.job.max-concurrent-jobs", "10"));
    }

    public int getCubingInMemSamplingPercent() {
        int percent = Integer.parseInt(this.getOptional("kylin.job.sampling-percentage", "100"));
        percent = Math.max(percent, 1);
        percent = Math.min(percent, 100);
        return percent;
    }

    public String getHiveDependencyFilterList() {
        return this.getOptional("kylin.job.dependency-filter-list", "[^,]*hive-exec[^,]*?\\.jar|[^,]*hive-metastore[^,]*?\\.jar|[^,]*hive-hcatalog-core[^,]*?\\.jar");
    }

    public boolean isMailEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.notification-enabled", FALSE));
    }

    public boolean isStarttlsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.notification-mail-enable-starttls", FALSE));
    }

    public String getSmtpPort() {
        return this.getOptional("kylin.job.notification-mail-port", "25");
    }

    public String getMailHost() {
        return this.getOptional("kylin.job.notification-mail-host", "");
    }

    public String getMailUsername() {
        return this.getOptional("kylin.job.notification-mail-username", "");
    }

    public String getMailPassword() {
        return this.getOptional("kylin.job.notification-mail-password", "");
    }

    public String getMailSender() {
        return this.getOptional("kylin.job.notification-mail-sender", "");
    }

    public String[] getAdminDls() {
        return this.getOptionalStringArray("kylin.job.notification-admin-emails", null);
    }

    public int getJobRetry() {
        return Integer.parseInt(this.getOptional("kylin.job.retry", "0"));
    }

    public int getJobRetryInterval() {
        return Integer.parseInt(this.getOptional("kylin.job.retry-interval", "30000"));
    }

    public String[] getJobRetryExceptions() {
        return this.getOptionalStringArray("kylin.job.retry-exception-classes", new String[0]);
    }

    public int getCubeStatsHLLPrecision() {
        return Integer.parseInt(this.getOptional("kylin.job.sampling-hll-precision", "14"));
    }

    public Map<Integer, String> getSchedulers() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put(0, "org.apache.kylin.job.impl.threadpool.DefaultScheduler");
        r.put(2, "org.apache.kylin.job.impl.threadpool.DistributedScheduler");
        r.put(77, "org.apache.kylin.job.impl.threadpool.NoopScheduler");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.job.scheduler.provider.")));
        return r;
    }

    public Integer getSchedulerType() {
        return Integer.parseInt(this.getOptional("kylin.job.scheduler.default", "0"));
    }

    public boolean getSchedulerPriorityConsidered() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.scheduler.priority-considered", FALSE));
    }

    public Integer getSchedulerPriorityBarFetchFromQueue() {
        return Integer.parseInt(this.getOptional("kylin.job.scheduler.priority-bar-fetch-from-queue", "20"));
    }

    public Integer getSchedulerPollIntervalSecond() {
        return Integer.parseInt(this.getOptional("kylin.job.scheduler.poll-interval-second", "30"));
    }

    public boolean isSchedulerSafeMode() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.scheduler.safemode", FALSE));
    }

    public List<String> getSafeModeRunnableProjects() {
        return Arrays.asList(this.getOptionalStringArray("kylin.job.scheduler.safemode.runnable-projects", new String[0]));
    }

    public Integer getErrorRecordThreshold() {
        return Integer.parseInt(this.getOptional("kylin.job.error-record-threshold", "0"));
    }

    public boolean isAdvancedFlatTableUsed() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.use-advanced-flat-table", FALSE));
    }

    public String getAdvancedFlatTableClass() {
        return this.getOptional("kylin.job.advanced-flat-table.class");
    }

    public String getJobTrackingURLPattern() {
        return this.getOptional("kylin.job.tracking-url-pattern", "");
    }

    public int getJobMetadataPersistRetry() {
        return Integer.parseInt(this.getOptional("kylin.job.metadata-persist-retry", "5"));
    }

    public boolean isJobAutoReadyCubeEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.cube-auto-ready-enabled", TRUE));
    }

    public String getCubeInMemBuilderClass() {
        return this.getOptional("kylin.job.cube-inmem-builder-class", "org.apache.kylin.cube.inmemcubing.DoggedCubeBuilder");
    }

    public int getJobOutputMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.job.execute-output.max-size", "10485760"));
    }

    public int getDefaultSource() {
        return Integer.parseInt(this.getOptional("kylin.source.default", "0"));
    }

    public Map<Integer, String> getSourceEngines() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put(0, "org.apache.kylin.source.hive.HiveSource");
        r.put(1, "org.apache.kylin.source.kafka.KafkaSource");
        r.put(8, "org.apache.kylin.source.jdbc.JdbcSource");
        r.put(16, "org.apache.kylin.source.jdbc.extensible.JdbcSource");
        r.put(20, "org.apache.kylin.stream.source.kafka.KafkaBatchSourceAdaptor");
        r.put(21, "org.apache.kylin.stream.source.kafka.KafkaBatchSourceAdaptor");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.source.provider.")));
        return r;
    }

    public boolean enableHiveDdlQuote() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.quote-enabled", TRUE));
    }

    public String getQuoteCharacter() {
        return this.getOptional("kylin.source.quote.character", "`");
    }

    @Deprecated
    public String getHiveUrl() {
        return this.getOptional("kylin.source.hive.connection-url", "");
    }

    @Deprecated
    public String getHiveUser() {
        return this.getOptional("kylin.source.hive.connection-user", "");
    }

    @Deprecated
    public String getHivePassword() {
        return this.getOptional("kylin.source.hive.connection-password", "");
    }

    public Map<String, String> getHiveConfigOverride() {
        return this.getPropertiesByPrefix("kylin.source.hive.config-override.");
    }

    public String getOverrideHiveTableLocation(String table) {
        return this.getOptional("kylin.source.hive.table-location." + table.toUpperCase(Locale.ROOT));
    }

    public boolean isHiveKeepFlatTable() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.keep-flat-table", FALSE));
    }

    public String getHiveDatabaseForIntermediateTable() {
        return this.getOptional("kylin.source.hive.database-for-flat-table", DEFAULT);
    }

    public String getFlatTableStorageFormat() {
        return this.getOptional("kylin.source.hive.flat-table-storage-format", "SEQUENCEFILE");
    }

    public String getFlatTableFieldDelimiter() {
        return this.getOptional("kylin.source.hive.flat-table-field-delimiter", "\u001f");
    }

    public boolean isHiveRedistributeEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.redistribute-flat-table", TRUE));
    }

    public String getHiveClientMode() {
        return this.getOptional("kylin.source.hive.client", "cli");
    }

    public String getHiveBeelineShell() {
        return this.getOptional("kylin.source.hive.beeline-shell", "beeline");
    }

    public String getHiveBeelineParams() {
        return this.getOptional("kylin.source.hive.beeline-params", "");
    }

    public boolean getEnableSparkSqlForTableOps() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.enable-sparksql-for-table-ops", FALSE));
    }

    public String getSparkSqlBeelineShell() {
        return this.getOptional("kylin.source.hive.sparksql-beeline-shell", "");
    }

    public String getSparkSqlBeelineParams() {
        return this.getOptional("kylin.source.hive.sparksql-beeline-params", "");
    }

    public boolean getHiveTableDirCreateFirst() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.table-dir-create-first", FALSE));
    }

    public String getFlatHiveTableClusterByDictColumn() {
        return this.getOptional("kylin.source.hive.flat-table-cluster-by-dict-column");
    }

    public int getHiveRedistributeColumnCount() {
        return Integer.parseInt(this.getOptional("kylin.source.hive.redistribute-column-count", "3"));
    }

    public int getDefaultVarcharPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-varchar-precision", "256"));
        if (v < 1) {
            return 256;
        }
        if (v > 65535) {
            return 65535;
        }
        return v;
    }

    public int getDefaultCharPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-char-precision", "255"));
        if (v < 1) {
            return 255;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    public int getDefaultDecimalPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-decimal-precision", "19"));
        if (v < 1) {
            return 19;
        }
        return v;
    }

    public int getDefaultDecimalScale() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-decimal-scale", "4"));
        if (v < 1) {
            return 4;
        }
        return v;
    }

    public String getHiveIntermediateTablePrefix() {
        return this.getOptional("kylin.source.hive.intermediate-table-prefix", "kylin_intermediate_");
    }

    public String getHiveMetaDataType() {
        return this.getOptional("kylin.source.hive.metadata-type", "hcatalog");
    }

    public Map<String, String> getKafkaConfigOverride() {
        return this.getPropertiesByPrefix("kylin.source.kafka.config-override.");
    }

    public String getJdbcSourceConnectionUrl() {
        return this.getOptional("kylin.source.jdbc.connection-url");
    }

    public String getJdbcSourceDriver() {
        return this.getOptional("kylin.source.jdbc.driver");
    }

    public String getJdbcSourceDialect() {
        return this.getOptional("kylin.source.jdbc.dialect", DEFAULT);
    }

    public String getJdbcSourceUser() {
        return this.getOptional("kylin.source.jdbc.user");
    }

    public String getJdbcSourcePass() {
        return this.getOptional("kylin.source.jdbc.pass");
    }

    public String getSqoopHome() {
        return this.getOptional("kylin.source.jdbc.sqoop-home");
    }

    public int getSqoopMapperNum() {
        return Integer.parseInt(this.getOptional("kylin.source.jdbc.sqoop-mapper-num", "4"));
    }

    public String getSqoopNullString() {
        return this.getOptional("kylin.source.jdbc.sqoop-null-string", "\\\\N");
    }

    public String getSqoopNullNonString() {
        return this.getOptional("kylin.source.jdbc.sqoop-null-non-string", "\\\\N");
    }

    public Map<String, String> getSqoopConfigOverride() {
        return this.getPropertiesByPrefix("kylin.source.jdbc.sqoop-config-override.");
    }

    public String getJdbcSourceFieldDelimiter() {
        return this.getOptional("kylin.source.jdbc.field-delimiter", "|");
    }

    public Map<Integer, String> getStorageEngines() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put(0, "org.apache.kylin.storage.hbase.HBaseStorage");
        r.put(1, "org.apache.kylin.storage.hybrid.HybridStorage");
        r.put(2, "org.apache.kylin.storage.hbase.HBaseStorage");
        r.put(3, "org.apache.kylin.storage.stream.StreamStorage");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.storage.provider.")));
        return r;
    }

    public int getDefaultStorageEngine() {
        return Integer.parseInt(this.getOptional("kylin.storage.default", "2"));
    }

    public StorageURL getStorageUrl() {
        String url = this.getOptional("kylin.storage.url", "default@hbase");
        if ("hbase".equals(url)) {
            url = "default@hbase";
        }
        return StorageURL.valueOf(url);
    }

    public StorageURL getSecondaryStorageUrl() {
        String url = this.getOptional("kylin.secondary.storage.url", "");
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        return StorageURL.valueOf(url);
    }

    public String getHBaseTableNamePrefix() {
        return this.getOptional("kylin.storage.hbase.table-name-prefix", "KYLIN_");
    }

    public String getHBaseStorageNameSpace() {
        return this.getOptional("kylin.storage.hbase.namespace", DEFAULT);
    }

    public String getHBaseClusterFs() {
        return this.getOptional("kylin.storage.hbase.cluster-fs", "");
    }

    public String getHBaseClusterHDFSConfigFile() {
        return this.getOptional("kylin.storage.hbase.cluster-hdfs-config-file", "");
    }

    public String getCoprocessorLocalJar() {
        String coprocessorJar = this.getOptional(KYLIN_STORAGE_HBASE_COPROCESSOR_LOCAL_JAR);
        if (StringUtils.isNotEmpty((String)coprocessorJar)) {
            return coprocessorJar;
        }
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty((String)kylinHome)) {
            throw new RuntimeException("getCoprocessorLocalJar needs KYLIN_HOME");
        }
        return KylinConfigBase.getFileName(kylinHome + File.separator + "lib", COPROCESSOR_JAR_NAME_PATTERN);
    }

    public void overrideCoprocessorLocalJar(String path) {
        logger.info("override {} to {}", (Object)KYLIN_STORAGE_HBASE_COPROCESSOR_LOCAL_JAR, (Object)path);
        System.setProperty(KYLIN_STORAGE_HBASE_COPROCESSOR_LOCAL_JAR, path);
    }

    private static String getFileName(String homePath, Pattern pattern) {
        File[] listFiles;
        File home = new File(homePath);
        TreeSet files = Sets.newTreeSet();
        if (home.exists() && home.isDirectory() && (listFiles = home.listFiles()) != null) {
            for (File file : listFiles) {
                Matcher matcher = pattern.matcher(file.getName());
                if (!matcher.matches()) continue;
                files.add(file.getAbsolutePath());
            }
        }
        if (files.isEmpty()) {
            throw new RuntimeException("cannot find " + pattern.toString() + " in " + homePath);
        }
        return (String)files.last();
    }

    public int getHBaseRegionCountMin() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.min-region-count", "1"));
    }

    public int getHBaseRegionCountMax() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-region-count", "500"));
    }

    public float getHBaseHFileSizeGB() {
        return Float.parseFloat(this.getOptional("kylin.storage.hbase.hfile-size-gb", "2.0"));
    }

    public boolean getQueryRunLocalCoprocessor() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.hbase.run-local-coprocessor", FALSE));
    }

    public double getQueryCoprocessorMemGB() {
        return Double.parseDouble(this.getOptional("kylin.storage.hbase.coprocessor-mem-gb", "3.0"));
    }

    public boolean getQueryCoprocessorSpillEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.partition.aggr-spill-enabled", TRUE));
    }

    public long getPartitionMaxScanBytes() {
        long value = Long.parseLong(this.getOptional("kylin.storage.partition.max-scan-bytes", String.valueOf(0xC0000000L)));
        return value > 0L ? value : Long.MAX_VALUE;
    }

    public int getQueryCoprocessorTimeoutSeconds() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.coprocessor-timeout-seconds", "0"));
    }

    public int getQueryScanFuzzyKeyMax() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-fuzzykey-scan", "200"));
    }

    public int getQueryScanFuzzyKeySplitMax() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-fuzzykey-scan-split", "1"));
    }

    public int getQueryStorageVisitScanRangeMax() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-visit-scanrange", "1000000"));
    }

    public String getDefaultIGTStorage() {
        return this.getOptional("kylin.storage.hbase.gtstorage", "org.apache.kylin.storage.hbase.cube.v2.CubeHBaseEndpointRPC");
    }

    public int getHBaseScanCacheRows() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.scan-cache-rows", "1024"));
    }

    public float getKylinHBaseRegionCut() {
        return Float.parseFloat(this.getOptional("kylin.storage.hbase.region-cut-gb", "5.0"));
    }

    public int getHBaseScanMaxResultSize() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-scan-result-bytes", "5242880"));
    }

    public String getHbaseDefaultCompressionCodec() {
        return this.getOptional("kylin.storage.hbase.compression-codec", "none");
    }

    public String getHbaseDefaultEncoding() {
        return this.getOptional("kylin.storage.hbase.rowkey-encoding", "FAST_DIFF");
    }

    public int getHbaseDefaultBlockSize() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.block-size-bytes", "1048576"));
    }

    public int getHbaseSmallFamilyBlockSize() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.small-family-block-size-bytes", "65536"));
    }

    public String getKylinOwner() {
        return this.getOptional("kylin.storage.hbase.owner-tag", "");
    }

    public boolean getCompressionResult() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.hbase.endpoint-compress-result", TRUE));
    }

    public int getHBaseMaxConnectionThreads() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-hconnection-threads", "2048"));
    }

    public int getHBaseCoreConnectionThreads() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.core-hconnection-threads", "2048"));
    }

    public long getHBaseConnectionThreadPoolAliveSeconds() {
        return Long.parseLong(this.getOptional("kylin.storage.hbase.hconnection-threads-alive-seconds", "60"));
    }

    public int getHBaseReplicationScope() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.replication-scope", "0"));
    }

    public boolean cleanStorageAfterDelOperation() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.clean-after-delete-operation", FALSE));
    }

    public Map<Integer, String> getJobEngines() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put(0, "org.apache.kylin.engine.mr.MRBatchCubingEngine");
        r.put(2, "org.apache.kylin.engine.mr.MRBatchCubingEngine2");
        r.put(4, "org.apache.kylin.engine.spark.SparkBatchCubingEngine2");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.engine.provider.")));
        return r;
    }

    public int getDefaultCubeEngine() {
        return Integer.parseInt(this.getOptional("kylin.engine.default", "2"));
    }

    public String getKylinJobJarPath() {
        String jobJar = this.getOptional(KYLIN_ENGINE_MR_JOB_JAR);
        if (StringUtils.isNotEmpty((String)jobJar)) {
            return jobJar;
        }
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty((String)kylinHome)) {
            return "";
        }
        return KylinConfigBase.getFileName(kylinHome + File.separator + "lib", JOB_JAR_NAME_PATTERN);
    }

    public void overrideMRJobJarPath(String path) {
        logger.info("override {} to {}", (Object)KYLIN_ENGINE_MR_JOB_JAR, (Object)path);
        System.setProperty(KYLIN_ENGINE_MR_JOB_JAR, path);
    }

    public String getKylinJobMRLibDir() {
        return this.getOptional("kylin.engine.mr.lib-dir", "");
    }

    public Map<String, String> getMRConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.mr.config-override.");
    }

    public Map<String, String> getMemHungryConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.mr.mem-hungry-config-override.");
    }

    public Map<String, String> getUHCMRConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.mr.uhc-config-override.");
    }

    public Map<String, String> getBaseCuboidMRConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.mr.base-cuboid-config-override.");
    }

    public Map<String, String> getSparkConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.spark-conf.");
    }

    public Map<String, String> getSparkConfigOverrideWithSpecificName(String configName) {
        return this.getPropertiesByPrefix("kylin.engine.spark-conf-" + configName + ".");
    }

    public double getDefaultHadoopJobReducerInputMB() {
        return Double.parseDouble(this.getOptional("kylin.engine.mr.reduce-input-mb", "500"));
    }

    public double getDefaultHadoopJobReducerCountRatio() {
        return Double.parseDouble(this.getOptional("kylin.engine.mr.reduce-count-ratio", "1.0"));
    }

    public int getHadoopJobMinReducerNumber() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.min-reducer-number", "1"));
    }

    public int getHadoopJobMaxReducerNumber() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.max-reducer-number", "500"));
    }

    public int getHadoopJobMapperInputRows() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.mapper-input-rows", "1000000"));
    }

    public int getCuboidStatsCalculatorMaxNumber() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.max-cuboid-stats-calculator-number", "1"));
    }

    public int getCuboidNumberPerStatsCalculator() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.cuboid-number-per-stats-calculator", "100"));
    }

    public int getHadoopJobPerReducerHLLCuboidNumber() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.per-reducer-hll-cuboid-number", "100"));
    }

    public int getHadoopJobHLLMaxReducerNumber() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.hll-max-reducer-number", "1"));
    }

    public int getUHCReducerCount() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.uhc-reducer-count", "3"));
    }

    public boolean isBuildUHCDictWithMREnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.mr.build-uhc-dict-in-additional-step", FALSE));
    }

    public boolean isBuildDictInReducerEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.mr.build-dict-in-reducer", TRUE));
    }

    public String getYarnStatusCheckUrl() {
        return this.getOptional("kylin.engine.mr.yarn-check-status-url", null);
    }

    public int getYarnStatusCheckIntervalSeconds() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.yarn-check-interval-seconds", "10"));
    }

    public boolean isUseLocalClasspathEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.mr.use-local-classpath", TRUE));
    }

    public String getHiveUnionStyle() {
        return this.getOptional("kylin.hive.union.style", "UNION");
    }

    public String getHadoopConfDir() {
        return this.getOptional("kylin.env.hadoop-conf-dir", "");
    }

    public String getSparkAdditionalJars() {
        return this.getOptional("kylin.engine.spark.additional-jars", "");
    }

    public float getSparkRDDPartitionCutMB() {
        return Float.parseFloat(this.getOptional("kylin.engine.spark.rdd-partition-cut-mb", "10.0"));
    }

    public int getSparkMinPartition() {
        return Integer.parseInt(this.getOptional("kylin.engine.spark.min-partition", "1"));
    }

    public int getSparkMaxPartition() {
        return Integer.parseInt(this.getOptional("kylin.engine.spark.max-partition", "5000"));
    }

    public String getSparkStorageLevel() {
        return this.getOptional("kylin.engine.spark.storage-level", "MEMORY_AND_DISK_SER");
    }

    public boolean isSparkSanityCheckEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.spark.sanity-check-enabled", FALSE));
    }

    public boolean isSparkFactDistinctEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.spark-fact-distinct", FALSE));
    }

    public boolean isSparkCardinalityEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.spark-cardinality", FALSE));
    }

    public int getSparkOutputMaxSize() {
        return Integer.valueOf(this.getOptional("kylin.engine.spark.output.max-size", "10485760"));
    }

    public boolean isSparkDimensionDictionaryEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.spark-dimension-dictionary", FALSE));
    }

    public boolean isLivyEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.livy-conf.livy-enabled", FALSE));
    }

    public String getLivyRestApiBacktick() {
        return this.getOptional("kylin.engine.livy.backtick.quote", "");
    }

    public String getLivyUrl() {
        return this.getOptional("kylin.engine.livy-conf.livy-url");
    }

    public Map<String, String> getLivyKey() {
        return this.getPropertiesByPrefix("kylin.engine.livy-conf.livy-key.");
    }

    public Map<String, String> getLivyArr() {
        return this.getPropertiesByPrefix("kylin.engine.livy-conf.livy-arr.");
    }

    public Map<String, String> getLivyMap() {
        return this.getPropertiesByPrefix("kylin.engine.livy-conf.livy-map.");
    }

    public boolean isDictionaryEnumeratorEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.enable-dict-enumerator", FALSE));
    }

    public boolean isEnumerableRulesEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.calcite.enumerable-rules-enabled", FALSE));
    }

    public boolean isReduceExpressionsRulesEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.calcite.reduce-rules-enabled", TRUE));
    }

    public boolean isConvertCreateTableToWith() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.convert-create-table-to-with", FALSE));
    }

    public Properties getCalciteExtrasProperties() {
        Properties properties = new Properties();
        Map<String, String> map = this.getPropertiesByPrefix("kylin.query.calcite.extras-props.");
        properties.putAll(map);
        return properties;
    }

    public List<String> getCalciteAddRule() {
        String rules = this.getOptional("kylin.query.calcite.add-rule");
        if (rules == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])rules.split(","));
    }

    public List<String> getCalciteRemoveRule() {
        String rules = this.getOptional("kylin.query.calcite.remove-rule");
        if (rules == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])rules.split(","));
    }

    public boolean isDynamicColumnEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.enable-dynamic-column", FALSE));
    }

    public boolean isSkippingEmptySegments() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.skip-empty-segments", TRUE));
    }

    public boolean isDisableCubeNoAggSQL() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.disable-cube-noagg-sql", FALSE));
    }

    public boolean isStreamAggregateEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.stream-aggregate-enabled", TRUE));
    }

    public boolean isProjectIsolationEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.project-isolation-enable", TRUE));
    }

    @Deprecated
    public int getStoragePushDownLimitMax() {
        return Integer.parseInt(this.getOptional("kylin.query.max-limit-pushdown", "10000"));
    }

    public int getForceLimit() {
        return Integer.parseInt(this.getOptional("kylin.query.force-limit", "-1"));
    }

    @Deprecated
    public int getScanThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.scan-threshold", "10000000"));
    }

    public boolean isLazyQueryEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.lazy-query-enabled", FALSE));
    }

    public long getLazyQueryWaitingTimeoutMilliSeconds() {
        return Long.parseLong(this.getOptional("kylin.query.lazy-query-waiting-timeout-milliseconds", "60000"));
    }

    public int getQueryConcurrentRunningThresholdForProject() {
        return Integer.parseInt(this.getOptional("kylin.query.project-concurrent-running-threshold", "0"));
    }

    public long getQueryMaxScanBytes() {
        long value = Long.parseLong(this.getOptional("kylin.query.max-scan-bytes", "0"));
        return value > 0L ? value : Long.MAX_VALUE;
    }

    public long getQueryMaxReturnRows() {
        return Integer.parseInt(this.getOptional("kylin.query.max-return-rows", "5000000"));
    }

    public int getTranslatedInClauseMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.query.translated-in-clause-max-size", String.valueOf(0x100000)));
    }

    public int getLargeQueryThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.large-query-threshold", String.valueOf(1000000)));
    }

    public int getDerivedInThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.derived-filter-translation-threshold", "20"));
    }

    public int getBadQueryStackTraceDepth() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery-stacktrace-depth", "10"));
    }

    public int getBadQueryHistoryNum() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery-history-number", "50"));
    }

    public int getBadQueryDefaultAlertingSeconds() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery-alerting-seconds", "90"));
    }

    public double getBadQueryDefaultAlertingCoefficient() {
        return Double.parseDouble(this.getOptional("kylin.query.timeout-seconds-coefficient", "0.5"));
    }

    public int getBadQueryDefaultDetectIntervalSeconds() {
        int time = (int)((double)this.getQueryTimeoutSeconds() * this.getBadQueryDefaultAlertingCoefficient());
        if (time == 0) {
            time = 60;
        }
        return time;
    }

    public boolean getBadQueryPersistentEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.badquery-persistent-enabled", TRUE));
    }

    public String[] getQueryTransformers() {
        return this.getOptionalStringArray("kylin.query.transformers", new String[0]);
    }

    public String[] getQueryInterceptors() {
        return this.getOptionalStringArray("kylin.query.interceptors", new String[0]);
    }

    public long getQueryDurationCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-duration", String.valueOf(2000)));
    }

    public long getQueryScanCountCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-scan-count", String.valueOf(10240)));
    }

    public long getQueryScanBytesCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-scan-bytes", String.valueOf(0x100000)));
    }

    public boolean isQuerySecureEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.security-enabled", TRUE));
    }

    public boolean isQueryCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.cache-enabled", TRUE));
    }

    public boolean isQueryIgnoreUnknownFunction() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.ignore-unknown-function", FALSE));
    }

    public String getMemCachedHosts() {
        return this.getRequired("kylin.cache.memcached.hosts");
    }

    public boolean isQuerySegmentCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.segment-cache-enabled", FALSE));
    }

    public int getQuerySegmentCacheTimeout() {
        return Integer.parseInt(this.getOptional("kylin.query.segment-cache-timeout", "2000"));
    }

    public int getQuerySegmentCacheMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.query.segment-cache-max-size", "200"));
    }

    public String getQueryAccessController() {
        return this.getOptional("kylin.query.access-controller", null);
    }

    public int getQueryMaxCacheStatementNum() {
        return Integer.parseInt(this.getOptional("kylin.query.statement-cache-max-num", String.valueOf(50000)));
    }

    public int getQueryMaxCacheStatementInstancePerKey() {
        return Integer.parseInt(this.getOptional("kylin.query.statement-cache-max-num-per-key", String.valueOf(50)));
    }

    public boolean isQueryPreparedStatementCacheEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.statement-cache-enabled", TRUE));
    }

    public int getDimCountDistinctMaxCardinality() {
        return Integer.parseInt(this.getOptional("kylin.query.max-dimension-count-distinct", "5000000"));
    }

    public Map<String, String> getUDFs() {
        LinkedHashMap udfMap = Maps.newLinkedHashMap();
        udfMap.put("version", "org.apache.kylin.query.udf.VersionUDF");
        udfMap.put("concat", "org.apache.kylin.query.udf.ConcatUDF");
        udfMap.put("massin", "org.apache.kylin.query.udf.MassInUDF");
        Map<String, String> overrideUdfMap = this.getPropertiesByPrefix("kylin.query.udf.");
        udfMap.putAll(overrideUdfMap);
        return udfMap;
    }

    public int getQueryTimeoutSeconds() {
        int time = Integer.parseInt(this.getOptional("kylin.query.timeout-seconds", "0"));
        if (time != 0 && time <= 60) {
            logger.warn("query timeout seconds less than 60 sec, set to 60 sec.");
            time = 60;
        }
        return time;
    }

    public boolean isPushDownEnabled() {
        return StringUtils.isNotEmpty((String)this.getPushDownRunnerClassName());
    }

    public boolean isPushDownUpdateEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.update-enabled", FALSE));
    }

    public String getSchemaFactory() {
        return this.getOptional("kylin.query.schema-factory", "org.apache.kylin.query.schema.OLAPSchemaFactory");
    }

    public String getPushDownRunnerClassName() {
        return this.getOptional("kylin.query.pushdown.runner-class-name", "");
    }

    public String[] getPushDownConverterClassNames() {
        return this.getOptionalStringArray("kylin.query.pushdown.converter-class-names", new String[]{"org.apache.kylin.source.adhocquery.HivePushDownConverter"});
    }

    public boolean isPushdownQueryCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.cache-enabled", FALSE));
    }

    public String getJdbcUrl() {
        return this.getOptional("kylin.query.pushdown.jdbc.url", "");
    }

    public String getJdbcDriverClass() {
        return this.getOptional("kylin.query.pushdown.jdbc.driver", "");
    }

    public String getJdbcUsername() {
        return this.getOptional("kylin.query.pushdown.jdbc.username", "");
    }

    public String getJdbcPassword() {
        return this.getOptional("kylin.query.pushdown.jdbc.password", "");
    }

    public int getPoolMaxTotal() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-max-total", "8"));
    }

    public int getPoolMaxIdle() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-max-idle", "8"));
    }

    public int getPoolMinIdle() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-min-idle", "0"));
    }

    public boolean isTableACLEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.security.table-acl-enabled", TRUE));
    }

    public boolean isEscapeDefaultKeywordEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.escape-default-keyword", FALSE));
    }

    public String getQueryRealizationFilter() {
        return this.getOptional("kylin.query.realization-filter", null);
    }

    public String getSQLResponseSignatureClass() {
        return this.getOptional("kylin.query.signature-class", "org.apache.kylin.rest.signature.FactTableRealizationSetCalculator");
    }

    public boolean isQueryCacheSignatureEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.cache-signature-enabled", FALSE));
    }

    public int getFlatFilterMaxChildrenSize() {
        return Integer.parseInt(this.getOptional("kylin.query.flat-filter-max-children", "500000"));
    }

    public String getServerMode() {
        return this.getOptional("kylin.server.mode", "all");
    }

    public String[] getRestServers() {
        return this.getOptionalStringArray("kylin.server.cluster-servers", new String[0]);
    }

    public String getServerRestAddress() {
        return this.getOptional("kylin.server.host-address", "localhost:7070");
    }

    public String getClusterName() {
        String key = "kylin.server.cluster-name";
        String clusterName = this.getOptional(key, this.getMetadataUrlPrefix());
        this.setProperty(key, clusterName);
        return clusterName;
    }

    public String getInitTasks() {
        return this.getOptional("kylin.server.init-tasks");
    }

    public int getWorkersPerServer() {
        return Integer.parseInt(this.getOptional("kylin.server.sequence-sql.workers-per-server", "1"));
    }

    public long getSequenceExpireTime() {
        return Long.parseLong(this.getOptional("kylin.server.sequence-sql.expire-time", "86400000"));
    }

    public boolean getQueryMetricsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.server.query-metrics-enabled", FALSE));
    }

    public boolean getQueryMetrics2Enabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.server.query-metrics2-enabled", FALSE));
    }

    public int[] getQueryMetricsPercentilesIntervals() {
        String[] dft = new String[]{"60", "300", "3600"};
        return this.getOptionalIntArray("kylin.server.query-metrics-percentiles-intervals", dft);
    }

    public int getServerUserCacheExpireSeconds() {
        return Integer.parseInt(this.getOptional("kylin.server.auth-user-cache.expire-seconds", "300"));
    }

    public int getServerUserCacheMaxEntries() {
        return Integer.parseInt(this.getOptional("kylin.server.auth-user-cache.max-entries", "100"));
    }

    public String getSecurityProfile() {
        return this.getOptional("kylin.security.profile", "testing");
    }

    public String getExternalAclProvider() {
        return this.getOptional("kylin.server.external-acl-provider", "");
    }

    public String getLDAPUserSearchBase() {
        return this.getOptional("kylin.security.ldap.user-search-base", "");
    }

    public String getLDAPGroupSearchBase() {
        return this.getOptional("kylin.security.ldap.user-group-search-base", "");
    }

    public String getLDAPAdminRole() {
        return this.getOptional("kylin.security.acl.admin-role", "");
    }

    public String getTimeZone() {
        String timezone = this.getOptional("kylin.web.timezone");
        if (StringUtils.isBlank((String)timezone)) {
            timezone = TimeZone.getDefault().getID();
        }
        return timezone;
    }

    public boolean isWebCrossDomainEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.cross-domain-enabled", TRUE));
    }

    public boolean isAdminUserExportAllowed() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.export-allow-admin", TRUE));
    }

    public boolean isNoneAdminUserExportAllowed() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.export-allow-other", TRUE));
    }

    public boolean isWebDashboardEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.dashboard-enabled", FALSE));
    }

    public String getPropertiesWhiteList() {
        return this.getOptional("kylin.web.properties.whitelist", "kylin.web.timezone,kylin.query.cache-enabled,kylin.env,kylin.web.hive-limit,kylin.storage.default,kylin.engine.default,kylin.web.link-hadoop,kylin.web.link-diagnostic,kylin.web.contact-mail,kylin.web.help.length,kylin.web.help.0,kylin.web.help.1,kylin.web.help.2,kylin.web.help.3,kylin.web.help,kylin.web.hide-measures,kylin.web.link-streaming-guide,kylin.server.external-acl-provider,kylin.security.profile,kylin.htrace.show-gui-trace-toggle,kylin.web.export-allow-admin,kylin.web.export-allow-other,kylin.cube.cubeplanner.enabled,kylin.web.dashboard-enabled,kylin.tool.auto-migrate-cube.enabled,kylin.job.scheduler.default,kylin.web.default-time-filter");
    }

    public int getRestClientDefaultMaxPerRoute() {
        return Integer.parseInt(this.getOptional("kylin.restclient.connection.default-max-per-route", "20"));
    }

    public int getRestClientMaxTotal() {
        return Integer.parseInt(this.getOptional("kylin.restclient.connection.max-total", "200"));
    }

    public String getCoadhaleMetricsReportClassesNames() {
        return this.getOptional("kylin.metrics.reporter-classes", "org.apache.kylin.common.metrics.metrics2.JsonFileMetricsReporter,org.apache.kylin.common.metrics.metrics2.JmxMetricsReporter");
    }

    public String getMetricsFileLocation() {
        return this.getOptional("kylin.metrics.file-location", "/tmp/report.json");
    }

    public Long getMetricsReporterFrequency() {
        return Long.parseLong(this.getOptional("kylin.metrics.file-frequency", "5000"));
    }

    public String getPerfLoggerClassName() {
        return this.getOptional("kylin.metrics.perflogger-class", "org.apache.kylin.common.metrics.perflog.PerfLogger");
    }

    public boolean isShowingGuiTraceToggle() {
        return Boolean.parseBoolean(this.getOptional("kylin.htrace.show-gui-trace-toggle", FALSE));
    }

    public boolean isHtraceTracingEveryQuery() {
        return Boolean.parseBoolean(this.getOptional("kylin.htrace.trace-every-query", FALSE));
    }

    public boolean isKylinMetricsMonitorEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metrics.monitor-enabled", FALSE));
    }

    public boolean isKylinMetricsReporterForQueryEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metrics.reporter-query-enabled", FALSE));
    }

    public boolean isKylinMetricsReporterForJobEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metrics.reporter-job-enabled", FALSE));
    }

    public String getKylinMetricsPrefix() {
        return this.getOptional("kylin.metrics.prefix", "KYLIN").toUpperCase(Locale.ROOT);
    }

    public String getKylinMetricsActiveReservoirDefaultClass() {
        return this.getOptional("kylin.metrics.active-reservoir-default-class", "org.apache.kylin.metrics.lib.impl.StubReservoir");
    }

    public String getKylinSystemCubeSinkDefaultClass() {
        return this.getOptional("kylin.metrics.system-cube-sink-default-class", "org.apache.kylin.metrics.lib.impl.hive.HiveSink");
    }

    public String getKylinMetricsSubjectSuffix() {
        return this.getOptional("kylin.metric.subject-suffix", this.getDeployEnv());
    }

    public String getKylinMetricsSubjectJob() {
        return this.getOptional("kylin.metrics.subject-job", "METRICS_JOB") + "_" + this.getKylinMetricsSubjectSuffix();
    }

    public String getKylinMetricsSubjectJobException() {
        return this.getOptional("kylin.metrics.subject-job-exception", "METRICS_JOB_EXCEPTION") + "_" + this.getKylinMetricsSubjectSuffix();
    }

    public String getKylinMetricsSubjectQuery() {
        return this.getOptional("kylin.metrics.subject-query", "METRICS_QUERY") + "_" + this.getKylinMetricsSubjectSuffix();
    }

    public String getKylinMetricsSubjectQueryCube() {
        return this.getOptional("kylin.metrics.subject-query-cube", "METRICS_QUERY_CUBE") + "_" + this.getKylinMetricsSubjectSuffix();
    }

    public String getKylinMetricsSubjectQueryRpcCall() {
        return this.getOptional("kylin.metrics.subject-query-rpc", "METRICS_QUERY_RPC") + "_" + this.getKylinMetricsSubjectSuffix();
    }

    public Map<String, String> getKylinMetricsConf() {
        return this.getPropertiesByPrefix("kylin.metrics.");
    }

    public boolean isAllowAutoMigrateCube() {
        return Boolean.parseBoolean(this.getOptional("kylin.tool.auto-migrate-cube.enabled", FALSE));
    }

    public boolean isAutoMigrateCubeCopyAcl() {
        return Boolean.parseBoolean(this.getOptional("kylin.tool.auto-migrate-cube.copy-acl", TRUE));
    }

    public boolean isAutoMigrateCubePurge() {
        return Boolean.parseBoolean(this.getOptional("kylin.tool.auto-migrate-cube.purge-src-cube", TRUE));
    }

    public String getAutoMigrateCubeSrcConfig() {
        return this.getOptional("kylin.tool.auto-migrate-cube.src-config", "");
    }

    public String getAutoMigrateCubeDestConfig() {
        return this.getOptional("kylin.tool.auto-migrate-cube.dest-config", "");
    }

    public String getMetadataDialect() {
        return this.getOptional("kylin.metadata.jdbc.dialect", "mysql");
    }

    public boolean isJsonAlwaysSmallCell() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.jdbc.json-always-small-cell", TRUE));
    }

    public int getSmallCellMetadataWarningThreshold() {
        return Integer.parseInt(this.getOptional("kylin.metadata.jdbc.small-cell-meta-size-warning-threshold", String.valueOf(0x6400000)));
    }

    public int getSmallCellMetadataErrorThreshold() {
        return Integer.parseInt(this.getOptional("kylin.metadata.jdbc.small-cell-meta-size-error-threshold", String.valueOf(0x40000000)));
    }

    public int getJdbcResourceStoreMaxCellSize() {
        return Integer.parseInt(this.getOptional("kylin.metadata.jdbc.max-cell-size", "1048576"));
    }

    public String getJdbcSourceAdaptor() {
        return this.getOptional("kylin.source.jdbc.adaptor");
    }

    public boolean isLimitPushDownEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.limit-push-down-enabled", TRUE));
    }

    public String getStreamingStoreClass() {
        return this.getOptional("kylin.stream.store.class", "org.apache.kylin.stream.core.storage.columnar.ColumnarSegmentStore");
    }

    public String getStreamingBasicCuboidJobDFSBlockSize() {
        return this.getOptional("kylin.stream.job.dfs.block.size", String.valueOf(0x1000000));
    }

    public String getStreamingIndexPath() {
        return this.getOptional("kylin.stream.index.path", "stream_index");
    }

    public int getStreamingCubeConsumerTasksNum() {
        return Integer.parseInt(this.getOptional("kylin.stream.cube-num-of-consumer-tasks", "3"));
    }

    public int getStreamingCubeWindowInSecs() {
        return Integer.parseInt(this.getOptional("kylin.stream.cube.window", "3600"));
    }

    public int getStreamingCubeDurationInSecs() {
        return Integer.parseInt(this.getOptional("kylin.stream.cube.duration", "7200"));
    }

    public int getStreamingCubeMaxDurationInSecs() {
        return Integer.parseInt(this.getOptional("kylin.stream.cube.duration.max", "43200"));
    }

    public int getStreamingCheckPointFileMaxNum() {
        return Integer.parseInt(this.getOptional("kylin.stream.checkpoint.file.max.num", "5"));
    }

    public int getStreamingCheckPointIntervalsInSecs() {
        return Integer.parseInt(this.getOptional("kylin.stream.index.checkpoint.intervals", "300"));
    }

    public int getStreamingIndexMaxRows() {
        return Integer.parseInt(this.getOptional("kylin.stream.index.maxrows", "50000"));
    }

    public int getStreamingMaxImmutableSegments() {
        return Integer.parseInt(this.getOptional("kylin.stream.immutable.segments.max.num", "100"));
    }

    public boolean isStreamingConsumeFromLatestOffsets() {
        return Boolean.parseBoolean(this.getOptional("kylin.stream.consume.offsets.latest", TRUE));
    }

    public String getStreamingNode() {
        return this.getOptional("kylin.stream.node", null);
    }

    public Map<String, String> getStreamingNodeProperties() {
        return this.getPropertiesByPrefix("kylin.stream.node");
    }

    public String getStreamingMetadataStoreType() {
        return this.getOptional("kylin.stream.metadata.store.type", "zk");
    }

    public String getStreamingSegmentRetentionPolicy() {
        return this.getOptional("kylin.stream.segment.retention.policy", "fullBuild");
    }

    public String getStreamingAssigner() {
        return this.getOptional("kylin.stream.assigner", "DefaultAssigner");
    }

    public int getCoordinatorHttpClientTimeout() {
        return Integer.parseInt(this.getOptional("kylin.stream.coordinator.client.timeout.millsecond", "5000"));
    }

    public int getReceiverHttpClientTimeout() {
        return Integer.parseInt(this.getOptional("kylin.stream.receiver.client.timeout.millsecond", "5000"));
    }

    public int getStreamingReceiverHttpMaxThreads() {
        return Integer.parseInt(this.getOptional("kylin.stream.receiver.http.max.threads", "200"));
    }

    public int getStreamingReceiverHttpMinThreads() {
        return Integer.parseInt(this.getOptional("kylin.stream.receiver.http.min.threads", "10"));
    }

    public int getStreamingReceiverQueryCoreThreads() {
        return Integer.parseInt(this.getOptional("kylin.stream.receiver.query-core-threads", "50"));
    }

    public int getStreamingReceiverQueryMaxThreads() {
        return Integer.parseInt(this.getOptional("kylin.stream.receiver.query-max-threads", "200"));
    }

    public int getStreamingReceiverUseThreadsPerQuery() {
        return Integer.parseInt(this.getOptional("kylin.stream.receiver.use-threads-per-query", "8"));
    }

    public int getStreamingRPCHttpConnTimeout() {
        return Integer.parseInt(this.getOptional("kylin.stream.rpc.http.connect.timeout", "10000"));
    }

    public int getStreamingRPCHttpReadTimeout() {
        return Integer.parseInt(this.getOptional("kylin.stream.rpc.http.read.timeout", "60000"));
    }

    public boolean isStreamingBuildAdditionalCuboids() {
        return Boolean.parseBoolean(this.getOptional("kylin.stream.build.additional.cuboids", FALSE));
    }

    public Map<String, String> getStreamingSegmentRetentionPolicyProperties(String policyName) {
        return this.getPropertiesByPrefix("kylin.stream.segment.retention.policy." + policyName + ".");
    }

    public int getStreamingMaxFragmentsInSegment() {
        return Integer.parseInt(this.getOptional("kylin.stream.segment-max-fragments", "50"));
    }

    public int getStreamingMinFragmentsInSegment() {
        return Integer.parseInt(this.getOptional("kylin.stream.segment-min-fragments", "15"));
    }

    public int getStreamingMaxFragmentSizeInMb() {
        return Integer.parseInt(this.getOptional("kylin.stream.max-fragment-size-mb", "300"));
    }

    public boolean isStreamingFragmentsAutoMergeEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.stream.fragments-auto-merge-enable", TRUE));
    }

    public boolean isStreamingConcurrentScanEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.stream.segment.concurrent.scan", FALSE));
    }

    public boolean isStreamingStandAloneMode() {
        return Boolean.parseBoolean(this.getOptional("kylin.stream.stand-alone.mode", FALSE));
    }

    public boolean isNewCoordinatorEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.stream.new.coordinator-enabled", TRUE));
    }

    public String getLocalStorageImpl() {
        return this.getOptional("kylin.stream.settled.storage", null);
    }

    public String getStreamMetrics() {
        return this.getOptional("kylin.stream.metrics.option", "");
    }

    public boolean isPrintRealtimeDictEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.stream.print-realtime-dict-enabled", FALSE));
    }

    public long getStreamMetricsInterval() {
        return Long.parseLong(this.getOptional("kylin.stream.metrics.interval", "5"));
    }

    public String getStreamingDerivedTimeTimezone() {
        return this.getOptional("kylin.stream.event.timezone", "");
    }

    public boolean isAutoResubmitDiscardJob() {
        return Boolean.parseBoolean(this.getOptional("kylin.stream.auto-resubmit-after-discard-enabled", TRUE));
    }

    public String getHiveDatabaseLambdaCube() {
        return this.getOptional("kylin.stream.hive.database-for-lambda-cube", DEFAULT);
    }

    public int getWarningSegmentNum() {
        return Integer.parseInt(this.getOptional("kylin.tool.health-check.warning-segment-num", "-1"));
    }

    public int getWarningCubeExpansionRate() {
        return Integer.parseInt(this.getOptional("kylin.tool.health-check.warning-cube-expansion-rate", "5"));
    }

    public int getExpansionCheckMinCubeSizeInGb() {
        return Integer.parseInt(this.getOptional("kylin.tool.health-check.expansion-check.min-cube-size-gb", "500"));
    }

    public int getStaleCubeThresholdInDays() {
        return Integer.parseInt(this.getOptional("kylin.tool.health-check.stale-cube-threshold-days", "100"));
    }

    public int getStaleJobThresholdInDays() {
        return Integer.parseInt(this.getOptional("kylin.tool.health-check.stale-job-threshold-days", "30"));
    }
}

