/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.util.ArrayList;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.storage.hbase.steps.RowKeyWritable;
import org.apache.kylin.storage.hbase.steps.SparkCubeHFile;
import org.junit.Assert;
import org.junit.Test;

public class HFilePartitionerTest {
    @Test
    public void testPartitioner() {
        String[] splitKyes = new String[]{"\\x00\\x0A\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x5F\\x03\\x00\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF", "\\x00\\x02\\x00\\x01\\x00\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF", "\\x00\\x0A\\x00\\x01\\x00\\x00\\x00\\x00\\x00\\x00\\x58\\xF3\\x00\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF", "\\x00\\x02\\x00\\x02\\x00\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF", "\\x00\\x0A\\x00\\x02\\x00\\x00\\x00\\x00\\x00\\x00\\x58\\x5C\\x00\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF", "\\x00\\x0A\\x00\\x02\\x00\\x00\\x00\\x00\\x00\\x00\\x7C\\x50\\x00\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF", "\\x00\\x02\\x00\\x03\\x00\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF", "\\x00\\x0A\\x00\\x03\\x00\\x00\\x00\\x00\\x00\\x00\\x5B\\xF3\\x00\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF", "\\x00\\x02\\x00\\x04\\x00\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF", "\\x00\\x0A\\x00\\x04\\x00\\x00\\x00\\x00\\x00\\x00\\x5B\\xFC\\x00\\x7F\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF"};
        ArrayList<RowKeyWritable> keys = new ArrayList<RowKeyWritable>();
        for (int i = 0; i < splitKyes.length; ++i) {
            byte[] bytes = BytesUtil.fromHex((String)splitKyes[i]);
            RowKeyWritable rowKeyWritable = new RowKeyWritable(bytes);
            keys.add(rowKeyWritable);
        }
        SparkCubeHFile.HFilePartitioner partitioner = new SparkCubeHFile.HFilePartitioner(keys);
        String testRowKey = "\\x00\\x11\\x00\\x02\\x00\\x00\\x00\\x00\\x00\\x00\\x40\\xAC\\x0B\\x37\\xF9\\x05\\x04\\x02\\x00\\x02\\x46\\x32\\x4D\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x04";
        int partition = partitioner.getPartition((Object)new RowKeyWritable(BytesUtil.fromHex((String)testRowKey)));
        Assert.assertEquals((long)4L, (long)partition);
        testRowKey = "\\x00\\x0D\\x00\\x04\\x00\\x00\\x00\\x00\\x00\\x00\\x40\\x00\\x0B\\x39\\x6C\\x02\\x46\\x32\\x4D\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x04";
        partition = partitioner.getPartition((Object)new RowKeyWritable(BytesUtil.fromHex((String)testRowKey)));
        Assert.assertEquals((long)9L, (long)partition);
    }
}

