/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSPathGarbageCollectionStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(HDFSPathGarbageCollectionStep.class);
    public static final String TO_DELETE_PATHS = "toDeletePaths";
    private StringBuffer output = new StringBuffer();
    private JobEngineConfig config;

    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        try {
            this.config = new JobEngineConfig(context.getConfig());
            List<String> toDeletePaths = this.getDeletePaths();
            this.dropHdfsPathOnCluster(toDeletePaths, HadoopUtil.getWorkingFileSystem());
            if (StringUtils.isNotEmpty((String)context.getConfig().getHBaseClusterFs())) {
                this.dropHdfsPathOnCluster(toDeletePaths, FileSystem.get((Configuration)HBaseConnection.getCurrentHBaseConfiguration()));
            }
        }
        catch (IOException e) {
            logger.error("job:" + this.getId() + " execute finished with exception", (Throwable)e);
            this.output.append("\n").append(e.getLocalizedMessage());
        }
        return new ExecuteResult(ExecuteResult.State.SUCCEED, this.output.toString());
    }

    private void dropHdfsPathOnCluster(List<String> oldHdfsPaths, FileSystem fileSystem) throws IOException {
        if (oldHdfsPaths != null && oldHdfsPaths.size() > 0) {
            logger.debug("Drop HDFS path on FileSystem: " + fileSystem.getUri());
            this.output.append("Drop HDFS path on FileSystem: \"" + fileSystem.getUri() + "\" \n");
            for (String path : oldHdfsPaths) {
                Path oldPath;
                if (path.endsWith("*")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (fileSystem.exists(oldPath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(path)))) {
                    fileSystem.delete(oldPath, true);
                    logger.debug("HDFS path " + oldPath + " is dropped.");
                    this.output.append("HDFS path " + oldPath + " is dropped.\n");
                } else {
                    logger.debug("HDFS path " + oldPath + " not exists.");
                    this.output.append("HDFS path " + oldPath + " not exists.\n");
                }
                if (fileSystem.listStatus(oldPath.getParent()).length != 0) continue;
                Path emptyJobPath = new Path(JobBuilderSupport.getJobWorkingDir((JobEngineConfig)this.config, (String)this.getJobId()));
                if (!fileSystem.exists(emptyJobPath = Path.getPathWithoutSchemeAndAuthority((Path)emptyJobPath))) continue;
                fileSystem.delete(emptyJobPath, true);
                logger.debug("HDFS path " + emptyJobPath + " is empty and dropped.");
                this.output.append("HDFS path " + emptyJobPath + " is empty and dropped.\n");
            }
        }
    }

    public void setDeletePaths(List<String> deletePaths) {
        this.setArrayParam(TO_DELETE_PATHS, deletePaths);
    }

    public void setJobId(String jobId) {
        this.setParam("jobId", jobId);
    }

    public List<String> getDeletePaths() {
        return this.getArrayParam(TO_DELETE_PATHS);
    }

    public String getJobId() {
        return this.getParam("jobId");
    }

    private void setArrayParam(String paramKey, List<String> paramValues) {
        this.setParam(paramKey, StringUtils.join(paramValues, (String)","));
    }

    private List<String> getArrayParam(String paramKey) {
        String ids = this.getParam(paramKey);
        if (ids != null) {
            String[] splitted = StringUtils.split((String)ids, (String)",");
            ArrayList result = Lists.newArrayListWithExpectedSize((int)splitted.length);
            for (String id : splitted) {
                result.add(id);
            }
            return result;
        }
        return Collections.emptyList();
    }
}

