/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;

public class TblColRef
implements Serializable {
    private static final String INNER_TABLE_NAME = "_kylin_table";
    private static final DataModelDesc UNKNOWN_MODEL = new DataModelDesc();
    private TableRef table;
    private TableRef backupTable;
    private ColumnDesc column;
    private String identity;
    private String parserDescription;
    private List<TupleExpression> subTupleExps;
    private transient Function<TblColRef, String> quotedFunc;

    TblColRef(ColumnDesc column) {
        this.column = column;
    }

    TblColRef(TableRef table, ColumnDesc column) {
        Preconditions.checkArgument((boolean)table.getTableDesc().getIdentity().equals(column.getTable().getIdentity()));
        this.table = table;
        this.column = column;
    }

    public static TblColRef newInnerColumn(String columnName, InnerDataTypeEnum dataType) {
        return TblColRef.newInnerColumn(columnName, dataType, null);
    }

    public static TblColRef newInnerColumn(String columnName, InnerDataTypeEnum dataType, String parserDescription) {
        ColumnDesc column = new ColumnDesc();
        column.setName(columnName);
        TableDesc table = new TableDesc();
        column.setTable(table);
        TblColRef colRef = new TblColRef(column);
        colRef.markInnerColumn(dataType);
        colRef.parserDescription = parserDescription;
        return colRef;
    }

    public static TableRef tableForUnknownModel(String tempTableAlias, TableDesc table) {
        return new TableRef(UNKNOWN_MODEL, tempTableAlias, table, false);
    }

    public static TblColRef columnForUnknownModel(TableRef table, ColumnDesc colDesc) {
        Preconditions.checkArgument((table.getModel() == UNKNOWN_MODEL ? 1 : 0) != 0);
        return new TblColRef(table, colDesc);
    }

    public static void fixUnknownModel(DataModelDesc model, String alias, TblColRef col) {
        Preconditions.checkArgument((col.table.getModel() == UNKNOWN_MODEL || col.table.getModel() == model ? 1 : 0) != 0);
        TableRef tableRef = model.findTable(alias);
        Preconditions.checkArgument((boolean)tableRef.getTableDesc().getIdentity().equals(col.column.getTable().getIdentity()));
        col.fixTableRef(tableRef);
    }

    public static void unfixUnknownModel(TblColRef col) {
        col.unfixTableRef();
    }

    public static TblColRef mockup(TableDesc table, int oneBasedColumnIndex, String name, String datatype) {
        return TblColRef.mockup(table, oneBasedColumnIndex, name, datatype, null);
    }

    public static TblColRef mockup(TableDesc table, int oneBasedColumnIndex, String name, String datatype, String comment) {
        ColumnDesc desc = new ColumnDesc();
        String id = "" + oneBasedColumnIndex;
        desc.setId(id);
        desc.setName(name);
        desc.setDatatype(datatype);
        desc.init(table);
        desc.setComment(comment);
        return new TblColRef(desc);
    }

    public void setQuotedFunc(Function<TblColRef, String> quotedFunc) {
        this.quotedFunc = quotedFunc;
    }

    public void fixTableRef(TableRef tableRef) {
        this.backupTable = this.table;
        this.table = tableRef;
        this.identity = null;
    }

    public ColumnDesc getColumnDesc() {
        return this.column;
    }

    public void unfixTableRef() {
        this.table = this.backupTable;
        this.identity = null;
    }

    public String getName() {
        return this.column.getName();
    }

    public TableRef getTableRef() {
        return this.table;
    }

    public boolean isQualified() {
        return this.table != null;
    }

    public String getTableAlias() {
        return this.table != null ? this.table.getAlias() : "UNKNOWN_ALIAS";
    }

    public String getExpressionInSourceDB() {
        if (!this.column.isComputedColumn()) {
            return this.getIdentity();
        }
        return this.column.getComputedColumnExpr();
    }

    public String getTable() {
        if (this.column.getTable() == null) {
            return null;
        }
        return this.column.getTable().getIdentity();
    }

    public String getCanonicalName() {
        return this.getTable() + "." + this.getName();
    }

    public String getDatatype() {
        return this.column.getDatatype();
    }

    public DataType getType() {
        return this.column.getType();
    }

    public List<TupleExpression> getSubTupleExps() {
        return this.subTupleExps;
    }

    public void setSubTupleExps(List<TupleExpression> subTubleExps) {
        this.subTupleExps = subTubleExps;
    }

    public String getBackupTableAlias() {
        return this.backupTable.getAlias();
    }

    private void markInnerColumn(InnerDataTypeEnum dataType) {
        this.column.setDatatype(dataType.getDataType());
        this.column.getTable().setName(INNER_TABLE_NAME);
        this.column.getTable().setDatabase("DEFAULT");
    }

    public boolean isInnerColumn() {
        return InnerDataTypeEnum.contains(this.getDatatype());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column.getTable().getIdentity().hashCode();
        result = 31 * result + this.column.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TblColRef other = (TblColRef)obj;
        if (!StringUtils.equals((String)this.column.getTable().getIdentity(), (String)other.column.getTable().getIdentity())) {
            return false;
        }
        if (!StringUtils.equals((String)this.column.getName(), (String)other.column.getName())) {
            return false;
        }
        if (!(this.table == null ? other.table == null : this.table.equals(other.table))) {
            return false;
        }
        return this.isInnerColumn() == other.isInnerColumn();
    }

    public String getIdentity() {
        if (this.identity == null) {
            this.identity = this.getTableAlias() + "." + this.getName();
        }
        return this.identity;
    }

    public String getQuotedIdentity() {
        if (this.quotedFunc == null) {
            return this.getIdentity();
        }
        return this.quotedFunc.apply(this);
    }

    public String toString() {
        String tableIdentity;
        if (this.isInnerColumn() && this.parserDescription != null) {
            return this.parserDescription;
        }
        String alias = this.table == null ? "UNKNOWN_MODEL" : this.table.getAlias();
        String tableName = this.column.getTable() == null ? "NULL" : this.column.getTable().getName();
        String string = tableIdentity = this.column.getTable() == null ? "NULL" : this.column.getTable().getIdentity();
        if (alias.equals(tableName)) {
            return tableIdentity + "." + this.column.getName();
        }
        return alias + ":" + tableIdentity + "." + this.column.getName();
    }

    public String getTableWithSchema() {
        if (this.isInnerColumn() && this.parserDescription != null) {
            return this.parserDescription;
        }
        if (this.column.getTable() == null) {
            return "NULL";
        }
        return this.column.getTable().getIdentity().toUpperCase(Locale.ROOT);
    }

    public String getColumWithTableAndSchema() {
        return (this.getTableWithSchema() + "." + this.column.getName()).toUpperCase(Locale.ROOT);
    }

    public String getColumnWithTable() {
        return (this.getTable() + "." + this.column.getName()).toUpperCase(Locale.ROOT);
    }

    static {
        UNKNOWN_MODEL.setName("UNKNOWN_MODEL");
    }

    public static enum InnerDataTypeEnum {
        LITERAL("_literal_type"),
        DERIVED("_derived_type");

        private final String dateType;

        private InnerDataTypeEnum(String name) {
            this.dateType = name;
        }

        public static boolean contains(String name) {
            return LITERAL.getDataType().equals(name) || DERIVED.getDataType().equals(name);
        }

        public String getDataType() {
            return this.dateType;
        }
    }
}

