/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DatabaseDesc;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class TableDesc
extends RootPersistentEntity
implements ISourceAware {
    private static final Logger logger = LoggerFactory.getLogger(TableDesc.class);
    private static final String TABLE_TYPE_VIRTUAL_VIEW = "VIRTUAL_VIEW";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="columns")
    private ColumnDesc[] columns;
    @JsonProperty(value="source_type")
    private int sourceType = 0;
    @JsonProperty(value="table_type")
    private String tableType;
    @JsonProperty(value="data_gen")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataGen;
    private String project;
    private KylinConfig config;
    private DatabaseDesc database = new DatabaseDesc();
    private String identity = null;
    private boolean isBorrowedFromGlobal = false;

    public static String concatRawResourcePath(String nameOnPath) {
        return "/table/" + nameOnPath + ".json";
    }

    public static String makeResourceName(String tableIdentity, String prj) {
        return prj == null ? tableIdentity : tableIdentity + "--" + prj;
    }

    public static String concatResourcePath(String tableIdentity, String prj) {
        return TableDesc.concatRawResourcePath(TableDesc.makeResourceName(tableIdentity, prj));
    }

    public static TableProject parseResourcePath(String path) {
        String prj;
        String table;
        int dash;
        int cut;
        if (path.endsWith(".json")) {
            path = path.substring(0, path.length() - ".json".length());
        }
        if ((cut = path.lastIndexOf("/")) >= 0) {
            path = path.substring(cut + 1);
        }
        if ((dash = path.indexOf("--")) >= 0) {
            table = path.substring(0, dash);
            prj = path.substring(dash + 2);
        } else {
            table = path;
            prj = null;
        }
        return new TableProject(table, prj);
    }

    public TableDesc() {
    }

    public TableDesc(TableDesc other) {
        this.uuid = other.uuid;
        this.lastModified = other.lastModified;
        this.name = other.name;
        this.sourceType = other.sourceType;
        this.tableType = other.tableType;
        this.dataGen = other.dataGen;
        this.columns = new ColumnDesc[other.columns.length];
        for (int i = 0; i < other.columns.length; ++i) {
            this.columns[i] = new ColumnDesc(other.columns[i]);
            this.columns[i].init(this);
        }
        this.project = other.project;
        this.config = other.config;
        this.database.setName(other.getDatabase());
        this.identity = other.identity;
    }

    @Override
    public String resourceName() {
        return TableDesc.makeResourceName(this.getIdentity(), this.getProject());
    }

    public TableDesc appendColumns(ColumnDesc[] computedColumns, boolean makeCopy) {
        if (computedColumns == null || computedColumns.length == 0) {
            return this;
        }
        TableDesc ret = makeCopy ? new TableDesc(this) : this;
        Object[] existingColumns = ret.columns;
        ArrayList newColumns = Lists.newArrayList();
        for (int j = 0; j < computedColumns.length; ++j) {
            boolean isFreshCC = true;
            for (int i = 0; i < existingColumns.length; ++i) {
                if (!((ColumnDesc)existingColumns[i]).getName().equalsIgnoreCase(computedColumns[j].getName())) continue;
                if (!((ColumnDesc)existingColumns[i]).isComputedColumn()) {
                    String errorMsg = String.format(Locale.ROOT, "There is already a column named %s on table %s, please change your computed column name", computedColumns[j].getName(), this.getIdentity());
                    throw new IllegalArgumentException(errorMsg);
                }
                isFreshCC = false;
            }
            if (!isFreshCC) continue;
            newColumns.add(computedColumns[j]);
        }
        ArrayList expandedColumns = Lists.newArrayList((Object[])existingColumns);
        for (ColumnDesc newColumnDesc : newColumns) {
            newColumnDesc.init(ret);
            expandedColumns.add(newColumnDesc);
        }
        ret.columns = expandedColumns.toArray(new ColumnDesc[0]);
        return ret;
    }

    public ColumnDesc findColumnByName(String name) {
        int lastIndexOfDot = name.lastIndexOf(46);
        if (lastIndexOfDot >= 0) {
            name = name.substring(lastIndexOfDot + 1);
        }
        for (ColumnDesc c : this.columns) {
            if (!name.equalsIgnoreCase(c.getName())) continue;
            return c;
        }
        return null;
    }

    public String getResourcePath() {
        if (this.isBorrowedFromGlobal()) {
            return TableDesc.concatResourcePath(this.getIdentity(), null);
        }
        return TableDesc.concatResourcePath(this.getIdentity(), this.project);
    }

    @Deprecated
    public String getResourcePathV1() {
        return TableDesc.concatResourcePath(this.name, null);
    }

    public String getIdentity() {
        if (this.identity == null) {
            this.identity = String.format(Locale.ROOT, "%s.%s", this.getDatabase().toUpperCase(Locale.ROOT), this.getName()).toUpperCase(Locale.ROOT);
        }
        return this.identity;
    }

    public String getIdentityQuoted(String quot) {
        String dbName = quot + this.getDatabase() + quot;
        String tableName = quot + this.getName() + quot;
        return String.format(Locale.ROOT, "%s.%s", dbName, tableName).toUpperCase(Locale.ROOT);
    }

    public String getFactTableQuoted(String quot) {
        String database = quot + this.config.getHiveDatabaseForIntermediateTable() + quot;
        String table = quot + this.getName() + "_fact" + quot;
        return database + "." + table;
    }

    public boolean isView() {
        return TABLE_TYPE_VIRTUAL_VIEW.equals(this.tableType);
    }

    public boolean isBorrowedFromGlobal() {
        return this.isBorrowedFromGlobal;
    }

    public void setBorrowedFromGlobal(boolean borrowedFromGlobal) {
        this.isBorrowedFromGlobal = borrowedFromGlobal;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            String[] splits = StringSplitter.split(name, ".");
            if (splits.length == 2) {
                this.setDatabase(splits[0]);
                this.name = splits[1];
            } else if (splits.length == 1) {
                this.name = splits[0];
            }
        } else {
            this.name = null;
        }
    }

    @JsonProperty(value="database")
    public String getDatabase() {
        return this.database.getName();
    }

    @JsonProperty(value="database")
    public void setDatabase(String database) {
        this.database.setName(database);
    }

    public ColumnDesc[] getColumns() {
        return this.columns;
    }

    public void setColumns(ColumnDesc[] columns) {
        this.columns = columns;
    }

    public int getMaxColumnIndex() {
        if (this.columns == null) {
            return -1;
        }
        int max = -1;
        for (ColumnDesc col : this.columns) {
            int idx = col.getZeroBasedIndex();
            max = Math.max(max, idx);
        }
        return max;
    }

    public int getColumnCount() {
        return this.getMaxColumnIndex() + 1;
    }

    public String getDataGen() {
        return this.dataGen;
    }

    public void init(KylinConfig config, String project) {
        this.project = project;
        this.config = config;
        if (this.name != null) {
            this.name = this.name.toUpperCase(Locale.ROOT);
        }
        if (this.getDatabase() != null) {
            this.setDatabase(this.getDatabase().toUpperCase(Locale.ROOT));
        }
        if (this.columns != null) {
            Arrays.parallelSort(this.columns, new Comparator<ColumnDesc>(){

                @Override
                public int compare(ColumnDesc col1, ColumnDesc col2) {
                    Integer id1 = Integer.parseInt(col1.getId());
                    Integer id2 = Integer.parseInt(col2.getId());
                    return id1.compareTo(id2);
                }
            });
            for (ColumnDesc col : this.columns) {
                col.init(this);
            }
        }
    }

    @Override
    public int hashCode() {
        return this.getIdentity().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDesc tableDesc = (TableDesc)o;
        if (this.sourceType != tableDesc.sourceType) {
            return false;
        }
        if (this.name != null ? !this.name.equals(tableDesc.name) : tableDesc.name != null) {
            return false;
        }
        if (!Arrays.equals(this.columns, tableDesc.columns)) {
            return false;
        }
        return this.getIdentity().equals(tableDesc.getIdentity());
    }

    public String getMaterializedName() {
        return this.config.getHiveIntermediateTablePrefix() + this.database.getName() + "_" + this.name;
    }

    public String getMaterializedName(String uuid) {
        if (uuid == null) {
            return this.getMaterializedName();
        }
        return this.config.getHiveIntermediateTablePrefix() + this.database.getName() + "_" + this.name + "_" + uuid.replaceAll("-", "_");
    }

    public String toString() {
        return "TableDesc{name='" + this.name + '\'' + ", columns=" + Arrays.toString(this.columns) + ", sourceType=" + this.sourceType + ", tableType='" + this.tableType + '\'' + ", database=" + this.database + ", identity='" + this.getIdentity() + '\'' + '}';
    }

    public static TableDesc mockup(String tableName) {
        TableDesc mockup = new TableDesc();
        mockup.setName(tableName);
        return mockup;
    }

    @Override
    public int getSourceType() {
        return this.sourceType;
    }

    @Override
    public KylinConfig getConfig() {
        if (this.project == null) {
            return this.config;
        }
        ProjectInstance projInstance = ProjectManager.getInstance(this.config).getProject(this.project);
        return projInstance == null ? this.config : projInstance.getConfig();
    }

    public void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public boolean isStreamingTable() {
        return this.sourceType == 20 || this.sourceType == 21;
    }

    public static class TableProject {
        private String table;
        private String project;

        TableProject(String table, String project) {
            this.table = table;
            this.project = project;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getProject() {
            return this.project;
        }

        public void setProject(String project) {
            this.project = project;
        }
    }
}

