/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TimeDerivedColumnType {
    MINUTE_START("minute_start"){

        @Override
        public Pair<Long, Long> calculateTimeUnitRange(long time) {
            long calTimeStart = TimeUtil.getMinuteStart(time);
            long calTimeEnd = calTimeStart + 60000L;
            return new Pair<Long, Long>(calTimeStart, calTimeEnd);
        }

        @Override
        public String normalizeTimeFormat(long time) {
            return DateFormat.formatToTimeWithoutMilliStr(this.normalize(time));
        }

        @Override
        public long normalize(long time) {
            return TimeUtil.getMinuteStart(time);
        }
    }
    ,
    HOUR_START("hour_start"){

        @Override
        public Pair<Long, Long> calculateTimeUnitRange(long time) {
            long calTimeStart = TimeUtil.getHourStart(time);
            long calTimeEnd = calTimeStart + 3600000L;
            return new Pair<Long, Long>(calTimeStart, calTimeEnd);
        }

        @Override
        public String normalizeTimeFormat(long time) {
            return DateFormat.formatToTimeWithoutMilliStr(this.normalize(time));
        }

        @Override
        public long normalize(long time) {
            return TimeUtil.getHourStart(time);
        }
    }
    ,
    DAY_START("day_start"){

        @Override
        public Pair<Long, Long> calculateTimeUnitRange(long time) {
            long calTimeStart = TimeUtil.getDayStart(time);
            long calTimeEnd = calTimeStart + 86400000L;
            return new Pair<Long, Long>(calTimeStart, calTimeEnd);
        }

        @Override
        public String normalizeTimeFormat(long time) {
            return DateFormat.formatToDateStr(this.normalize(time));
        }

        @Override
        public long normalize(long time) {
            return TimeUtil.getDayStart(time);
        }
    }
    ,
    WEEK_START("week_start"){

        @Override
        public Pair<Long, Long> calculateTimeUnitRange(long time) {
            return new Pair<Long, Long>(TimeUtil.getWeekStart(time), TimeUtil.getWeekEnd(time));
        }

        @Override
        public String normalizeTimeFormat(long time) {
            return DateFormat.formatToDateStr(this.normalize(time));
        }

        @Override
        public long normalize(long time) {
            return TimeUtil.getWeekStart(time);
        }
    }
    ,
    MONTH_START("month_start"){

        @Override
        public Pair<Long, Long> calculateTimeUnitRange(long time) {
            return new Pair<Long, Long>(TimeUtil.getMonthStart(time), TimeUtil.getMonthEnd(time));
        }

        @Override
        public String normalizeTimeFormat(long time) {
            return DateFormat.formatToDateStr(this.normalize(time));
        }

        @Override
        public long normalize(long time) {
            return TimeUtil.getMonthStart(time);
        }
    }
    ,
    QUARTER_START("quarter_start"){

        @Override
        public Pair<Long, Long> calculateTimeUnitRange(long time) {
            return new Pair<Long, Long>(TimeUtil.getQuarterStart(time), TimeUtil.getQuarterEnd(time));
        }

        @Override
        public String normalizeTimeFormat(long time) {
            return DateFormat.formatToDateStr(this.normalize(time));
        }

        @Override
        public long normalize(long time) {
            return TimeUtil.getQuarterStart(time);
        }
    }
    ,
    YEAR_START("year_start"){

        @Override
        public Pair<Long, Long> calculateTimeUnitRange(long time) {
            return new Pair<Long, Long>(TimeUtil.getYearStart(time), TimeUtil.getYearEnd(time));
        }

        @Override
        public String normalizeTimeFormat(long time) {
            return DateFormat.formatToDateStr(this.normalize(time));
        }

        @Override
        public long normalize(long time) {
            return TimeUtil.getYearStart(time);
        }
    };

    private static final String MINUTE_START_NAME = "minute_start";
    private static final String HOUR_START_NAME = "hour_start";
    private static final String DAY_START_NAME = "day_start";
    private static final String WEEK_START_NAME = "week_start";
    private static final String MONTH_START_NAME = "month_start";
    private static final String QUARTER_START_NAME = "quarter_start";
    private static final String YEAR_START_NAME = "year_start";
    private static Map<String, TimeDerivedColumnType> nameColumnsMap;
    private static Logger logger;
    private String name;

    private TimeDerivedColumnType(String name) {
        this.name = name;
    }

    public static boolean isTimeDerivedColumn(String columnName) {
        return nameColumnsMap.containsKey(columnName.toLowerCase(Locale.ROOT));
    }

    public static boolean isTimeDerivedColumnAboveDayLevel(String columnName) {
        if (!TimeDerivedColumnType.isTimeDerivedColumn(columnName)) {
            return false;
        }
        return !columnName.equalsIgnoreCase(MINUTE_START_NAME) && !columnName.equalsIgnoreCase(HOUR_START_NAME);
    }

    public static TimeDerivedColumnType getTimeDerivedColumnType(String columnName) {
        return nameColumnsMap.get(columnName.toLowerCase(Locale.ROOT));
    }

    public static long parseTimeValue(Object value) {
        String dateStr;
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            dateStr = (String)value;
        } else if (value instanceof ByteArray) {
            dateStr = Bytes.toString(((ByteArray)value).array());
        } else {
            throw new IllegalArgumentException("unknown type of value:" + value.getClass());
        }
        return DateFormat.stringToMillis(dateStr);
    }

    public boolean hasTimeRangeOverlap(long timeStart, long timeEnd, Object timeValue) {
        long time = TimeDerivedColumnType.parseTimeValue(timeValue);
        Pair<Long, Long> calUnitTimeRange = this.calculateTimeUnitRange(time);
        return calUnitTimeRange.getSecond() > timeStart && calUnitTimeRange.getFirst() < timeEnd;
    }

    public Pair<Long, Long> getTimeUnitRange(Object timeValue) {
        long time = TimeDerivedColumnType.parseTimeValue(timeValue);
        return this.calculateTimeUnitRange(time);
    }

    public Pair<Long, Long> getTimeUnitRangeTimezoneAware(Object timeValue, long timezoneOffset) {
        long ts = TimeDerivedColumnType.parseTimeValue(timeValue);
        Pair<Long, Long> res = this.calculateTimeUnitRange(ts);
        res = new Pair<Long, Long>(res.getFirst() - timezoneOffset, res.getSecond() - timezoneOffset);
        return res;
    }

    public abstract Pair<Long, Long> calculateTimeUnitRange(long var1);

    public abstract String normalizeTimeFormat(long var1);

    public abstract long normalize(long var1);

    static {
        nameColumnsMap = Maps.newHashMap();
        logger = LoggerFactory.getLogger(TimeDerivedColumnType.class);
        nameColumnsMap.put(MINUTE_START_NAME, MINUTE_START);
        nameColumnsMap.put(HOUR_START_NAME, HOUR_START);
        nameColumnsMap.put(DAY_START_NAME, DAY_START);
        nameColumnsMap.put(WEEK_START_NAME, WEEK_START);
        nameColumnsMap.put(MONTH_START_NAME, MONTH_START);
        nameColumnsMap.put(QUARTER_START_NAME, QUARTER_START);
        nameColumnsMap.put(YEAR_START_NAME, YEAR_START);
    }
}

