/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dimension.DateDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class RowKeyColDesc
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(RowKeyColDesc.class);
    @JsonProperty(value="column")
    private String column;
    @JsonProperty(value="encoding")
    private String encoding;
    @JsonProperty(value="encoding_version")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private int encodingVersion = 1;
    @JsonProperty(value="isShardBy")
    private boolean isShardBy;
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String index;
    private String encodingName;
    private String[] encodingArgs;
    private int bitIndex;
    private TblColRef colRef;

    public void init(int index, CubeDesc cubeDesc) {
        this.bitIndex = index;
        this.colRef = cubeDesc.getModel().findColumn(this.column);
        this.column = this.colRef.getIdentity();
        Preconditions.checkArgument((this.colRef != null ? 1 : 0) != 0, (String)"Cannot find rowkey column %s in cube %s", (Object[])new Object[]{this.column, cubeDesc});
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)this.encoding));
        Object[] encodingConf = DimensionEncoding.parseEncodingConf(this.encoding);
        this.encodingName = (String)encodingConf[0];
        this.encodingArgs = (String[])encodingConf[1];
        if (!DimensionEncodingFactory.isValidEncoding(this.encodingName)) {
            throw new IllegalArgumentException("Not supported row key col encoding: '" + this.encoding + "'");
        }
        DataType type = this.colRef.getType();
        if ("dict".equals(this.encodingName)) {
            if (type.isDate()) {
                this.encodingName = "date";
                this.encoding = "date";
            }
            if (type.isTimeFamily()) {
                this.encodingName = "time";
                this.encoding = "time";
            }
        }
        this.encodingArgs = DateDimEnc.replaceEncodingArgs(this.encoding, this.encodingArgs, this.encodingName, type);
        if (this.encodingName.startsWith("fixed_length") && (type.isIntegerFamily() || type.isNumberFamily())) {
            logger.warn(this.colRef + " type is " + type + " and cannot apply fixed_length encoding");
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public boolean isShardBy() {
        return this.isShardBy;
    }

    public void setShardBy(boolean shardBy) {
        this.isShardBy = shardBy;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public String[] getEncodingArgs() {
        return this.encodingArgs;
    }

    public boolean isUsingDictionary() {
        return "dict".equals(this.encodingName);
    }

    public int getBitIndex() {
        return this.bitIndex;
    }

    public TblColRef getColRef() {
        return this.colRef;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public int getEncodingVersion() {
        return this.encodingVersion;
    }

    public void setEncodingVersion(int encodingVersion) {
        this.encodingVersion = encodingVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("column", (Object)this.column).add("encoding", (Object)this.encoding).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowKeyColDesc that = (RowKeyColDesc)o;
        return !(this.column != null ? !this.column.equals(that.column) : that.column != null);
    }
}

