/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ConsumeBlockingQueueController<T>
implements Iterator<T> {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private volatile boolean hasException = false;
    private final BlockingQueue<T> input;
    private final int batchSize;
    private final List<T> batchBuffer;
    private Iterator<T> internalIT;
    private AtomicInteger outputRowCount = new AtomicInteger();

    public ConsumeBlockingQueueController(BlockingQueue<T> input, int batchSize) {
        this.input = input;
        this.batchSize = batchSize;
        this.batchBuffer = Lists.newArrayListWithExpectedSize((int)batchSize);
        this.internalIT = this.batchBuffer.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.hasException) {
            return false;
        }
        if (this.internalIT.hasNext()) {
            return true;
        }
        this.batchBuffer.clear();
        try {
            this.batchBuffer.add(this.input.take());
            this.outputRowCount.incrementAndGet();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.outputRowCount.addAndGet(this.input.drainTo(this.batchBuffer, this.batchSize - 1));
        this.internalIT = this.batchBuffer.iterator();
        return true;
    }

    @Override
    public T next() {
        return this.internalIT.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void findException() {
        this.hasException = true;
    }

    public int getOutputRowCount() {
        return this.outputRowCount.get();
    }
}

