/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.cuboid.algorithm.AbstractRecommendAlgorithm;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.apache.kylin.cube.cuboid.algorithm.PBPUSCalculator;
import org.apache.kylin.cube.cuboid.algorithm.generic.GeneticAlgorithm;
import org.apache.kylin.cube.cuboid.algorithm.greedy.GreedyAlgorithm;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidRecommender {
    private static final Logger logger = LoggerFactory.getLogger(CuboidRecommender.class);
    private static Cache<String, Map<Long, Long>> cuboidRecommendCache = CacheBuilder.newBuilder().removalListener(notification -> logger.info("Recommended cuboids for cube " + notification.getKey() + " is removed due to " + notification.getCause())).maximumSize((long)KylinConfig.getInstanceFromEnv().getCubePlannerRecommendCuboidCacheMaxSize()).expireAfterWrite(1L, TimeUnit.DAYS).build();
    private static CuboidRecommender instance = new CuboidRecommender();

    public CuboidRecommender() {
        Broadcaster.getInstance(KylinConfig.getInstanceFromEnv()).registerStaticListener(new CuboidRecommenderSyncListener(), "cube", "cube_desc");
    }

    public static CuboidRecommender getInstance() {
        return instance;
    }

    public Map<Long, Long> getRecommendCuboidList(final CuboidStats cuboidStats, final KylinConfig kylinConfig) {
        if (cuboidStats == null) {
            return null;
        }
        final String key = cuboidStats.getKey();
        Map results = (Map)cuboidRecommendCache.getIfPresent((Object)key);
        if (results == null) {
            try {
                results = (Map)cuboidRecommendCache.get((Object)key, (Callable)new Callable<Map<Long, Long>>(){

                    @Override
                    public Map<Long, Long> call() throws Exception {
                        HashMap emptyMap = Maps.newHashMap();
                        cuboidRecommendCache.put((Object)key, (Object)emptyMap);
                        try {
                            Map<Long, Long> recommendCuboid = CuboidRecommender.this.getRecommendCuboidList(cuboidStats, kylinConfig, true);
                            if (recommendCuboid != null) {
                                logger.info(String.format(Locale.ROOT, "Add recommend cuboids for %s to cache", key));
                                cuboidRecommendCache.put((Object)key, recommendCuboid);
                            }
                            return recommendCuboid;
                        }
                        catch (Exception e) {
                            cuboidRecommendCache.invalidate((Object)key);
                            logger.error(String.format(Locale.ROOT, "Failed to get recommend cuboids for %s in cache", key), (Throwable)e);
                            throw e;
                        }
                    }
                });
            }
            catch (ExecutionException e) {
                logger.error(String.format(Locale.ROOT, "Failed to get recommend cuboids for %s", key));
            }
        }
        return results;
    }

    public Map<Long, Long> getRecommendCuboidList(CuboidStats cuboidStats, KylinConfig kylinConf, boolean ifForceRecommend) {
        long threshold2;
        long threshold1 = 1L << kylinConf.getCubePlannerAgreedyAlgorithmAutoThreshold();
        if (threshold1 >= (threshold2 = 1L << kylinConf.getCubePlannerGeneticAlgorithmAutoThreshold())) {
            logger.error("Invalid Cube Planner Algorithm configuration");
            return null;
        }
        int allCuboidCount = cuboidStats.getAllCuboidsForMandatory().size() + cuboidStats.getAllCuboidsForSelection().size();
        if (!ifForceRecommend && (long)allCuboidCount <= threshold1) {
            return null;
        }
        PBPUSCalculator benefitPolicy = new PBPUSCalculator(cuboidStats);
        AbstractRecommendAlgorithm algorithm = null;
        algorithm = (long)allCuboidCount <= threshold2 ? new GreedyAlgorithm(-1L, benefitPolicy, cuboidStats) : new GeneticAlgorithm(-1L, benefitPolicy, cuboidStats);
        long startTime = System.currentTimeMillis();
        logger.info("Cube Planner Algorithm started at {}", (Object)startTime);
        List<Long> recommendCuboidList = algorithm.recommend(kylinConf.getCubePlannerExpansionRateThreshold());
        logger.info("Cube Planner Algorithm ended at {}", (Object)(System.currentTimeMillis() - startTime));
        if (recommendCuboidList.size() < allCuboidCount) {
            logger.info("Cube Planner Algorithm chooses {} most effective cuboids to build among of all {} cuboids.", (Object)recommendCuboidList.size(), (Object)allCuboidCount);
        }
        LinkedHashMap recommendCuboidsWithStats = Maps.newLinkedHashMap();
        for (Long cuboid : recommendCuboidList) {
            if (cuboid == 0L) {
                this.handleCuboidZeroRecommend(cuboidStats, recommendCuboidsWithStats);
                continue;
            }
            recommendCuboidsWithStats.put(cuboid, cuboidStats.getCuboidCount(cuboid));
        }
        return recommendCuboidsWithStats;
    }

    private void handleCuboidZeroRecommend(CuboidStats cuboidStats, Map<Long, Long> recommendCuboidsWithStats) {
        Map<Long, Long> statistics = cuboidStats.getStatistics();
        Long cheapestCuboid = null;
        Long cheapestCuboidCount = Long.MAX_VALUE;
        for (Map.Entry<Long, Long> cuboidStatsEntry : statistics.entrySet()) {
            if (cuboidStatsEntry.getValue() >= cheapestCuboidCount) continue;
            cheapestCuboid = cuboidStatsEntry.getKey();
            cheapestCuboidCount = cuboidStatsEntry.getValue();
        }
        if (cheapestCuboid != null) {
            logger.info("recommend cuboid:{} instead of cuboid zero", cheapestCuboid);
            recommendCuboidsWithStats.put(cheapestCuboid, cheapestCuboidCount);
        }
    }

    private class CuboidRecommenderSyncListener
    extends Broadcaster.Listener {
        private CuboidRecommenderSyncListener() {
        }

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            cuboidRecommendCache.invalidateAll();
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            cuboidRecommendCache.invalidate((Object)cacheKey);
        }
    }
}

