/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceParallelCopier;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTool {
    private static final Logger logger = LoggerFactory.getLogger(ResourceTool.class);
    private static final Set<String> IMMUTABLE_PREFIX = Sets.newHashSet((Object[])new String[]{"/UUID"});
    private static final List<String> SKIP_CHILDREN_CHECK_RESOURCE_ROOT = Lists.newArrayList((Object[])new String[]{"/execute", "/execute_output"});
    private String[] includes = null;
    private String[] excludes = null;
    private int parallelCopyGroupSize = 0;

    public static void main(String[] args) throws IOException {
        String cmd;
        String group;
        String exclude;
        if ((args = StringUtil.filterSystemArgs(args)).length == 0) {
            System.out.println("Usage: ResourceTool list  RESOURCE_PATH");
            System.out.println("Usage: ResourceTool download  LOCAL_DIR [RESOURCE_PATH_PREFIX]");
            System.out.println("Usage: ResourceTool upload    LOCAL_DIR [RESOURCE_PATH_PREFIX]");
            System.out.println("Usage: ResourceTool reset");
            System.out.println("Usage: ResourceTool remove RESOURCE_PATH");
            System.out.println("Usage: ResourceTool cat RESOURCE_PATH");
            return;
        }
        ResourceTool tool = new ResourceTool();
        String include = System.getProperty("include");
        if (include != null) {
            tool.addIncludes(include.split("\\s*,\\s*"));
        }
        if ((exclude = System.getProperty("exclude")) != null) {
            tool.addExcludes(exclude.split("\\s*,\\s*"));
        }
        if ((group = System.getProperty("group")) != null) {
            tool.parallelCopyGroupSize = Integer.parseInt(group);
        }
        tool.addExcludes(IMMUTABLE_PREFIX.toArray(new String[IMMUTABLE_PREFIX.size()]));
        switch (cmd = args[0]) {
            case "reset": {
                tool.reset(args.length == 1 ? KylinConfig.getInstanceFromEnv() : KylinConfig.createInstanceFromUri(args[1]));
                break;
            }
            case "list": {
                tool.list(KylinConfig.getInstanceFromEnv(), args[1]);
                break;
            }
            case "download": {
                if (args.length == 2) {
                    tool.copyParallel(KylinConfig.getInstanceFromEnv(), KylinConfig.createInstanceFromUri(args[1]), "/");
                    System.out.println("Metadata backed up to " + args[1]);
                    break;
                }
                if (args.length == 3) {
                    tool.copyParallel(KylinConfig.getInstanceFromEnv(), KylinConfig.createInstanceFromUri(args[1]), args[2]);
                    System.out.println("Metadata with prefix: " + args[2] + " backed up to " + args[1]);
                    break;
                }
                System.err.println("Illegal args : " + args);
                break;
            }
            case "fetch": {
                tool.copy(KylinConfig.getInstanceFromEnv(), KylinConfig.createInstanceFromUri(args[1]), args[2], true);
                break;
            }
            case "upload": {
                if (args.length == 2) {
                    tool.copyParallel(KylinConfig.createInstanceFromUri(args[1]), KylinConfig.getInstanceFromEnv(), "/");
                    System.out.println("Metadata restored from " + args[1]);
                    break;
                }
                if (args.length == 3) {
                    tool.copyParallel(KylinConfig.createInstanceFromUri(args[1]), KylinConfig.getInstanceFromEnv(), args[2]);
                    System.out.println("Metadata with prefix: " + args[2] + " restored from " + args[1]);
                    break;
                }
                System.err.println("Illegal args : " + args);
                break;
            }
            case "remove": {
                tool.remove(KylinConfig.getInstanceFromEnv(), args[1]);
                break;
            }
            case "cat": {
                tool.cat(KylinConfig.getInstanceFromEnv(), args[1]);
                break;
            }
            default: {
                System.out.println("Unknown cmd: " + cmd);
            }
        }
    }

    private void addIncludes(String[] arg) {
        if (arg != null) {
            if (this.includes != null) {
                String[] nIncludes = new String[this.includes.length + arg.length];
                System.arraycopy(this.includes, 0, nIncludes, 0, this.includes.length);
                System.arraycopy(arg, 0, nIncludes, this.includes.length, arg.length);
                this.includes = nIncludes;
            } else {
                this.includes = arg;
            }
        }
    }

    private void addExcludes(String[] arg) {
        if (arg != null) {
            if (this.excludes != null) {
                String[] nExcludes = new String[this.excludes.length + arg.length];
                System.arraycopy(this.excludes, 0, nExcludes, 0, this.excludes.length);
                System.arraycopy(arg, 0, nExcludes, this.excludes.length, arg.length);
                this.excludes = nExcludes;
            } else {
                this.excludes = arg;
            }
        }
    }

    private void copyParallel(KylinConfig from, KylinConfig to, String folder) throws IOException {
        ResourceParallelCopier.Stats stats;
        ResourceParallelCopier copier = new ResourceParallelCopier(ResourceStore.getStore(from), ResourceStore.getStore(to));
        if (this.parallelCopyGroupSize > 0) {
            copier.setGroupSize(this.parallelCopyGroupSize);
        }
        if ((stats = copier.copy(folder, this.includes, this.excludes, new ResourceParallelCopier.Stats(){

            @Override
            void heartBeat() {
                double percent = 100.0 * (double)(this.successGroups.size() + this.errorGroups.size()) / (double)this.allGroups.size();
                double mb = (double)this.totalBytes.get() / 1024.0 / 1024.0;
                double sec = (double)(System.nanoTime() - this.startTime) / 1.0E9;
                double kbps = (double)this.totalBytes.get() / 1024.0 / sec;
                String status = mb > 0.0 && kbps < 500.0 ? "-- Slow network or storage?" : "";
                String logInfo = String.format(Locale.ROOT, "Progress: %2.1f%%, %d resource, %d error; copied %.1f MB in %.1f min, %.1f KB/s %s", percent, this.totalResource.get(), this.errorResource.get(), mb, sec / 60.0, kbps, status);
                System.out.println(logInfo);
            }

            @Override
            void onRetry(int errorResourceCnt) {
                System.out.println("-----");
                System.out.println("RETRY " + errorResourceCnt + " error resource ...");
            }
        })).hasError()) {
            for (String errGroup : stats.errorGroups) {
                System.out.println("Failed to copy resource group: " + errGroup + "*");
            }
            for (String errResPath : stats.errorResourcePaths) {
                System.out.println("Failed to copy resource: " + errResPath);
            }
            throw new IOException("Failed to copy " + stats.errorResource.get() + " resource");
        }
    }

    public String cat(KylinConfig config, String path) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        StringBuffer sb = new StringBuffer();
        try (InputStream is = store.getResource(path).content();
             BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                sb.append(line).append('\n');
            }
        }
        return sb.toString();
    }

    public NavigableSet<String> list(KylinConfig config, String path) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        NavigableSet<String> result = store.listResources(path);
        System.out.println("" + result);
        return result;
    }

    public void copy(KylinConfig srcConfig, KylinConfig dstConfig, String path) throws IOException {
        this.copy(srcConfig, dstConfig, path, false);
    }

    public void copy(KylinConfig srcConfig, KylinConfig dstConfig, String path, boolean copyImmutableResource) throws IOException {
        ResourceStore src = ResourceStore.getStore(srcConfig);
        ResourceStore dst = ResourceStore.getStore(dstConfig);
        logger.info("Copy from {} to {}", (Object)src, (Object)dst);
        this.copyR(src, dst, path, copyImmutableResource);
    }

    public void copy(KylinConfig srcConfig, KylinConfig dstConfig, List<String> paths) throws IOException {
        this.copy(srcConfig, dstConfig, paths, false);
    }

    public void copy(KylinConfig srcConfig, KylinConfig dstConfig, List<String> paths, boolean copyImmutableResource) throws IOException {
        ResourceStore src = ResourceStore.getStore(srcConfig);
        ResourceStore dst = ResourceStore.getStore(dstConfig);
        logger.info("Copy from {} to {}", (Object)src, (Object)dst);
        for (String path : paths) {
            this.copyR(src, dst, path, copyImmutableResource);
        }
    }

    public void copy(KylinConfig srcConfig, KylinConfig dstConfig) throws IOException {
        this.copy(srcConfig, dstConfig, false);
    }

    public void copy(KylinConfig srcConfig, KylinConfig dstConfig, boolean copyImmutableResource) throws IOException {
        this.copy(srcConfig, dstConfig, "/", copyImmutableResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyR(ResourceStore src, ResourceStore dst, String path, boolean copyImmutableResource) throws IOException {
        block12: {
            if (!copyImmutableResource && IMMUTABLE_PREFIX.contains(path)) {
                return;
            }
            boolean isSkip = SKIP_CHILDREN_CHECK_RESOURCE_ROOT.stream().anyMatch(prefixToSkip -> path.startsWith((String)prefixToSkip));
            if (isSkip) {
                return;
            }
            NavigableSet<String> children = src.listResources(path);
            if (children == null) {
                if (ResourceTool.matchFilter(path, this.includes, this.excludes)) {
                    try {
                        RawResource res = src.getResource(path);
                        if (res != null) {
                            logger.info("Copy path: {} from {} to {}", new Object[]{path, src, dst});
                            try {
                                dst.putResource(path, res.content(), res.lastModified());
                                break block12;
                            }
                            finally {
                                res.close();
                            }
                        }
                        System.out.println("Resource not exist for " + path);
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to open " + path);
                        logger.error(ex.getLocalizedMessage(), (Throwable)ex);
                    }
                }
            } else {
                for (String child : children) {
                    this.copyR(src, dst, child, copyImmutableResource);
                }
            }
        }
    }

    static boolean matchFilter(String path, String[] includePrefix, String[] excludePrefix) {
        if (includePrefix != null) {
            boolean in = false;
            String[] stringArray = includePrefix;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String include = stringArray[i];
                in = in || path.startsWith(include);
            }
            if (!in) {
                return false;
            }
        }
        if (excludePrefix != null) {
            for (String exclude : excludePrefix) {
                if (!path.startsWith(exclude)) continue;
                return false;
            }
        }
        return true;
    }

    public void reset(KylinConfig config) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        this.resetR(store, "/");
    }

    public void resetR(ResourceStore store, String path) throws IOException {
        NavigableSet<String> children = store.listResources(path);
        if (children == null) {
            if (ResourceTool.matchFilter(path, this.includes, this.excludes)) {
                store.deleteResource(path);
            }
        } else {
            for (String child : children) {
                this.resetR(store, child);
            }
        }
    }

    public void remove(KylinConfig config, String path) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        this.resetR(store, path);
    }
}

