/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.ContentWriter;
import org.apache.kylin.common.persistence.JDBCConnectionManager;
import org.apache.kylin.common.persistence.JDBCResourceSQL;
import org.apache.kylin.common.persistence.PushdownResourceStore;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.WriteConflictException;
import org.apache.kylin.common.util.DBUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCResourceStore
extends PushdownResourceStore {
    public static final String JDBC_SCHEME = "jdbc";
    private static final ConcurrentHashMap<String, Object> lockObjectMap = new ConcurrentHashMap();
    private static final String META_TABLE_KEY = "META_TABLE_KEY";
    private static final String META_TABLE_TS = "META_TABLE_TS";
    private static final String META_TABLE_CONTENT = "META_TABLE_CONTENT";
    private static Logger logger = LoggerFactory.getLogger(JDBCResourceStore.class);
    private JDBCConnectionManager connectionManager;
    private String[] tableNames = new String[2];
    private String metadataIdentifier = null;
    private long queriedSqlNum = 0L;

    public JDBCResourceStore(KylinConfig kylinConfig) throws SQLException, IOException {
        super(kylinConfig);
        StorageURL metadataUrl = kylinConfig.getMetadataUrl();
        JDBCResourceStore.checkScheme(metadataUrl);
        this.tableNames[0] = this.metadataIdentifier = metadataUrl.getIdentifier();
        this.tableNames[1] = this.metadataIdentifier + "_log";
        this.connectionManager = JDBCConnectionManager.getConnectionManager();
        for (int i = 0; i < this.tableNames.length; ++i) {
            this.createTableIfNeeded(this.tableNames[i]);
        }
    }

    public static void checkScheme(StorageURL url) {
        Preconditions.checkState((boolean)JDBC_SCHEME.equals(url.getScheme()));
    }

    private Object getConcurrentObject(String resPath) {
        if (!lockObjectMap.containsKey(resPath)) {
            this.addObject(resPath);
        }
        return lockObjectMap.get(resPath);
    }

    private synchronized void addObject(String resPath) {
        if (!lockObjectMap.containsKey(resPath)) {
            lockObjectMap.put(resPath, new Object());
        }
    }

    private void executeSql(SqlOperation operation) throws SQLException, IOException {
        Connection connection = null;
        try {
            connection = this.connectionManager.getConn();
            connection.setTransactionIsolation(2);
            operation.execute(connection);
            ++this.queriedSqlNum;
        }
        finally {
            DBUtils.closeQuietly(operation.rs);
            DBUtils.closeQuietly(operation.pstat);
            DBUtils.closeQuietly(connection);
        }
    }

    private void createTableIfNeeded(final String tableName) throws SQLException, IOException {
        final JDBCResourceSQL sqls = this.getJDBCResourceSQL(tableName);
        this.executeSql(new SqlOperation(){

            @Override
            public void execute(Connection connection) throws SQLException {
                if (this.checkTableExists(tableName, connection)) {
                    logger.info("Table [{}] already exists", (Object)tableName);
                    return;
                }
                String createIfNeededSql = sqls.getCreateIfNeededSql(tableName);
                logger.info("Creating table: {}", (Object)createIfNeededSql);
                this.pstat = connection.prepareStatement(createIfNeededSql);
                this.pstat.executeUpdate();
                try {
                    String indexName = "IDX_META_TABLE_TS";
                    String createIndexSql = sqls.getCreateIndexSql(indexName, tableName, JDBCResourceStore.META_TABLE_TS);
                    logger.info("Creating index: {}", (Object)createIndexSql);
                    this.pstat = connection.prepareStatement(createIndexSql);
                    this.pstat.executeUpdate();
                }
                catch (SQLException ex) {
                    logger.error("Failed to create index on {}", (Object)JDBCResourceStore.META_TABLE_TS, (Object)ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean checkTableExists(String tableName2, Connection connection) throws SQLException {
                boolean bl;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    String checkTableExistsSql = sqls.getCheckTableExistsSql(tableName2);
                    ps = connection.prepareStatement(checkTableExistsSql);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        if (!tableName2.equalsIgnoreCase(rs.getString(1))) continue;
                        bl = true;
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeQuietly(rs);
                    DBUtils.closeQuietly(ps);
                    throw throwable;
                }
                {
                    DBUtils.closeQuietly(rs);
                    DBUtils.closeQuietly(ps);
                    return bl;
                }
                DBUtils.closeQuietly(rs);
                DBUtils.closeQuietly(ps);
                return false;
            }
        });
    }

    public long getQueriedSqlNum() {
        return this.queriedSqlNum;
    }

    public void close() {
        this.connectionManager.close();
    }

    private boolean isJsonMetadata(String resourcePath) {
        String trim = resourcePath.trim();
        return trim.endsWith(".json") || trim.startsWith("/execute") || trim.startsWith("/execute_output");
    }

    @Override
    protected void visitFolderImpl(final String folderPath, final boolean recursive, final ResourceStore.VisitFilter filter, final boolean loadContent, final ResourceStore.Visitor visitor) throws IOException {
        try {
            this.executeSql(new SqlOperation(){

                @Override
                public void execute(Connection connection) throws SQLException {
                    String folderPrefix;
                    String lookForPrefix = folderPrefix = folderPath.endsWith("/") ? folderPath : folderPath + "/";
                    if (filter.hasPathPrefixFilter()) {
                        Preconditions.checkArgument((boolean)filter.pathPrefix.startsWith(folderPrefix));
                        lookForPrefix = filter.pathPrefix;
                    }
                    if (JDBCResourceStore.this.isRootPath(folderPath)) {
                        for (int i = 0; i < JDBCResourceStore.this.tableNames.length; ++i) {
                            String tableName = JDBCResourceStore.this.tableNames[i];
                            JDBCResourceSQL sqls = JDBCResourceStore.this.getJDBCResourceSQL(tableName);
                            String sql = sqls.getAllResourceSqlString(loadContent);
                            this.pstat = connection.prepareStatement(sql);
                            this.pstat.setString(1, lookForPrefix.replace("_", "#_") + "%");
                            this.pstat.setLong(2, filter.lastModStart);
                            this.pstat.setLong(3, filter.lastModEndExclusive);
                            this.rs = this.pstat.executeQuery();
                            while (this.rs.next()) {
                                String resPath = this.rs.getString(JDBCResourceStore.META_TABLE_KEY);
                                if (resPath.equals(folderPath) || !recursive && !JDBCResourceStore.this.isDirectChild(folderPrefix, resPath)) continue;
                                try (RawResource raw = JDBCResourceStore.this.rawResource(this.rs, loadContent, true);){
                                    visitor.visit(raw);
                                }
                            }
                        }
                    } else {
                        JDBCResourceSQL sqls = JDBCResourceStore.this.getJDBCResourceSQL(JDBCResourceStore.this.getMetaTableName(folderPath));
                        String sql = sqls.getAllResourceSqlString(loadContent);
                        this.pstat = connection.prepareStatement(sql);
                        this.pstat.setString(1, lookForPrefix.replace("_", "#_") + "%");
                        this.pstat.setLong(2, filter.lastModStart);
                        this.pstat.setLong(3, filter.lastModEndExclusive);
                        this.rs = this.pstat.executeQuery();
                        while (this.rs.next()) {
                            String resPath = this.rs.getString(JDBCResourceStore.META_TABLE_KEY);
                            if (resPath.equals(folderPath) || !recursive && !JDBCResourceStore.this.isDirectChild(folderPrefix, resPath)) continue;
                            try (RawResource raw = JDBCResourceStore.this.rawResource(this.rs, loadContent, true);){
                                visitor.visit(raw);
                            }
                        }
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    private boolean isDirectChild(String folderPrefix, String resPath) {
        assert (resPath.startsWith(folderPrefix));
        int cut = resPath.indexOf(47, folderPrefix.length());
        return cut < 0;
    }

    @Override
    protected boolean existsImpl(String resPath) throws IOException {
        try {
            RawResource resource = this.getResourceInteral(resPath, false, false);
            return resource != null;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected RawResource getResourceImpl(String resPath) throws IOException {
        try {
            return this.getResourceInteral(resPath, true, true);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    RawResource getResourceInteral(final String resourcePath, final boolean fetchContent, final boolean fetchTimestamp) throws SQLException, IOException {
        logger.trace("getResource method. resourcePath : {} , fetchConetent : {} , fetch TS : {}", new Object[]{resourcePath, fetchContent, fetchTimestamp});
        final RawResource[] holder = new RawResource[1];
        final JDBCResourceSQL sqls = this.getJDBCResourceSQL(this.getMetaTableName(resourcePath));
        this.executeSql(new SqlOperation(){

            @Override
            public void execute(Connection connection) throws SQLException {
                this.pstat = connection.prepareStatement(sqls.getKeyEqualSqlString(fetchContent, fetchTimestamp));
                this.pstat.setString(1, resourcePath);
                this.rs = this.pstat.executeQuery();
                if (this.rs.next()) {
                    holder[0] = JDBCResourceStore.this.rawResource(this.rs, fetchContent, fetchTimestamp);
                }
            }
        });
        return holder[0];
    }

    private RawResource rawResource(ResultSet rs, boolean fetchContent, boolean fetchTime) throws SQLException {
        long ts;
        String path = rs.getString(META_TABLE_KEY);
        long l = ts = fetchTime ? rs.getLong(META_TABLE_TS) : -1L;
        if (fetchContent) {
            try {
                return new RawResource(path, ts, this.getInputStream(path, rs));
            }
            catch (IOException e) {
                return new RawResource(path, ts, e);
            }
            catch (SQLException e) {
                return new RawResource(path, ts, new IOException(e));
            }
        }
        return new RawResource(path, ts);
    }

    private InputStream getInputStream(String resPath, ResultSet rs) throws SQLException, IOException {
        if (rs == null) {
            return null;
        }
        Blob blob = rs.getBlob(META_TABLE_CONTENT);
        if (blob == null || blob.length() == 0L) {
            return this.openPushdown(resPath);
        }
        return blob.getBinaryStream();
    }

    @Override
    protected long getResourceTimestampImpl(String resPath) throws IOException {
        try {
            RawResource resource = this.getResourceInteral(resPath, false, true);
            return resource == null ? 0L : resource.lastModified();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void putSmallResource(String resPath, ContentWriter content, long ts) throws IOException {
        try {
            this.putResourceInternal(resPath, content, ts);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    void putResourceInternal(final String resPath, final ContentWriter content, final long ts) throws SQLException, IOException {
        this.executeSql(new SqlOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Connection connection) throws SQLException, IOException {
                byte[] bytes = content.extractAllBytes();
                Object object = JDBCResourceStore.this.getConcurrentObject(resPath);
                synchronized (object) {
                    block14: {
                        JDBCResourceSQL sqls = JDBCResourceStore.this.getJDBCResourceSQL(JDBCResourceStore.this.getMetaTableName(resPath));
                        boolean existing = JDBCResourceStore.this.existsImpl(resPath);
                        if (existing) {
                            this.pstat = connection.prepareStatement(sqls.getReplaceSql());
                            this.pstat.setLong(1, ts);
                            this.pstat.setBlob(2, new BufferedInputStream(new ByteArrayInputStream(bytes)));
                            this.pstat.setString(3, resPath);
                        } else {
                            this.pstat = connection.prepareStatement(sqls.getInsertSql());
                            this.pstat.setString(1, resPath);
                            this.pstat.setLong(2, ts);
                            this.pstat.setBlob(3, new BufferedInputStream(new ByteArrayInputStream(bytes)));
                        }
                        if (JDBCResourceStore.this.isContentOverflow(bytes, resPath)) {
                            logger.debug("Overflow! resource path: {}, content size: {}, timeStamp: {}", new Object[]{resPath, bytes.length, ts});
                            if (existing) {
                                this.pstat.setNull(2, 2004);
                            } else {
                                this.pstat.setNull(3, 2004);
                            }
                            try (PushdownResourceStore.RollbackablePushdown pushdown = JDBCResourceStore.this.writePushdown(resPath, ContentWriter.create(bytes));){
                                int result = this.pstat.executeUpdate();
                                if (result != 1) {
                                    throw new SQLException();
                                }
                                break block14;
                            }
                        }
                        this.pstat.executeUpdate();
                    }
                }
            }
        });
    }

    private boolean isContentOverflow(byte[] content, String resPath) throws SQLException {
        if (this.kylinConfig.isJsonAlwaysSmallCell() && this.isJsonMetadata(resPath)) {
            int smallCellMetadataWarningThreshold = this.kylinConfig.getSmallCellMetadataWarningThreshold();
            int smallCellMetadataErrorThreshold = this.kylinConfig.getSmallCellMetadataErrorThreshold();
            if (content.length > smallCellMetadataWarningThreshold) {
                logger.warn("A JSON metadata entry's size is not supposed to exceed kylin.metadata.jdbc.small-cell-meta-size-warning-threshold({}), resPath: {}, actual size: {}", new Object[]{smallCellMetadataWarningThreshold, resPath, content.length});
            }
            if (content.length > smallCellMetadataErrorThreshold) {
                throw new SQLException(new IllegalArgumentException("A JSON metadata entry's size is not supposed to exceed kylin.metadata.jdbc.small-cell-meta-size-error-threshold(" + smallCellMetadataErrorThreshold + "), resPath: " + resPath + ", actual size: " + content.length));
            }
            return false;
        }
        int maxSize = this.kylinConfig.getJdbcResourceStoreMaxCellSize();
        return content.length > maxSize;
    }

    @Override
    protected long checkAndPutResourceImpl(String resPath, byte[] content, long oldTS, long newTS) throws IOException, WriteConflictException {
        try {
            this.checkAndPutResourceInternal(resPath, content, oldTS, newTS);
            return newTS;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    void checkAndPutResourceInternal(final String resPath, final byte[] content, final long oldTS, final long newTS) throws SQLException, IOException, WriteConflictException {
        logger.trace("execute checkAndPutResource method. resPath : {} , oldTs : {} , newTs : {} , content null ? : {} ", new Object[]{resPath, oldTS, newTS, content == null});
        this.executeSql(new SqlOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Connection connection) throws SQLException, IOException {
                Object object = JDBCResourceStore.this.getConcurrentObject(resPath);
                synchronized (object) {
                    block21: {
                        JDBCResourceSQL sqls = JDBCResourceStore.this.getJDBCResourceSQL(JDBCResourceStore.this.getMetaTableName(resPath));
                        if (!JDBCResourceStore.this.existsImpl(resPath)) {
                            if (oldTS != 0L) {
                                throw new IllegalStateException("For not exist file. OldTS have to be 0. but Actual oldTS is : " + oldTS);
                            }
                            if (JDBCResourceStore.this.isContentOverflow(content, resPath)) {
                                logger.debug("Overflow! resource path: {}, content size: {}", (Object)resPath, (Object)content.length);
                                this.pstat = connection.prepareStatement(sqls.getInsertSqlWithoutContent());
                                this.pstat.setString(1, resPath);
                                this.pstat.setLong(2, newTS);
                                try (PushdownResourceStore.RollbackablePushdown pushdown = JDBCResourceStore.this.writePushdown(resPath, ContentWriter.create(content));){
                                    int result = this.pstat.executeUpdate();
                                    if (result != 1) {
                                        throw new SQLException();
                                    }
                                    break block21;
                                }
                            }
                            this.pstat = connection.prepareStatement(sqls.getInsertSql());
                            this.pstat.setString(1, resPath);
                            this.pstat.setLong(2, newTS);
                            this.pstat.setBlob(3, new BufferedInputStream(new ByteArrayInputStream(content)));
                            this.pstat.executeUpdate();
                        } else {
                            this.pstat = connection.prepareStatement(sqls.getUpdateContentAndTsSql());
                            this.pstat.setLong(1, newTS);
                            this.pstat.setString(3, resPath);
                            this.pstat.setLong(4, oldTS);
                            if (JDBCResourceStore.this.isContentOverflow(content, resPath)) {
                                this.pstat.setNull(2, 2004);
                                try (PushdownResourceStore.RollbackablePushdown pushdown = JDBCResourceStore.this.writePushdown(resPath, ContentWriter.create(content));){
                                    int result = this.pstat.executeUpdate();
                                    if (result != 1) {
                                        throw new SQLException();
                                    }
                                    break block21;
                                }
                            }
                            this.pstat.setBinaryStream(2, new BufferedInputStream(new ByteArrayInputStream(content)));
                            int result = this.pstat.executeUpdate();
                            if (result != 1) {
                                long realTime = JDBCResourceStore.this.getResourceTimestamp(resPath);
                                throw new WriteConflictException("Overwriting conflict " + resPath + ", expect old TS " + oldTS + ", but it is " + realTime);
                            }
                        }
                    }
                }
            }
        });
    }

    @Override
    protected void updateTimestampImpl(final String resPath, final long timestamp) throws IOException {
        block4: {
            try {
                boolean skipHdfs = this.isJsonMetadata(resPath);
                final JDBCResourceSQL sqls = this.getJDBCResourceSQL(this.getMetaTableName(resPath));
                this.executeSql(new SqlOperation(){

                    @Override
                    public void execute(Connection connection) throws SQLException {
                        this.pstat = connection.prepareStatement(sqls.getReplaceSqlWithoutContent());
                        this.pstat.setLong(1, timestamp);
                        this.pstat.setString(2, resPath);
                        this.pstat.executeUpdate();
                    }
                });
                if (skipHdfs) break block4;
                try {
                    this.updateTimestampPushdown(resPath, timestamp);
                }
                catch (Throwable e) {
                    throw new SQLException(e);
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    protected void deleteResourceImpl(final String resPath) throws IOException {
        block4: {
            try {
                boolean skipHdfs = this.isJsonMetadata(resPath);
                final JDBCResourceSQL sqls = this.getJDBCResourceSQL(this.getMetaTableName(resPath));
                this.executeSql(new SqlOperation(){

                    @Override
                    public void execute(Connection connection) throws SQLException {
                        this.pstat = connection.prepareStatement(sqls.getDeletePstatSql());
                        this.pstat.setString(1, resPath);
                        this.pstat.executeUpdate();
                    }
                });
                if (skipHdfs) break block4;
                try {
                    this.deletePushdown(resPath);
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    protected void deleteResourceImpl(String resPath, long timestamp) throws IOException {
        long origLastModified = this.getResourceTimestampImpl(resPath);
        if (!this.checkTimeStampBeforeDelete(origLastModified, timestamp)) {
            throw new IOException("Resource " + resPath + " timestamp not match, [originLastModified: " + origLastModified + ", timestampToDelete: " + timestamp + "]");
        }
        this.deleteResourceImpl(resPath);
    }

    @Override
    protected String getReadableResourcePathImpl(String resPath) {
        return this.metadataIdentifier + "(key='" + resPath + "')@" + this.kylinConfig.getMetadataUrl();
    }

    @Override
    protected String pushdownRootPath() {
        String metastoreBigCellHdfsDirectory = this.kylinConfig.getMetastoreBigCellHdfsDirectory();
        if (metastoreBigCellHdfsDirectory.endsWith("/")) {
            return metastoreBigCellHdfsDirectory + "resources-jdbc";
        }
        return metastoreBigCellHdfsDirectory + "/resources-jdbc";
    }

    @Override
    protected FileSystem pushdownFS() {
        return super.pushdownFS();
    }

    @Override
    protected boolean isUnreachableException(Throwable ex) {
        if (super.isUnreachableException(ex)) {
            return true;
        }
        if (ex instanceof SocketTimeoutException) {
            return true;
        }
        ArrayList<String> exceptionList = new ArrayList<String>();
        exceptionList.add(ex.getClass().getName());
        Throwable t = ex.getCause();
        for (int depth = 0; t != null && depth < 5; ++depth, t = t.getCause()) {
            exceptionList.add(t.getClass().getName());
            if (!(t instanceof ConnectException)) continue;
            return true;
        }
        logger.trace("Not an unreachable exception with causes {}", exceptionList);
        return false;
    }

    public String getMetaTableName(String resPath) {
        if (this.isRootPath(resPath)) {
            throw new IllegalArgumentException("Not supported");
        }
        if (resPath.startsWith("/bad_query") || resPath.startsWith("/execute_output") || resPath.startsWith("/temp_statement")) {
            return this.tableNames[1];
        }
        return this.tableNames[0];
    }

    private JDBCResourceSQL getJDBCResourceSQL(String metaTableName) {
        return new JDBCResourceSQL(this.kylinConfig.getMetadataDialect(), metaTableName, META_TABLE_KEY, META_TABLE_TS, META_TABLE_CONTENT);
    }

    public boolean isRootPath(String path) {
        return "/".equals(path);
    }

    static abstract class SqlOperation {
        PreparedStatement pstat = null;
        ResultSet rs = null;

        SqlOperation() {
        }

        public abstract void execute(Connection var1) throws SQLException, IOException;
    }
}

