/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.ContentWriter;
import org.apache.kylin.common.persistence.PushdownResourceStore;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.WriteConflictException;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseResourceStore
extends PushdownResourceStore {
    private static Logger logger = LoggerFactory.getLogger(HBaseResourceStore.class);
    private static final String FAMILY = "f";
    private static final byte[] B_FAMILY = Bytes.toBytes("f");
    private static final String COLUMN = "c";
    private static final byte[] B_COLUMN = Bytes.toBytes("c");
    private static final String COLUMN_TS = "t";
    private static final byte[] B_COLUMN_TS = Bytes.toBytes("t");
    final String tableName;
    final StorageURL metadataUrl;
    final int kvSizeLimit;

    public HBaseResourceStore(KylinConfig kylinConfig) throws IOException {
        super(kylinConfig);
        this.metadataUrl = this.buildMetadataUrl(kylinConfig);
        this.tableName = this.metadataUrl.getIdentifier();
        this.createHTableIfNeeded(this.tableName);
        this.kvSizeLimit = Integer.parseInt(this.getConnection().getConfiguration().get("hbase.client.keyvalue.maxsize", "10485760"));
    }

    Connection getConnection() throws IOException {
        return HBaseConnection.get(this.metadataUrl);
    }

    private StorageURL buildMetadataUrl(KylinConfig kylinConfig) throws IOException {
        StorageURL url = kylinConfig.getMetadataUrl();
        if (!url.getScheme().equals("hbase")) {
            throw new IOException("Cannot create HBaseResourceStore. Url not match. Url: " + url);
        }
        LinkedHashMap<String, String> newParams = new LinkedHashMap<String, String>();
        newParams.put("hbase.client.scanner.timeout.period", kylinConfig.getHbaseClientScannerTimeoutPeriod());
        newParams.put("hbase.rpc.timeout", kylinConfig.getHbaseRpcTimeout());
        newParams.put("hbase.client.retries.number", kylinConfig.getHbaseClientRetriesNumber());
        newParams.putAll(url.getAllParameters());
        return url.copy(newParams);
    }

    private void createHTableIfNeeded(String tableName) throws IOException {
        HBaseConnection.createHTableIfNeeded(this.getConnection(), tableName, FAMILY);
    }

    @Override
    protected boolean existsImpl(String resPath) throws IOException {
        Result r = this.getFromHTable(resPath, false, false);
        return r != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String createMetaStoreUUID() throws IOException {
        try (Admin hbaseAdmin = HBaseConnection.get(this.metadataUrl).getAdmin();){
            String metaStoreName = this.metadataUrl.getIdentifier();
            HTableDescriptor desc = hbaseAdmin.getTableDescriptor(TableName.valueOf((String)metaStoreName));
            String uuid = desc.getValue("UUID");
            if (uuid != null) {
                String string2 = uuid;
                return string2;
            }
            String string = UUID.randomUUID().toString();
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getMetaStoreUUID() throws IOException {
        if (!this.exists("/UUID")) {
            this.checkAndPutResource("/UUID", new StringEntity(this.createMetaStoreUUID()), 0L, StringEntity.serializer);
        }
        StringEntity entity = this.getResource("/UUID", StringEntity.serializer);
        return entity.toString();
    }

    @Override
    protected void visitFolderImpl(String folderPath, final boolean recursive, ResourceStore.VisitFilter filter, final boolean loadContent, final ResourceStore.Visitor visitor) throws IOException {
        this.visitFolder(folderPath, filter, loadContent, new FolderVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(String childPath, String fullPath, Result hbaseResult) throws IOException {
                boolean isDirectChild = childPath.equals(fullPath);
                if (isDirectChild || recursive) {
                    try (RawResource resource = HBaseResourceStore.this.rawResource(fullPath, hbaseResult, loadContent);){
                        visitor.visit(resource);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitFolder(String folderPath, ResourceStore.VisitFilter filter, boolean loadContent, FolderVisitor visitor) throws IOException {
        FilterList timeFilter;
        String folderPrefix;
        assert (folderPath.startsWith("/"));
        String lookForPrefix = folderPrefix = folderPath.endsWith("/") ? folderPath : folderPath + "/";
        if (filter.hasPathPrefixFilter()) {
            Preconditions.checkArgument((boolean)filter.pathPrefix.startsWith(folderPrefix));
            lookForPrefix = filter.pathPrefix;
        }
        byte[] startRow = Bytes.toBytes(lookForPrefix);
        byte[] endRow = Bytes.toBytes(lookForPrefix);
        int n = endRow.length - 1;
        endRow[n] = (byte)(endRow[n] + 1);
        Table table = this.getConnection().getTable(TableName.valueOf((String)this.tableName));
        Scan scan = new Scan(startRow, endRow);
        scan.addColumn(B_FAMILY, B_COLUMN_TS);
        if (loadContent) {
            scan.addColumn(B_FAMILY, B_COLUMN);
        }
        if ((timeFilter = this.generateTimeFilterList(filter)) != null) {
            scan.setFilter((Filter)timeFilter);
        }
        this.tuneScanParameters(scan);
        try {
            ResultScanner scanner = table.getScanner(scan);
            for (Result r : scanner) {
                String path = Bytes.toString(r.getRow());
                assert (path.startsWith(lookForPrefix));
                int cut = path.indexOf(47, folderPrefix.length());
                String directChild = cut < 0 ? path : path.substring(0, cut);
                visitor.visit(directChild, path, r);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)table);
        }
    }

    private void tuneScanParameters(Scan scan) {
        scan.setCaching(this.kylinConfig.getHBaseScanCacheRows());
        scan.setMaxResultSize((long)this.kylinConfig.getHBaseScanMaxResultSize());
        scan.setCacheBlocks(true);
    }

    private RawResource rawResource(String path, Result hbaseResult, boolean loadContent) {
        long lastModified = this.getTimestamp(hbaseResult);
        if (loadContent) {
            try {
                return new RawResource(path, lastModified, this.getInputStream(path, hbaseResult));
            }
            catch (IOException ex) {
                return new RawResource(path, lastModified, ex);
            }
        }
        return new RawResource(path, lastModified);
    }

    private FilterList generateTimeFilterList(ResourceStore.VisitFilter visitFilter) {
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        if (visitFilter.lastModStart >= 0L) {
            SingleColumnValueFilter timeStartFilter = new SingleColumnValueFilter(B_FAMILY, B_COLUMN_TS, CompareFilter.CompareOp.GREATER_OR_EQUAL, Bytes.toBytes(visitFilter.lastModStart));
            filterList.addFilter((Filter)timeStartFilter);
        }
        if (visitFilter.lastModEndExclusive != Long.MAX_VALUE) {
            SingleColumnValueFilter timeEndFilter = new SingleColumnValueFilter(B_FAMILY, B_COLUMN_TS, CompareFilter.CompareOp.LESS, Bytes.toBytes(visitFilter.lastModEndExclusive));
            filterList.addFilter((Filter)timeEndFilter);
        }
        return filterList.getFilters().isEmpty() ? null : filterList;
    }

    private InputStream getInputStream(String resPath, Result r) throws IOException {
        if (r == null) {
            return null;
        }
        byte[] value = r.getValue(B_FAMILY, B_COLUMN);
        if (value.length == 0) {
            return this.openPushdown(resPath);
        }
        return new ByteArrayInputStream(value);
    }

    private long getTimestamp(Result r) {
        if (r == null || r.getValue(B_FAMILY, B_COLUMN_TS) == null) {
            return 0L;
        }
        return Bytes.toLong(r.getValue(B_FAMILY, B_COLUMN_TS));
    }

    @Override
    protected RawResource getResourceImpl(String resPath) throws IOException {
        Result r = this.getFromHTable(resPath, true, true);
        if (r == null) {
            return null;
        }
        return this.rawResource(resPath, r, true);
    }

    @Override
    protected long getResourceTimestampImpl(String resPath) throws IOException {
        return this.getTimestamp(this.getFromHTable(resPath, false, true));
    }

    @Override
    protected void putSmallResource(String resPath, ContentWriter content, long ts) throws IOException {
        byte[] row = Bytes.toBytes(resPath);
        byte[] bytes = content.extractAllBytes();
        Table table = this.getConnection().getTable(TableName.valueOf((String)this.tableName));
        PushdownResourceStore.RollbackablePushdown pushdown = null;
        try {
            if (bytes.length > this.kvSizeLimit) {
                pushdown = this.writePushdown(resPath, ContentWriter.create(bytes));
                bytes = BytesUtil.EMPTY_BYTE_ARRAY;
            }
            Put put = new Put(row);
            put.addColumn(B_FAMILY, B_COLUMN, bytes);
            put.addColumn(B_FAMILY, B_COLUMN_TS, Bytes.toBytes(ts));
            table.put(put);
        }
        catch (Exception ex) {
            if (pushdown != null) {
                pushdown.rollback();
            }
            throw ex;
        }
        finally {
            if (pushdown != null) {
                pushdown.close();
            }
            IOUtils.closeQuietly((Closeable)table);
        }
    }

    @Override
    protected long checkAndPutResourceImpl(String resPath, byte[] content, long oldTS, long newTS) throws IOException, IllegalStateException {
        Table table = this.getConnection().getTable(TableName.valueOf((String)this.tableName));
        PushdownResourceStore.RollbackablePushdown pushdown = null;
        try {
            byte[] bOldTS;
            byte[] row = Bytes.toBytes(resPath);
            byte[] byArray = bOldTS = oldTS == 0L ? null : Bytes.toBytes(oldTS);
            if (content.length > this.kvSizeLimit) {
                pushdown = this.writePushdown(resPath, ContentWriter.create(content));
                content = BytesUtil.EMPTY_BYTE_ARRAY;
            }
            Put put = new Put(row);
            put.addColumn(B_FAMILY, B_COLUMN, content);
            put.addColumn(B_FAMILY, B_COLUMN_TS, Bytes.toBytes(newTS));
            boolean ok = table.checkAndPut(row, B_FAMILY, B_COLUMN_TS, bOldTS, put);
            logger.trace("Update row {} from oldTs: {}, to newTs: {}, operation result: {}", new Object[]{resPath, oldTS, newTS, ok});
            if (!ok) {
                long real = this.getResourceTimestampImpl(resPath);
                throw new WriteConflictException("Overwriting conflict " + resPath + ", expect old TS " + oldTS + ", but it is " + real);
            }
            long l = newTS;
            return l;
        }
        catch (Exception ex) {
            if (pushdown != null) {
                pushdown.rollback();
            }
            throw ex;
        }
        finally {
            if (pushdown != null) {
                pushdown.close();
            }
            IOUtils.closeQuietly((Closeable)table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateTimestampImpl(String resPath, long timestamp) throws IOException {
        Table table = this.getConnection().getTable(TableName.valueOf((String)this.tableName));
        try {
            boolean hdfsResourceExist = this.isHdfsResourceExist(table, resPath);
            long oldTS = this.getResourceLastModified(table, resPath);
            byte[] bOldTS = oldTS == 0L ? null : Bytes.toBytes(oldTS);
            byte[] row = Bytes.toBytes(resPath);
            Put put = new Put(row);
            put.addColumn(B_FAMILY, B_COLUMN_TS, Bytes.toBytes(timestamp));
            boolean ok = table.checkAndPut(row, B_FAMILY, B_COLUMN_TS, bOldTS, put);
            logger.trace("Update row {} from oldTs: {}, to newTs: {}, operation result: {}", new Object[]{resPath, oldTS, timestamp, ok});
            if (!ok) {
                long real = this.getResourceTimestampImpl(resPath);
                throw new WriteConflictException("Overwriting conflict " + resPath + ", expect old TS " + oldTS + ", but it is " + real);
            }
            if (hdfsResourceExist) {
                this.updateTimestampPushdown(resPath, timestamp);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteResourceImpl(String resPath) throws IOException {
        Table table = this.getConnection().getTable(TableName.valueOf((String)this.tableName));
        try {
            boolean hdfsResourceExist = this.isHdfsResourceExist(table, resPath);
            Delete del = new Delete(Bytes.toBytes(resPath));
            table.delete(del);
            if (hdfsResourceExist) {
                this.deletePushdown(resPath);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteResourceImpl(String resPath, long timestamp) throws IOException {
        block5: {
            Table table = this.getConnection().getTable(TableName.valueOf((String)this.tableName));
            try {
                boolean hdfsResourceExist = this.isHdfsResourceExist(table, resPath);
                long origLastModified = this.getResourceLastModified(table, resPath);
                if (this.checkTimeStampBeforeDelete(origLastModified, timestamp)) {
                    Delete del = new Delete(Bytes.toBytes(resPath));
                    table.delete(del);
                    if (hdfsResourceExist) {
                        this.deletePushdown(resPath);
                    }
                    break block5;
                }
                throw new IOException("Resource " + resPath + " timestamp not match, [originLastModified: " + origLastModified + ", timestampToDelete: " + timestamp + "]");
            }
            finally {
                IOUtils.closeQuietly((Closeable)table);
            }
        }
    }

    private long getResourceLastModified(Table table, String resPath) throws IOException {
        return this.getTimestamp(this.internalGetFromHTable(table, resPath, false, true));
    }

    private boolean isHdfsResourceExist(Table table, String resPath) throws IOException {
        byte[] contentVal;
        boolean hdfsResourceExist = false;
        Result result = this.internalGetFromHTable(table, resPath, true, false);
        if (result != null && (contentVal = result.getValue(B_FAMILY, B_COLUMN)) != null && contentVal.length == 0) {
            hdfsResourceExist = true;
        }
        return hdfsResourceExist;
    }

    @Override
    protected String getReadableResourcePathImpl(String resPath) {
        return this.tableName + "(key='" + resPath + "')@" + this.kylinConfig.getMetadataUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result getFromHTable(String path, boolean fetchContent, boolean fetchTimestamp) throws IOException {
        Table table = this.getConnection().getTable(TableName.valueOf((String)this.tableName));
        try {
            Result result = this.internalGetFromHTable(table, path, fetchContent, fetchTimestamp);
            return result;
        }
        finally {
            IOUtils.closeQuietly((Closeable)table);
        }
    }

    private Result internalGetFromHTable(Table table, String path, boolean fetchContent, boolean fetchTimestamp) throws IOException {
        byte[] rowkey = Bytes.toBytes(path);
        Get get = new Get(rowkey);
        if (!fetchContent && !fetchTimestamp) {
            get.setCheckExistenceOnly(true);
        } else {
            if (fetchContent) {
                get.addColumn(B_FAMILY, B_COLUMN);
            }
            if (fetchTimestamp) {
                get.addColumn(B_FAMILY, B_COLUMN_TS);
            }
        }
        Result result = table.get(get);
        boolean exists = result != null && (!result.isEmpty() || result.getExists() != null && result.getExists() != false);
        return exists ? result : null;
    }

    @Override
    protected String pushdownRootPath() {
        String hdfsWorkingDirectory = this.kylinConfig.getHdfsWorkingDirectory(null);
        if (hdfsWorkingDirectory.endsWith("/")) {
            return hdfsWorkingDirectory + "resources";
        }
        return hdfsWorkingDirectory + "/resources";
    }

    @Override
    protected FileSystem pushdownFS() {
        return HadoopUtil.getFileSystem(new Path("/"), HBaseConnection.getCurrentHBaseConfiguration());
    }

    Path bigCellHDFSPath(String resPath) {
        return super.pushdownPath(resPath);
    }

    @Override
    protected boolean isUnreachableException(Throwable ex) {
        return super.isUnreachableException(ex) || ex instanceof SocketTimeoutException || ex instanceof ConnectException || ex instanceof RetriesExhaustedException;
    }

    public String toString() {
        return this.tableName + "@hbase";
    }

    static interface FolderVisitor {
        public void visit(String var1, String var2, Result var3) throws IOException;
    }
}

