/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataModelManager {
    private static final Logger logger = LoggerFactory.getLogger(DataModelManager.class);
    private KylinConfig config;
    private CaseInsensitiveStringCache<DataModelDesc> dataModelDescMap;
    private CachedCrudAssist<DataModelDesc> crud;
    private AutoReadWriteLock modelMapLock = new AutoReadWriteLock();

    public static DataModelManager getInstance(KylinConfig config) {
        return config.getManager(DataModelManager.class);
    }

    static DataModelManager newInstance(KylinConfig conf) {
        try {
            String cls = StringUtil.noBlank(conf.getDataModelManagerImpl(), DataModelManager.class.getName());
            Class<DataModelManager> clz = ClassUtil.forName(cls, DataModelManager.class);
            return clz.getConstructor(KylinConfig.class).newInstance(conf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init DataModelManager from " + conf, e);
        }
    }

    public DataModelManager(KylinConfig config) throws IOException {
        this.init(config);
    }

    protected void init(KylinConfig cfg) throws IOException {
        this.config = cfg;
        this.dataModelDescMap = new CaseInsensitiveStringCache(this.config, "data_model");
        this.crud = new CachedCrudAssist<DataModelDesc>(this.getStore(), "/model_desc", this.getDataModelImplClass(), this.dataModelDescMap){

            @Override
            protected DataModelDesc initEntityAfterReload(DataModelDesc model, String resourceName) {
                String prj;
                String string = prj = null == model.getProjectName() ? ProjectManager.getInstance(DataModelManager.this.config).getProjectOfModel(model.getName()).getName() : model.getProjectName();
                if (!model.isDraft()) {
                    model.init(DataModelManager.this.config, DataModelManager.this.getAllTablesMap(prj));
                }
                return model;
            }
        };
        TableMetadataManager.getInstance(this.config);
        this.crud.reloadAll();
        Broadcaster.getInstance(this.config).registerListener(new DataModelSyncListener(), "data_model");
    }

    private Class<DataModelDesc> getDataModelImplClass() {
        try {
            String cls = StringUtil.noBlank(this.config.getDataModelImpl(), DataModelDesc.class.getName());
            Class<DataModelDesc> clz = ClassUtil.forName(cls, DataModelDesc.class);
            return clz;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    public Serializer<DataModelDesc> getDataModelSerializer() {
        return this.crud.getSerializer();
    }

    public List<DataModelDesc> listDataModels() {
        try (AutoReadWriteLock.AutoLock lock = this.modelMapLock.lockForRead();){
            ArrayList arrayList = Lists.newArrayList(this.dataModelDescMap.values());
            return arrayList;
        }
    }

    public DataModelDesc getDataModelDesc(String name) {
        try (AutoReadWriteLock.AutoLock lock = this.modelMapLock.lockForRead();){
            DataModelDesc dataModelDesc = (DataModelDesc)this.dataModelDescMap.get(name);
            return dataModelDesc;
        }
    }

    public List<DataModelDesc> getModels() {
        try (AutoReadWriteLock.AutoLock lock = this.modelMapLock.lockForRead();){
            ArrayList<DataModelDesc> arrayList = new ArrayList<DataModelDesc>(this.dataModelDescMap.values());
            return arrayList;
        }
    }

    public List<DataModelDesc> getModels(String projectName) {
        try (AutoReadWriteLock.AutoLock lock = this.modelMapLock.lockForRead();){
            ProjectInstance projectInstance = ProjectManager.getInstance(this.config).getProject(projectName);
            ArrayList<DataModelDesc> ret = new ArrayList<DataModelDesc>();
            if (projectInstance != null && projectInstance.getModels() != null) {
                for (String modelName : projectInstance.getModels()) {
                    DataModelDesc model = this.getDataModelDesc(modelName);
                    if (null != model) {
                        ret.add(model);
                        continue;
                    }
                    logger.info("Model " + modelName + " is missing or unloaded yet");
                }
            }
            ArrayList<DataModelDesc> arrayList = ret;
            return arrayList;
        }
    }

    public List<String> getModelsUsingTable(TableDesc table, String project) {
        try (AutoReadWriteLock.AutoLock lock = this.modelMapLock.lockForRead();){
            ArrayList<String> models = new ArrayList<String>();
            for (DataModelDesc modelDesc : this.getModels(project)) {
                if (!modelDesc.containsTable(table)) continue;
                models.add(modelDesc.getName());
            }
            ArrayList<String> arrayList = models;
            return arrayList;
        }
    }

    public boolean isTableInAnyModel(TableDesc table) {
        try (AutoReadWriteLock.AutoLock lock = this.modelMapLock.lockForRead();){
            for (DataModelDesc modelDesc : this.getModels()) {
                if (!modelDesc.containsTable(table)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public DataModelDesc reloadDataModel(String modelName) {
        try (AutoReadWriteLock.AutoLock lock = this.modelMapLock.lockForWrite();){
            DataModelDesc dataModelDesc = this.crud.reload(modelName);
            return dataModelDesc;
        }
    }

    public DataModelDesc dropModel(DataModelDesc desc) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.modelMapLock.lockForWrite();){
            this.crud.delete(desc);
            ProjectManager.getInstance(this.config).removeModelFromProjects(desc.getName());
            DataModelDesc dataModelDesc = desc;
            return dataModelDesc;
        }
    }

    public DataModelDesc createDataModelDesc(DataModelDesc desc, String projectName, String owner) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.modelMapLock.lockForWrite();){
            String name = desc.getName();
            if (this.dataModelDescMap.containsKey(name)) {
                throw new IllegalArgumentException("DataModelDesc '" + name + "' already exists");
            }
            ProjectManager prjMgr = ProjectManager.getInstance(this.config);
            ProjectInstance prj = prjMgr.getProject(projectName);
            if (prj.containsModel(name)) {
                throw new IllegalStateException("project " + projectName + " already contains model " + name);
            }
            desc.setOwner(owner);
            logger.info("Saving Model {} to Project {} with {} as owner", new Object[]{desc.getName(), projectName, owner});
            desc = this.saveDataModelDesc(desc, projectName);
            prjMgr.addModelToProject(name, projectName);
            DataModelDesc dataModelDesc = desc;
            return dataModelDesc;
        }
    }

    public DataModelDesc updateDataModelDesc(DataModelDesc desc) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.modelMapLock.lockForWrite();){
            String name = desc.getName();
            if (!this.dataModelDescMap.containsKey(name)) {
                throw new IllegalArgumentException("DataModelDesc '" + name + "' does not exist.");
            }
            DataModelDesc dataModelDesc = this.saveDataModelDesc(desc, ProjectManager.getInstance(this.config).getProjectOfModel(desc.getName()).getName());
            return dataModelDesc;
        }
    }

    private DataModelDesc saveDataModelDesc(DataModelDesc dataModelDesc, String projectName) throws IOException {
        if (!dataModelDesc.isDraft()) {
            dataModelDesc.init(this.config, this.getAllTablesMap(projectName));
        }
        this.crud.save(dataModelDesc);
        return dataModelDesc;
    }

    private Map<String, TableDesc> getAllTablesMap(String prj) {
        return TableMetadataManager.getInstance(this.config).getAllTablesMap(prj);
    }

    private class DataModelSyncListener
    extends Broadcaster.Listener {
        private DataModelSyncListener() {
        }

        @Override
        public void onProjectSchemaChange(Broadcaster broadcaster, String project) throws IOException {
            TableMetadataManager.getInstance(DataModelManager.this.config).resetProjectSpecificTableDesc(project);
            try (AutoReadWriteLock.AutoLock lock = DataModelManager.this.modelMapLock.lockForWrite();){
                for (String model : ProjectManager.getInstance(DataModelManager.this.config).getProject(project).getModels()) {
                    DataModelManager.this.crud.reloadQuietly(model);
                }
            }
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock lock = DataModelManager.this.modelMapLock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    DataModelManager.this.dataModelDescMap.removeLocal(cacheKey);
                } else {
                    DataModelManager.this.crud.reloadQuietly(cacheKey);
                }
            }
            for (ProjectInstance prj : ProjectManager.getInstance(DataModelManager.this.config).findProjectsByModel(cacheKey)) {
                broadcaster.notifyProjectSchemaUpdate(prj.getName());
            }
        }
    }
}

