/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.expression.TupleExpressionSerializer;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class CaseTupleExpression
extends TupleExpression {
    private List<Pair<TupleFilter, TupleExpression>> whenList;
    private TupleExpression elseExpr;

    public CaseTupleExpression(List<Pair<TupleFilter, TupleExpression>> whenList, TupleExpression elseExpr) {
        super(TupleExpression.ExpressionOperatorEnum.CASE, Collections.emptyList());
        this.whenList = whenList;
        this.elseExpr = elseExpr;
    }

    @Override
    protected boolean ifAbleToPushDown() {
        if (this.ifAbleToPushDown == null) {
            for (Pair<TupleFilter, TupleExpression> whenEntry : this.whenList) {
                this.ifAbleToPushDown = whenEntry.getSecond().ifAbleToPushDown();
                if (this.ifAbleToPushDown.booleanValue()) continue;
                break;
            }
            if (this.elseExpr != null && Boolean.TRUE.equals(this.ifAbleToPushDown)) {
                this.ifAbleToPushDown = this.elseExpr.ifAbleToPushDown();
            }
            if (this.ifAbleToPushDown == null) {
                this.ifAbleToPushDown = true;
            }
        }
        return this.ifAbleToPushDown;
    }

    @Override
    public boolean ifForDynamicColumn() {
        return this.ifAbleToPushDown();
    }

    @Override
    public void verify() {
    }

    @Override
    public Object calculate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        for (Pair<TupleFilter, TupleExpression> entry : this.whenList) {
            if (!entry.getFirst().evaluate(tuple, cs)) continue;
            return entry.getSecond().calculate(tuple, cs);
        }
        if (this.elseExpr != null) {
            return this.elseExpr.calculate(tuple, cs);
        }
        return null;
    }

    @Override
    public TupleExpression accept(ExpressionVisitor visitor) {
        return visitor.visitCaseCall(this);
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        BytesUtil.writeVInt(this.whenList.size(), buffer);
        for (Pair<TupleFilter, TupleExpression> whenEntry : this.whenList) {
            byte[] whenBytes = TupleFilterSerializer.serialize(whenEntry.getFirst(), cs);
            BytesUtil.writeByteArray(whenBytes, buffer);
            byte[] thenBytes = TupleExpressionSerializer.serialize(whenEntry.getSecond(), cs);
            BytesUtil.writeByteArray(thenBytes, buffer);
        }
        if (this.elseExpr != null) {
            BytesUtil.writeVInt(1, buffer);
            byte[] elseBytes = TupleExpressionSerializer.serialize(this.elseExpr, cs);
            BytesUtil.writeByteArray(elseBytes, buffer);
        } else {
            BytesUtil.writeVInt(-1, buffer);
        }
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        int nWhenEntries = BytesUtil.readVInt(buffer);
        ArrayList whenList = Lists.newArrayListWithExpectedSize((int)nWhenEntries);
        for (int i = 0; i < nWhenEntries; ++i) {
            TupleFilter tupleFilter = TupleFilterSerializer.deserialize(BytesUtil.readByteArray(buffer), cs);
            TupleExpression tupleExpression = TupleExpressionSerializer.deserialize(BytesUtil.readByteArray(buffer), cs);
            whenList.add(new Pair<TupleFilter, TupleExpression>(tupleFilter, tupleExpression));
        }
        this.whenList = whenList;
        int flag = BytesUtil.readVInt(buffer);
        if (flag == 1) {
            this.elseExpr = TupleExpressionSerializer.deserialize(BytesUtil.readByteArray(buffer), cs);
        }
    }

    public List<Pair<TupleFilter, TupleExpression>> getWhenList() {
        return ImmutableList.copyOf(this.whenList);
    }

    public TupleExpression getElseExpr() {
        return this.elseExpr;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.operator.toString());
        sb.append("(");
        boolean ifFirst = true;
        for (Pair<TupleFilter, TupleExpression> whenEntry : this.whenList) {
            if (ifFirst) {
                ifFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(whenEntry.getFirst().toString());
            sb.append(",");
            sb.append(whenEntry.getSecond().toString());
        }
        if (this.elseExpr != null) {
            sb.append(",");
            sb.append(this.elseExpr.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseTupleExpression that = (CaseTupleExpression)o;
        if (this.whenList != null ? !this.whenList.equals(that.whenList) : that.whenList != null) {
            return false;
        }
        return this.elseExpr != null ? this.elseExpr.equals(that.elseExpr) : that.elseExpr == null;
    }

    public int hashCode() {
        int result = this.whenList != null ? this.whenList.hashCode() : 0;
        result = 31 * result + (this.elseExpr != null ? this.elseExpr.hashCode() : 0);
        return result;
    }
}

