/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.topn;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kylin.measure.topn.Counter;

public class TopNCounter<T>
implements Iterable<Counter<T>>,
Serializable {
    public static final int EXTRA_SPACE_RATE = 50;
    protected int capacity;
    private HashMap<T, Counter<T>> counterMap;
    protected LinkedList<Counter<T>> counterList;
    private boolean ordered = true;
    private boolean descending = true;
    static final Comparator ASC_COMPARATOR = new Comparator<Counter>(){

        @Override
        public int compare(Counter o1, Counter o2) {
            return Double.compare(o1.getCount(), o2.getCount());
        }
    };
    static final Comparator DESC_COMPARATOR = new Comparator<Counter>(){

        @Override
        public int compare(Counter o1, Counter o2) {
            return Double.compare(o2.getCount(), o1.getCount());
        }
    };

    public TopNCounter(int capacity) {
        this.capacity = capacity;
        this.counterMap = Maps.newHashMap();
        this.counterList = Lists.newLinkedList();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public LinkedList<Counter<T>> getCounterList() {
        return this.counterList;
    }

    public void offer(T item) {
        this.offer(item, 1.0);
    }

    public void offer(T item, double incrementCount) {
        Counter<T> counterNode = this.counterMap.get(item);
        if (counterNode == null) {
            counterNode = new Counter<T>(item, incrementCount);
            this.counterMap.put(item, counterNode);
            this.counterList.add(counterNode);
        } else {
            counterNode.setCount(counterNode.getCount() + incrementCount);
        }
        this.ordered = false;
    }

    public void sortAndRetain() {
        Collections.sort(this.counterList, this.descending ? DESC_COMPARATOR : ASC_COMPARATOR);
        this.retain(this.capacity);
        this.ordered = true;
    }

    public List<Counter<T>> topK(int k) {
        if (!this.ordered) {
            this.sortAndRetain();
        }
        ArrayList<Counter<T>> topK = new ArrayList<Counter<T>>(k);
        for (Counter counter : this.counterList) {
            if (topK.size() == k) {
                return topK;
            }
            topK.add(counter);
        }
        return topK;
    }

    public int size() {
        return this.counterMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Counter counter : this.counterList) {
            sb.append(counter.item);
            sb.append(':');
            sb.append(counter.count);
        }
        sb.append(']');
        return sb.toString();
    }

    public void offerToHead(T item, double count) {
        Counter<T> c = new Counter<T>(item, count);
        this.counterList.addFirst(c);
        this.counterMap.put(c.item, c);
    }

    public TopNCounter<T> merge(TopNCounter<T> another) {
        double m2;
        boolean thisFull = this.size() >= this.capacity;
        boolean anotherFull = another.size() >= another.capacity;
        double m1 = thisFull ? this.counterList.getLast().count : 0.0;
        double d = m2 = anotherFull ? another.counterList.getLast().count : 0.0;
        if (anotherFull) {
            for (Counter counter : this.counterMap.values()) {
                counter.count += m2;
            }
        }
        for (Map.Entry entry : another.counterMap.entrySet()) {
            Counter<T> counter = this.counterMap.get(entry.getKey());
            if (counter != null) {
                counter.setCount(counter.getCount() + (((Counter)entry.getValue()).count - m2));
                continue;
            }
            counter = new Counter(((Counter)entry.getValue()).getItem(), ((Counter)entry.getValue()).count + m1);
            this.counterMap.put(((Counter)entry.getValue()).getItem(), counter);
            this.counterList.add(counter);
        }
        this.ordered = false;
        this.sortAndRetain();
        return this;
    }

    public void retain(int newCapacity) {
        this.capacity = newCapacity;
        if (this.size() > newCapacity) {
            int n = this.size() - newCapacity;
            for (int i = 0; i < n; ++i) {
                Counter<T> toRemoved = this.counterList.pollLast();
                this.counterMap.remove(toRemoved.item);
            }
        }
    }

    public double[] getCounters() {
        double[] counters = new double[this.size()];
        int index = 0;
        if (this.descending) {
            Iterator<Counter<T>> iterator = this.counterList.descendingIterator();
            while (iterator.hasNext()) {
                Counter<T> b = iterator.next();
                counters[index] = b.count;
                ++index;
            }
        } else {
            throw new IllegalStateException();
        }
        assert (index == this.size());
        return counters;
    }

    @Override
    public Iterator<Counter<T>> iterator() {
        if (this.descending) {
            return this.counterList.descendingIterator();
        }
        throw new IllegalStateException();
    }
}

