/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.measure.hllc.HyperLogLogPlusTable;

@Deprecated
public class HLLCounterOld
implements Serializable,
Comparable<HLLCounterOld> {
    private final int p;
    private final int m;
    private final HashFunction hashFunc;
    byte[] registers;
    int singleBucket;

    public HLLCounterOld() {
        this(10);
    }

    public HLLCounterOld(int p) {
        this(p, Hashing.murmur3_128());
    }

    public HLLCounterOld(HLLCounterOld another) {
        this(another.p, another.hashFunc);
        this.merge(another);
    }

    private HLLCounterOld(int p, HashFunction hashFunc) {
        this.p = p;
        this.m = 1 << p;
        this.hashFunc = hashFunc;
        this.registers = new byte[this.m];
        this.singleBucket = -1;
    }

    public void clear() {
        byte zero = 0;
        if (this.singleBucket != -1) {
            if (this.singleBucket >= 0) {
                this.registers[this.singleBucket] = 0;
            } else {
                Arrays.fill(this.registers, zero);
            }
        }
        this.singleBucket = -1;
    }

    public void add(int value) {
        this.add(this.hashFunc.hashInt(value).asLong());
    }

    public void add(String value) {
        this.add(this.hashFunc.hashString((CharSequence)value, Charset.defaultCharset()).asLong());
    }

    public void add(byte[] value) {
        this.add(this.hashFunc.hashBytes(value).asLong());
    }

    public void add(byte[] value, int offset, int length) {
        this.add(this.hashFunc.hashBytes(value, offset, length).asLong());
    }

    protected void add(long hash) {
        int bucketMask = this.m - 1;
        int bucket = (int)(hash & (long)bucketMask);
        int firstOnePos = Long.numberOfLeadingZeros(hash | (long)bucketMask) + 1;
        if (firstOnePos > this.registers[bucket]) {
            this.registers[bucket] = (byte)firstOnePos;
        }
        this.singleBucket = this.singleBucket == -1 ? bucket : Integer.MIN_VALUE;
    }

    public void merge(HLLCounterOld another) {
        assert (this.p == another.p);
        assert (this.hashFunc == another.hashFunc);
        if (another.singleBucket == -1) {
            return;
        }
        if (another.singleBucket >= 0) {
            int b = another.singleBucket;
            if (this.registers[b] < another.registers[b]) {
                this.registers[b] = another.registers[b];
            }
        } else {
            for (int i = 0; i < this.m; ++i) {
                if (this.registers[i] >= another.registers[i]) continue;
                this.registers[i] = another.registers[i];
            }
        }
        this.singleBucket = Integer.MIN_VALUE;
    }

    public long getCountEstimate() {
        return new HLLCSnapshot(this).getCountEstimate();
    }

    public int getPrecision() {
        return this.p;
    }

    public double getErrorRate() {
        return 1.04 / Math.sqrt(this.m);
    }

    private int size() {
        if (this.singleBucket == -1) {
            return 0;
        }
        if (this.singleBucket >= 0) {
            return 1;
        }
        int size = 0;
        for (int i = 0; i < this.m; ++i) {
            if (this.registers[i] <= 0) continue;
            ++size;
        }
        return size;
    }

    public String toString() {
        return "" + this.getCountEstimate();
    }

    public void writeRegisters(ByteBuffer out) throws IOException {
        int size;
        int indexLen = this.getRegisterIndexSize();
        byte scheme = 5 + (indexLen + 1) * (size = this.size()) < this.m ? (byte)0 : 1;
        out.put(scheme);
        if (scheme == 0) {
            BytesUtil.writeVInt(size, out);
            if (this.singleBucket != -1) {
                if (this.singleBucket >= 0) {
                    HLLCounterOld.writeUnsigned(this.singleBucket, indexLen, out);
                    out.put(this.registers[this.singleBucket]);
                } else {
                    for (int i = 0; i < this.m; ++i) {
                        if (this.registers[i] <= 0) continue;
                        HLLCounterOld.writeUnsigned(i, indexLen, out);
                        out.put(this.registers[i]);
                    }
                }
            }
        } else if (scheme == 1) {
            out.put(this.registers);
        } else {
            throw new IllegalStateException();
        }
    }

    public void readRegisters(ByteBuffer in) throws IOException {
        byte scheme = in.get();
        if (scheme == 0) {
            this.clear();
            int size = BytesUtil.readVInt(in);
            if (size > this.m) {
                throw new IllegalArgumentException("register size (" + size + ") cannot be larger than m (" + this.m + ")");
            }
            int indexLen = this.getRegisterIndexSize();
            int key = 0;
            for (int i = 0; i < size; ++i) {
                key = HLLCounterOld.readUnsigned(in, indexLen);
                this.registers[key] = in.get();
            }
            this.singleBucket = size == 0 ? -1 : (size == 1 ? key : Integer.MIN_VALUE);
        } else if (scheme == 1) {
            in.get(this.registers);
            this.singleBucket = Integer.MIN_VALUE;
        } else {
            throw new IllegalStateException();
        }
    }

    public int peekLength(ByteBuffer in) {
        int len;
        int mark = in.position();
        byte scheme = in.get();
        if (scheme == 0) {
            int size = BytesUtil.readVInt(in);
            int indexLen = this.getRegisterIndexSize();
            len = in.position() - mark + (indexLen + 1) * size;
        } else {
            len = in.position() - mark + this.m;
        }
        in.position(mark);
        return len;
    }

    public int maxLength() {
        return 1 + this.m;
    }

    private int getRegisterIndexSize() {
        return (this.p - 1) / 8 + 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hashFunc == null ? 0 : this.hashFunc.hashCode());
        result = 31 * result + this.p;
        result = 31 * result + Arrays.hashCode(this.registers);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HLLCounterOld other = (HLLCounterOld)obj;
        if (this.hashFunc == null ? other.hashFunc != null : !this.hashFunc.equals(other.hashFunc)) {
            return false;
        }
        if (this.p != other.p) {
            return false;
        }
        return Arrays.equals(this.registers, other.registers);
    }

    @Override
    public int compareTo(HLLCounterOld o) {
        long e2;
        if (o == null) {
            return 1;
        }
        long e1 = this.getCountEstimate();
        if (e1 == (e2 = o.getCountEstimate())) {
            return 0;
        }
        if (e1 > e2) {
            return 1;
        }
        return -1;
    }

    public static void main(String[] args) throws IOException {
        HLLCounterOld.dumpErrorRates();
    }

    static void dumpErrorRates() {
        for (int p = 10; p <= 18; ++p) {
            double rate = new HLLCounterOld(p).getErrorRate();
            double er = (double)Math.round(rate * 10000.0) / 100.0;
            double er2 = (double)Math.round(rate * 2.0 * 10000.0) / 100.0;
            double er3 = (double)Math.round(rate * 3.0 * 10000.0) / 100.0;
            long size = Math.round(Math.pow(2.0, p));
            System.out.println("HLLC" + p + ",\t" + size + " bytes,\t68% err<" + er + "%,\t95% err<" + er2 + "%,\t99.7% err<" + er3 + "%");
        }
    }

    public static void writeUnsigned(int num, int size, ByteBuffer out) {
        for (int i = 0; i < size; ++i) {
            out.put((byte)num);
            num >>>= 8;
        }
    }

    public static int readUnsigned(ByteBuffer in, int size) {
        int integer = 0;
        int mask = 255;
        int shift = 0;
        for (int i = 0; i < size; ++i) {
            integer |= in.get() << shift & mask;
            mask <<= 8;
            shift += 8;
        }
        return integer;
    }

    public static class HLLCSnapshot {
        byte p;
        double registerSum;
        int zeroBuckets;

        public HLLCSnapshot(HLLCounterOld hllc) {
            this.p = (byte)hllc.p;
            this.registerSum = 0.0;
            this.zeroBuckets = 0;
            byte[] registers = hllc.registers;
            for (int i = 0; i < hllc.m; ++i) {
                if (registers[i] == 0) {
                    this.registerSum += 1.0;
                    ++this.zeroBuckets;
                    continue;
                }
                this.registerSum += 1.0 / (double)(1L << registers[i]);
            }
        }

        public long getCountEstimate() {
            int m = 1 << this.p;
            double alpha = 0.7213 / (1.0 + 1.079 / (double)m);
            double estimate = alpha * (double)m * (double)m / this.registerSum;
            if ((double)this.zeroBuckets >= (double)m * 0.07) {
                estimate = (double)m * Math.log((double)m * 1.0 / (double)this.zeroBuckets);
            } else if (HyperLogLogPlusTable.isBiasCorrection(m, estimate)) {
                estimate = HyperLogLogPlusTable.biasCorrection(this.p, estimate);
            }
            return Math.round(estimate);
        }
    }
}

