/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable.benchmark;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.IGTScanner;

public class SortedGTRecordGenerator {
    private GTInfo info;
    private ArrayList<ColSpec> colSpecs = Lists.newArrayList();

    public SortedGTRecordGenerator(GTInfo info) {
        this.info = info;
    }

    public void addDimension(long cardinality, int length, Map<Integer, Integer> weights) {
        assert (cardinality > 0L);
        ColSpec spec = new ColSpec();
        spec.cardinality = cardinality;
        spec.length = length;
        spec.weights = weights;
        this.colSpecs.add(spec);
    }

    public void addMeasure(int length) {
        this.addMeasure(length, new BytesRandomizer(length));
    }

    public void addMeasure(int length, Randomizer randomizer) {
        assert (length > 0);
        ColSpec spec = new ColSpec();
        spec.length = length;
        spec.measureRandomizer = randomizer;
        this.colSpecs.add(spec);
    }

    public IGTScanner generate(long nRows) {
        this.validate();
        return new Generator(nRows);
    }

    private void validate() {
        if (this.info.getColumnCount() != this.colSpecs.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.colSpecs.size(); ++i) {
            ColSpec spec = this.colSpecs.get(i);
            if (this.info.getCodeSystem().maxCodeLength(i) >= spec.length) continue;
            throw new IllegalArgumentException();
        }
    }

    private class Distribution {
        ColSpec spec;
        long nRows;
        long leftRows;
        long leftRowsForCurValue;
        int curValue;

        public Distribution(ColSpec spec, long nRows) {
            assert (spec.cardinality > 0L);
            this.spec = spec;
            this.nRows = nRows;
            this.leftRows = nRows;
            this.leftRowsForCurValue = 0L;
            this.curValue = -1;
            if (spec.weightSum == 0L) {
                spec.weightSum = spec.cardinality;
                if (spec.weights != null) {
                    for (Map.Entry<Integer, Integer> entry : spec.weights.entrySet()) {
                        spec.weightSum += (long)(entry.getValue() - 1);
                    }
                }
            }
        }

        private long weight(int v) {
            if (this.spec.weights != null && this.spec.weights.containsKey(v)) {
                return this.spec.weights.get(v).intValue();
            }
            return 1L;
        }

        public long next() {
            if (this.leftRows == 0L) {
                return -1L;
            }
            if (this.leftRowsForCurValue == 0L && (long)this.curValue < this.spec.cardinality - 1L) {
                ++this.curValue;
                this.leftRowsForCurValue = (long)this.curValue == this.spec.cardinality - 1L ? this.leftRows : (long)((double)this.nRows * (double)this.weight(this.curValue) / (double)this.spec.weightSum);
            }
            this.leftRowsForCurValue = Math.max(this.leftRowsForCurValue - 1L, 0L);
            --this.leftRows;
            return this.curValue;
        }
    }

    private class Generator
    implements IGTScanner {
        final long nRows;
        final Random rand;
        int counter;
        Distribution[] dist;
        GTRecord rec;

        public Generator(long nRows) {
            this.nRows = nRows;
            this.rand = new Random();
            this.rec = new GTRecord(SortedGTRecordGenerator.this.info);
            this.dist = new Distribution[SortedGTRecordGenerator.this.colSpecs.size()];
            for (int i = 0; i < SortedGTRecordGenerator.this.colSpecs.size(); ++i) {
                ColSpec spec = (ColSpec)SortedGTRecordGenerator.this.colSpecs.get(i);
                this.rec.set(i, new ByteArray(spec.length));
                this.dist[i] = new Distribution(spec, 0L);
            }
        }

        @Override
        public Iterator<GTRecord> iterator() {
            return new Iterator<GTRecord>(){

                @Override
                public boolean hasNext() {
                    return (long)Generator.this.counter < Generator.this.nRows;
                }

                @Override
                public GTRecord next() {
                    for (int i = 0; i < SortedGTRecordGenerator.this.colSpecs.size(); ++i) {
                        ColSpec spec = (ColSpec)SortedGTRecordGenerator.this.colSpecs.get(i);
                        if (spec.cardinality > 0L) {
                            long v = Generator.this.dist[i].next();
                            if (v < 0L) {
                                Generator.this.dist[i] = new Distribution(spec, this.parentLevelCount(i));
                                v = Generator.this.dist[i].next();
                            }
                            ByteArray bytes = Generator.this.rec.get(i);
                            assert (bytes.length() == spec.length);
                            BytesUtil.writeLong(v, bytes.array(), bytes.offset(), bytes.length());
                            continue;
                        }
                        int len = spec.measureRandomizer.fillRandom(Generator.this.rand, Generator.this.rec.get(i).array(), 0);
                        Generator.this.rec.get(i).setLength(len);
                    }
                    ++Generator.this.counter;
                    return Generator.this.rec;
                }

                private long parentLevelCount(int i) {
                    if (i == 0) {
                        return Generator.this.nRows;
                    }
                    return Generator.this.dist[i - 1].leftRowsForCurValue + 1L;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public GTInfo getInfo() {
            return SortedGTRecordGenerator.this.info;
        }
    }

    public static class BytesRandomizer
    implements Randomizer {
        private final byte[] bytes;

        public BytesRandomizer(int len) {
            this.bytes = new byte[len];
        }

        @Override
        public int fillRandom(Random rand, byte[] array, int offset) {
            rand.nextBytes(this.bytes);
            System.arraycopy(this.bytes, 0, array, offset, this.bytes.length);
            return this.bytes.length;
        }
    }

    public static interface Randomizer {
        public int fillRandom(Random var1, byte[] var2, int var3);
    }

    private class ColSpec {
        int length;
        long cardinality;
        Map<Integer, Integer> weights;
        long weightSum;
        Randomizer measureRandomizer;

        private ColSpec() {
        }
    }
}

