/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.global;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dict.AppendTrieDictionary;

public class AppendDictNode {
    public byte[] part;
    public int id = -1;
    public boolean isEndOfValue;
    public ArrayList<AppendDictNode> children = new ArrayList();
    public int nValuesBeneath;
    public AppendDictNode parent;
    public int childrenCount = 1;

    AppendDictNode(byte[] value, boolean isEndOfValue) {
        this.reset(value, isEndOfValue);
    }

    AppendDictNode(byte[] value, boolean isEndOfValue, ArrayList<AppendDictNode> children) {
        this.reset(value, isEndOfValue, children);
    }

    void reset(byte[] value, boolean isEndOfValue) {
        this.reset(value, isEndOfValue, new ArrayList<AppendDictNode>());
    }

    void reset(byte[] value, boolean isEndOfValue, ArrayList<AppendDictNode> children) {
        this.part = value;
        this.isEndOfValue = isEndOfValue;
        this.clearChild();
        for (AppendDictNode child : children) {
            this.addChild(child);
        }
        this.id = -1;
    }

    void clearChild() {
        this.children.clear();
        int childrenCountDelta = this.childrenCount - 1;
        AppendDictNode p = this;
        while (p != null) {
            p.childrenCount -= childrenCountDelta;
            p = p.parent;
        }
    }

    void addChild(AppendDictNode child) {
        this.addChild(-1, child);
    }

    void addChild(int index, AppendDictNode child) {
        child.parent = this;
        if (index < 0) {
            this.children.add(child);
        } else {
            this.children.add(index, child);
        }
        AppendDictNode p = this;
        while (p != null) {
            p.childrenCount += child.childrenCount;
            p = p.parent;
        }
    }

    private AppendDictNode removeChild(int index) {
        AppendDictNode child = this.children.remove(index);
        child.parent = null;
        AppendDictNode p = this;
        while (p != null) {
            p.childrenCount -= child.childrenCount;
            p = p.parent;
        }
        return child;
    }

    private AppendDictNode duplicateNode() {
        AppendDictNode newChild = new AppendDictNode(this.part, false);
        newChild.parent = this.parent;
        if (this.parent != null) {
            int index = this.parent.children.indexOf(this);
            this.parent.addChild(index + 1, newChild);
        }
        return newChild;
    }

    public byte[] firstValue() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        AppendDictNode p = this;
        while (true) {
            bytes.write(p.part, 0, p.part.length);
            if (p.isEndOfValue || p.children.size() == 0) break;
            p = p.children.get(0);
        }
        return bytes.toByteArray();
    }

    public static AppendDictNode splitNodeTree(AppendDictNode splitNode) {
        if (splitNode == null) {
            return null;
        }
        AppendDictNode current = splitNode;
        AppendDictNode p = current.parent;
        while (p != null) {
            int index = p.children.indexOf(current);
            assert (index != -1);
            AppendDictNode newParent = p.duplicateNode();
            for (int i = p.children.size() - 1; i >= index; --i) {
                AppendDictNode child = p.removeChild(i);
                newParent.addChild(0, child);
            }
            current = newParent;
            p = p.parent;
        }
        return current;
    }

    public byte[] buildTrieBytes() {
        byte[] head;
        Stats stats = Stats.stats(this);
        int sizeChildOffset = stats.mbpn_sizeChildOffset;
        int sizeId = stats.mbpn_sizeId;
        try {
            ByteArrayOutputStream byteBuf = new ByteArrayOutputStream();
            DataOutputStream headOut = new DataOutputStream(byteBuf);
            headOut.write(AppendTrieDictionary.HEAD_MAGIC);
            headOut.writeShort(0);
            headOut.writeInt(stats.mbpn_footprint);
            headOut.writeInt(stats.nValues);
            headOut.write(sizeChildOffset);
            headOut.write(sizeId);
            headOut.close();
            head = byteBuf.toByteArray();
            BytesUtil.writeUnsigned(head.length, head, AppendTrieDictionary.HEAD_SIZE_I, 2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] trieBytes = new byte[stats.mbpn_footprint + head.length];
        System.arraycopy(head, 0, trieBytes, 0, head.length);
        LinkedList<AppendDictNode> open = new LinkedList<AppendDictNode>();
        IdentityHashMap<AppendDictNode, Integer> offsetMap = new IdentityHashMap<AppendDictNode, Integer>();
        int o = head.length;
        offsetMap.put(this, o);
        o = this.build_writeNode(this, o, true, sizeChildOffset, sizeId, trieBytes);
        if (!this.children.isEmpty()) {
            open.addLast(this);
        }
        while (!open.isEmpty()) {
            AppendDictNode parent = (AppendDictNode)open.removeFirst();
            this.build_overwriteChildOffset((Integer)offsetMap.get(parent), o - head.length, sizeChildOffset, trieBytes);
            for (int i = 0; i < parent.children.size(); ++i) {
                AppendDictNode c = parent.children.get(i);
                boolean isLastChild = i == parent.children.size() - 1;
                offsetMap.put(c, o);
                o = this.build_writeNode(c, o, isLastChild, sizeChildOffset, sizeId, trieBytes);
                if (c.children.isEmpty()) continue;
                open.addLast(c);
            }
        }
        if (o != trieBytes.length) {
            throw new RuntimeException();
        }
        return trieBytes;
    }

    private void build_overwriteChildOffset(int parentOffset, int childOffset, int sizeChildOffset, byte[] trieBytes) {
        int flags = trieBytes[parentOffset] & 0xC0;
        BytesUtil.writeUnsigned(childOffset, trieBytes, parentOffset, sizeChildOffset);
        int n = parentOffset;
        trieBytes[n] = (byte)(trieBytes[n] | flags);
    }

    private int build_writeNode(AppendDictNode n, int offset, boolean isLastChild, int sizeChildOffset, int sizeId, byte[] trieBytes) {
        int o = offset;
        if (isLastChild) {
            int n2 = o;
            trieBytes[n2] = (byte)(trieBytes[n2] | 0x80);
        }
        if (n.isEndOfValue) {
            int n3 = o;
            trieBytes[n3] = (byte)(trieBytes[n3] | 0x40);
        }
        o += sizeChildOffset;
        if (n.part.length > 255) {
            throw new RuntimeException("Value length is " + n.part.length + " and larger than 255: " + Bytes.toStringBinary(n.part));
        }
        BytesUtil.writeUnsigned(n.part.length, trieBytes, o, 1);
        System.arraycopy(n.part, 0, trieBytes, ++o, n.part.length);
        o += n.part.length;
        if (n.isEndOfValue) {
            this.checkValidId(n.id);
            BytesUtil.writeUnsigned(n.id, trieBytes, o, sizeId);
            o += sizeId;
        }
        return o;
    }

    private void checkValidId(int id) {
        if (id == 0 || id == -1) {
            throw new IllegalArgumentException("AppendTrieDictionary Id Overflow Unsigned Integer Size 4294967294");
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "DictNode[root=%s, nodes=%d, firstValue=%s]", Bytes.toStringBinary(this.part), this.childrenCount, Bytes.toStringBinary(this.firstValue()));
    }

    static class Stats {
        public int nValues;
        public int nValueBytesPlain;
        public int nValueBytesCompressed;
        public int maxValueLength;
        public int mbpn_nNodes;
        public int mbpn_trieDepth;
        public int mbpn_maxFanOut;
        public int mbpn_nChildLookups;
        public int mbpn_nTotalFanOut;
        public int mbpn_sizeValueTotal;
        public int mbpn_sizeNoValueBytes;
        public int mbpn_sizeChildOffset;
        public int mbpn_sizeId;
        public int mbpn_footprint;

        Stats() {
        }

        private static void traverseR(AppendDictNode node, Visitor visitor, int level) {
            visitor.visit(node, level);
            for (AppendDictNode c : node.children) {
                Stats.traverseR(c, visitor, level + 1);
            }
        }

        private static void traversePostOrderR(AppendDictNode node, Visitor visitor, int level) {
            for (AppendDictNode c : node.children) {
                Stats.traversePostOrderR(c, visitor, level + 1);
            }
            visitor.visit(node, level);
        }

        public static Stats stats(AppendDictNode root) {
            int t;
            Stats.traversePostOrderR(root, new Visitor(){

                @Override
                public void visit(AppendDictNode n, int level) {
                    n.nValuesBeneath = n.isEndOfValue ? 1 : 0;
                    for (AppendDictNode c : n.children) {
                        n.nValuesBeneath += c.nValuesBeneath;
                    }
                }
            }, 0);
            final Stats s = new Stats();
            final ArrayList lenAtLvl = new ArrayList();
            Stats.traverseR(root, new Visitor(){

                @Override
                public void visit(AppendDictNode n, int level) {
                    if (n.isEndOfValue) {
                        ++s.nValues;
                    }
                    s.nValueBytesPlain += n.part.length * n.nValuesBeneath;
                    s.nValueBytesCompressed += n.part.length;
                    ++s.mbpn_nNodes;
                    if (s.mbpn_trieDepth < level + 1) {
                        s.mbpn_trieDepth = level + 1;
                    }
                    if (n.children.size() > 0) {
                        if (s.mbpn_maxFanOut < n.children.size()) {
                            s.mbpn_maxFanOut = n.children.size();
                        }
                        int childLookups = n.nValuesBeneath - (n.isEndOfValue ? 1 : 0);
                        s.mbpn_nChildLookups += childLookups;
                        s.mbpn_nTotalFanOut += childLookups * n.children.size();
                    }
                    if (level < lenAtLvl.size()) {
                        lenAtLvl.set(level, n.part.length);
                    } else {
                        lenAtLvl.add(n.part.length);
                    }
                    int lenSoFar = 0;
                    for (int i = 0; i <= level; ++i) {
                        lenSoFar += ((Integer)lenAtLvl.get(i)).intValue();
                    }
                    if (lenSoFar > s.maxValueLength) {
                        s.maxValueLength = lenSoFar;
                    }
                }
            }, 0);
            s.mbpn_sizeId = 4;
            s.mbpn_sizeValueTotal = s.nValueBytesCompressed + s.nValues * s.mbpn_sizeId;
            s.mbpn_sizeNoValueBytes = 1;
            s.mbpn_sizeChildOffset = 5;
            s.mbpn_footprint = s.mbpn_sizeValueTotal + s.mbpn_nNodes * (s.mbpn_sizeNoValueBytes + s.mbpn_sizeChildOffset);
            while (BytesUtil.sizeForValue((long)(t = s.mbpn_sizeValueTotal + s.mbpn_nNodes * (s.mbpn_sizeNoValueBytes + s.mbpn_sizeChildOffset - 1)) * 4L) <= s.mbpn_sizeChildOffset - 1) {
                --s.mbpn_sizeChildOffset;
                s.mbpn_footprint = t;
            }
            return s;
        }

        public void print(AppendDictNode root) {
            this.print(root, System.out);
        }

        public void print(AppendDictNode root, final PrintStream out) {
            Stats.traverseR(root, new Visitor(){

                @Override
                public void visit(AppendDictNode n, int level) {
                    try {
                        for (int i = 0; i < level; ++i) {
                            out.print("  ");
                        }
                        out.print(new String(n.part, "UTF-8"));
                        out.print(" - ");
                        if (n.nValuesBeneath > 0) {
                            out.print(n.nValuesBeneath);
                        }
                        if (n.isEndOfValue) {
                            out.print("* [" + n.id + "]");
                        }
                        out.print("\n");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }, 0);
        }

        public static interface Visitor {
            public void visit(AppendDictNode var1, int var2);
        }
    }
}

