/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.ShrunkenDictionary;

public class ShrunkenDictionaryBuilder<T> {
    private Map<T, Integer> valueToIdMap;
    private Dictionary<T> fullDict;

    public ShrunkenDictionaryBuilder(Dictionary<T> fullDict) {
        this.fullDict = fullDict;
        this.valueToIdMap = Maps.newHashMap();
    }

    public void addValue(T value) {
        int id = this.fullDict.getIdFromValue(value);
        this.valueToIdMap.put(value, id);
    }

    public ShrunkenDictionary<T> build(ShrunkenDictionary.ValueSerializer<T> valueSerializer) {
        return new ShrunkenDictionary<T>(valueSerializer, this.fullDict.getMinId(), this.fullDict.getMaxId(), this.fullDict.getSizeOfId(), this.fullDict.getSizeOfValue(), this.valueToIdMap);
    }
}

