/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.cube.inmemcubing.InputConverterUnit;
import org.apache.kylin.cube.inmemcubing.InputConverterUnitForRawData;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTScanRequestBuilder;
import org.apache.kylin.gridtable.GridTable;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInMemCubeBuilder {
    private static Logger logger = LoggerFactory.getLogger(AbstractInMemCubeBuilder.class);
    protected final CuboidScheduler cuboidScheduler;
    protected final IJoinedFlatTableDesc flatDesc;
    protected final CubeDesc cubeDesc;
    protected final Map<TblColRef, Dictionary<String>> dictionaryMap;
    protected int taskThreadCount = 1;
    protected int reserveMemoryMB = 100;

    protected AbstractInMemCubeBuilder(CuboidScheduler cuboidScheduler, IJoinedFlatTableDesc flatDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        if (cuboidScheduler == null) {
            throw new NullPointerException();
        }
        if (flatDesc == null) {
            throw new NullPointerException();
        }
        if (dictionaryMap == null) {
            throw new IllegalArgumentException("dictionary cannot be null");
        }
        this.cuboidScheduler = cuboidScheduler;
        this.flatDesc = flatDesc;
        this.cubeDesc = cuboidScheduler.getCubeDesc();
        this.dictionaryMap = dictionaryMap;
    }

    public void setConcurrentThreads(int n) {
        this.taskThreadCount = n;
    }

    public void setReserveMemoryMB(int mb) {
        this.reserveMemoryMB = mb;
    }

    public int getReserveMemoryMB() {
        return this.reserveMemoryMB;
    }

    public Runnable buildAsRunnable(BlockingQueue<String[]> input, ICuboidWriter output) {
        return this.buildAsRunnable(input, new InputConverterUnitForRawData(this.cubeDesc, this.flatDesc, this.dictionaryMap), output);
    }

    public <T> Runnable buildAsRunnable(final BlockingQueue<T> input, final InputConverterUnit<T> inputConverterUnit, final ICuboidWriter output) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractInMemCubeBuilder.this.build(input, inputConverterUnit, output);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public abstract <T> void build(BlockingQueue<T> var1, InputConverterUnit<T> var2, ICuboidWriter var3) throws IOException;

    protected void outputCuboid(long cuboidId, GridTable gridTable, ICuboidWriter output) throws IOException {
        long startTime = System.currentTimeMillis();
        GTScanRequest req = new GTScanRequestBuilder().setInfo(gridTable.getInfo()).setRanges(null).setDimensions(null).setFilterPushDown(null).createGTScanRequest();
        IGTScanner scanner = gridTable.scan(req);
        for (GTRecord record : scanner) {
            output.write(cuboidId, record);
        }
        scanner.close();
        logger.debug("Cuboid " + cuboidId + " output takes " + (System.currentTimeMillis() - startTime) + "ms");
    }
}

