/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.storage.hbase.cube.v2.SegmentQueryResult;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentQueryResultTest {
    private static final Logger logger = LoggerFactory.getLogger(SegmentQueryResultTest.class);

    @Test
    public void buildTest() {
        int maxCacheResultSize = 10240;
        ExecutorService rpcExecutor = Executors.newFixedThreadPool(4);
        SegmentQueryResult.Builder builder = new SegmentQueryResult.Builder(8, maxCacheResultSize);
        this.mockSendRPCTasks(rpcExecutor, 4, builder, 1024);
        TestCase.assertFalse((boolean)builder.isComplete());
        this.mockSendRPCTasks(rpcExecutor, 4, builder, 1024);
        Assert.assertTrue((boolean)builder.isComplete());
        builder = new SegmentQueryResult.Builder(8, maxCacheResultSize);
        this.mockSendRPCTasks(rpcExecutor, 8, builder, 1500);
        TestCase.assertFalse((boolean)builder.isComplete());
    }

    @Test
    public void resultValidateTest() {
        long segmentBuildTime = System.currentTimeMillis() - 1000L;
        int maxCacheResultSize = 10240;
        ExecutorService rpcExecutor = Executors.newFixedThreadPool(4);
        SegmentQueryResult.Builder builder = new SegmentQueryResult.Builder(8, maxCacheResultSize);
        this.mockSendRPCTasks(rpcExecutor, 8, builder, 1024);
        QueryContext.CubeSegmentStatistics statistics = new QueryContext.CubeSegmentStatistics();
        statistics.setWrapper("cube1", "20171001000000-20171010000000", 3L, 7L, 1L);
        builder.setCubeSegmentStatistics(statistics);
        SegmentQueryResult segmentQueryResult = builder.build();
        QueryContext.CubeSegmentStatistics desStatistics = (QueryContext.CubeSegmentStatistics)SerializationUtils.deserialize((byte[])segmentQueryResult.getCubeSegmentStatisticsBytes());
        Assert.assertEquals((String)"cube1", (String)desStatistics.getCubeName());
    }

    private void mockSendRPCTasks(ExecutorService rpcExecutor, int rpcNum, SegmentQueryResult.Builder builder, int resultSize) {
        ArrayList futures = Lists.newArrayList();
        for (int i = 0; i < rpcNum; ++i) {
            Future future = rpcExecutor.submit(new MockRPCTask(resultSize, 10L, builder));
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                logger.error("exception", (Throwable)e);
            }
        }
    }

    private static class MockRPCTask
    implements Runnable {
        private int resultSize;
        private long takeTime;
        private SegmentQueryResult.Builder builder;

        MockRPCTask(int resultSize, long takeTime, SegmentQueryResult.Builder builder) {
            this.resultSize = resultSize;
            this.takeTime = takeTime;
            this.builder = builder;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.takeTime);
            }
            catch (InterruptedException e) {
                logger.error("interrupt", (Throwable)e);
            }
            this.builder.putRegionResult(new byte[this.resultSize]);
        }
    }
}

