/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter.function;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.metadata.filter.function.Like;

public class LikeMatchers {
    private static final String PERCENT_SIGN = "%";
    private static final String UNDERSCORE_SIGN = "_";

    public static LikeMatcher createMatcher(String patternStr) {
        if (patternStr == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        if (patternStr.contains(UNDERSCORE_SIGN)) {
            return new DefaultLikeMatcher(patternStr);
        }
        int count = StringUtils.countMatches((String)patternStr, (String)PERCENT_SIGN);
        if (count == 1) {
            return new OnePercentSignLikeMatcher(patternStr);
        }
        if (count == 2 && patternStr.startsWith(PERCENT_SIGN) && patternStr.endsWith(PERCENT_SIGN)) {
            return new TwoPercentSignLikeMatcher(patternStr);
        }
        if (count == 3 && patternStr.startsWith(PERCENT_SIGN) && patternStr.endsWith(PERCENT_SIGN) && !patternStr.contains("%%")) {
            return new ThreePercentSignLikeMatcher(patternStr);
        }
        return new DefaultLikeMatcher(patternStr);
    }

    public static class ThreePercentSignLikeMatcher
    implements LikeMatcher {
        private String[] remaining;

        private ThreePercentSignLikeMatcher(String patternStr) {
            this.remaining = StringUtils.split((String)patternStr, (String)LikeMatchers.PERCENT_SIGN);
            Preconditions.checkState((this.remaining.length == 2 ? 1 : 0) != 0);
        }

        @Override
        public boolean matches(String input) {
            int i = input.indexOf(this.remaining[0]);
            int j = input.lastIndexOf(this.remaining[1]);
            return i != -1 && j != -1 && i <= j - this.remaining[0].length();
        }
    }

    public static class TwoPercentSignLikeMatcher
    implements LikeMatcher {
        private String[] remaining;

        private TwoPercentSignLikeMatcher(String patternStr) {
            this.remaining = StringUtils.split((String)patternStr, (String)LikeMatchers.PERCENT_SIGN);
            Preconditions.checkState((this.remaining.length == 1 ? 1 : 0) != 0);
        }

        @Override
        public boolean matches(String input) {
            return input.contains(this.remaining[0]);
        }
    }

    public static class OnePercentSignLikeMatcher
    implements LikeMatcher {
        private SignPosition signPosition;
        private String[] remaining;

        private OnePercentSignLikeMatcher(String patternStr) {
            this.signPosition = patternStr.startsWith(LikeMatchers.PERCENT_SIGN) ? SignPosition.LEFT : (patternStr.endsWith(LikeMatchers.PERCENT_SIGN) ? SignPosition.RIGHT : SignPosition.MIDDLE);
            this.remaining = StringUtils.split((String)patternStr, (String)LikeMatchers.PERCENT_SIGN);
        }

        @Override
        public boolean matches(String input) {
            if (input == null) {
                return false;
            }
            switch (this.signPosition) {
                case LEFT: {
                    return input.endsWith(this.remaining[0]);
                }
                case RIGHT: {
                    return input.startsWith(this.remaining[0]);
                }
                case MIDDLE: {
                    return input.startsWith(this.remaining[0]) && input.endsWith(this.remaining[1]);
                }
            }
            throw new IllegalStateException();
        }

        static enum SignPosition {
            LEFT,
            MIDDLE,
            RIGHT;

        }
    }

    public static class DefaultLikeMatcher
    implements LikeMatcher {
        private Pattern p;

        private DefaultLikeMatcher(String patternStr) {
            patternStr = patternStr.toLowerCase(Locale.ROOT);
            String regex = Like.sqlToRegexLike(patternStr, null);
            this.p = Pattern.compile(regex);
        }

        @Override
        public boolean matches(String input) {
            return this.p.matcher(input).matches();
        }
    }

    public static interface LikeMatcher {
        public boolean matches(String var1);
    }
}

