/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.DynamicTupleFilter;
import org.apache.kylin.metadata.filter.FilterOptimizeTransformer;
import org.apache.kylin.metadata.filter.FunctionTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.IOptimizeableTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class CompareTupleFilter
extends TupleFilter
implements IOptimizeableTupleFilter {
    private TblColRef column;
    private FunctionTupleFilter function;
    private TblColRef secondColumn;
    private Set<Object> conditionValues;
    private Object firstCondValue;
    private Map<String, Object> dynamicVariables;

    public CompareTupleFilter(TupleFilter.FilterOperatorEnum op) {
        super(new ArrayList<TupleFilter>(2), op);
        boolean opGood;
        this.conditionValues = new HashSet<Object>();
        this.dynamicVariables = new HashMap<String, Object>();
        boolean bl = opGood = op == TupleFilter.FilterOperatorEnum.EQ || op == TupleFilter.FilterOperatorEnum.NEQ || op == TupleFilter.FilterOperatorEnum.LT || op == TupleFilter.FilterOperatorEnum.LTE || op == TupleFilter.FilterOperatorEnum.GT || op == TupleFilter.FilterOperatorEnum.GTE || op == TupleFilter.FilterOperatorEnum.IN || op == TupleFilter.FilterOperatorEnum.NOTIN || op == TupleFilter.FilterOperatorEnum.ISNULL || op == TupleFilter.FilterOperatorEnum.ISNOTNULL;
        if (!opGood) {
            throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)op));
        }
    }

    private CompareTupleFilter(CompareTupleFilter another) {
        super(new ArrayList<TupleFilter>(another.children), another.operator);
        this.column = another.column;
        this.firstCondValue = another.getFirstValue();
        this.function = another.getFunction();
        this.conditionValues = new HashSet<Object>();
        this.conditionValues.addAll(another.conditionValues);
        this.dynamicVariables = new HashMap<String, Object>();
        this.dynamicVariables.putAll(another.dynamicVariables);
    }

    @Override
    public void addChild(TupleFilter child) {
        super.addChild(child);
        if (child instanceof ColumnTupleFilter) {
            ColumnTupleFilter columnFilter = (ColumnTupleFilter)child;
            if (this.column != null) {
                this.secondColumn = columnFilter.getColumn();
            } else {
                this.column = columnFilter.getColumn();
                if (this.children.size() > 1 && this.needSwapOperator()) {
                    this.operator = (TupleFilter.FilterOperatorEnum)((Object)SWAP_OP_MAP.get((Object)this.operator));
                    TupleFilter last = (TupleFilter)this.children.remove(this.children.size() - 1);
                    this.children.add(0, last);
                }
            }
        } else if (child instanceof ConstantTupleFilter) {
            this.conditionValues.addAll(child.getValues());
            if (!this.conditionValues.isEmpty()) {
                this.firstCondValue = this.conditionValues.iterator().next();
            }
        } else if (child instanceof DynamicTupleFilter) {
            DynamicTupleFilter dynamicFilter = (DynamicTupleFilter)child;
            if (!this.dynamicVariables.containsKey(dynamicFilter.getVariableName())) {
                this.dynamicVariables.put(dynamicFilter.getVariableName(), null);
            }
        } else if (child instanceof FunctionTupleFilter) {
            this.function = (FunctionTupleFilter)child;
        }
    }

    private boolean needSwapOperator() {
        return this.operator == TupleFilter.FilterOperatorEnum.LT || this.operator == TupleFilter.FilterOperatorEnum.GT || this.operator == TupleFilter.FilterOperatorEnum.LTE || this.operator == TupleFilter.FilterOperatorEnum.GTE;
    }

    public Set<?> getValues() {
        return this.conditionValues;
    }

    public Object getFirstValue() {
        return this.firstCondValue;
    }

    public TblColRef getColumn() {
        return this.column;
    }

    public FunctionTupleFilter getFunction() {
        return this.function;
    }

    public Map<String, Object> getVariables() {
        return this.dynamicVariables;
    }

    public void bindVariable(String variable, Object value) {
        this.dynamicVariables.put(variable, value);
        this.conditionValues.add(value);
        this.firstCondValue = this.conditionValues.iterator().next();
    }

    public void clearPreviousVariableValues(String variable) {
        Object previousValue = this.dynamicVariables.get(variable);
        if (previousValue == null) {
            return;
        }
        if (this.firstCondValue == previousValue) {
            this.firstCondValue = null;
        }
        this.conditionValues.remove(previousValue);
    }

    @Override
    public TupleFilter copy() {
        return new CompareTupleFilter(this);
    }

    @Override
    public TupleFilter reverse() {
        TupleFilter reverse = this.copy();
        reverse.operator = (TupleFilter.FilterOperatorEnum)((Object)REVERSE_OP_MAP.get((Object)this.operator));
        return reverse;
    }

    public String toString() {
        return (this.function == null ? this.column : this.function) + " " + (Object)((Object)this.operator) + " " + this.conditionValues;
    }

    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem cs) {
        boolean result;
        Object tupleValue = null;
        for (TupleFilter filter : this.children) {
            if (this.isConstant(filter)) continue;
            filter.evaluate(tuple, cs);
            tupleValue = filter.getValues().iterator().next();
        }
        if (cs.isNull(tupleValue)) {
            return this.operator == TupleFilter.FilterOperatorEnum.ISNULL;
        }
        if (this.operator == TupleFilter.FilterOperatorEnum.ISNOTNULL) {
            return true;
        }
        if (this.operator == TupleFilter.FilterOperatorEnum.ISNULL) {
            return false;
        }
        if (cs.isNull(this.firstCondValue)) {
            return false;
        }
        int comp = cs.compare(tupleValue, this.firstCondValue);
        switch (this.operator) {
            case EQ: {
                result = comp == 0;
                break;
            }
            case NEQ: {
                result = comp != 0;
                break;
            }
            case LT: {
                result = comp < 0;
                break;
            }
            case LTE: {
                result = comp <= 0;
                break;
            }
            case GT: {
                result = comp > 0;
                break;
            }
            case GTE: {
                result = comp >= 0;
                break;
            }
            case IN: {
                result = this.conditionValues.contains(tupleValue);
                break;
            }
            case NOTIN: {
                result = !this.conditionValues.contains(tupleValue);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private boolean isConstant(TupleFilter filter) {
        return filter instanceof ConstantTupleFilter || filter instanceof DynamicTupleFilter;
    }

    @Override
    public boolean isEvaluable() {
        return (this.column != null || this.function != null && this.function.isEvaluable()) && (!this.conditionValues.isEmpty() || this.operator == TupleFilter.FilterOperatorEnum.ISNOTNULL || this.operator == TupleFilter.FilterOperatorEnum.ISNULL) && this.secondColumn == null;
    }

    public CompareResultType getCompareResultType() {
        if ((this.operator == TupleFilter.FilterOperatorEnum.EQ || this.operator == TupleFilter.FilterOperatorEnum.NEQ) && this.children != null && this.children.size() == 2 && this.children.get(0) instanceof ConstantTupleFilter && this.children.get(1) instanceof ConstantTupleFilter) {
            if (((ConstantTupleFilter)this.children.get(0)).getValues().equals(((ConstantTupleFilter)this.children.get(1)).getValues())) {
                return this.operator == TupleFilter.FilterOperatorEnum.EQ ? CompareResultType.AlwaysTrue : CompareResultType.AlwaysFalse;
            }
            return this.operator == TupleFilter.FilterOperatorEnum.EQ ? CompareResultType.AlwaysFalse : CompareResultType.AlwaysTrue;
        }
        return CompareResultType.Unknown;
    }

    public void serialize(IFilterCodeSystem cs, ByteBuffer buffer) {
        int size = this.dynamicVariables.size();
        BytesUtil.writeVInt(size, buffer);
        for (Map.Entry<String, Object> entry : this.dynamicVariables.entrySet()) {
            BytesUtil.writeUTFString(entry.getKey(), buffer);
            cs.serialize(entry.getValue(), buffer);
        }
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        this.dynamicVariables.clear();
        int size = BytesUtil.readVInt(buffer);
        for (int i = 0; i < size; ++i) {
            String name = BytesUtil.readUTFString(buffer);
            Object value = cs.deserialize(buffer);
            this.bindVariable(name, value);
        }
    }

    @Override
    public TupleFilter acceptOptimizeTransformer(FilterOptimizeTransformer transformer) {
        return transformer.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompareTupleFilter that = (CompareTupleFilter)o;
        if (this.operator != that.operator) {
            return false;
        }
        if (this.column != null ? !this.column.equals(that.column) : that.column != null) {
            return false;
        }
        if (this.function != null ? !this.function.equals(that.function) : that.function != null) {
            return false;
        }
        if (this.secondColumn != null ? !this.secondColumn.equals(that.secondColumn) : that.secondColumn != null) {
            return false;
        }
        if (this.conditionValues != null ? !this.conditionValues.equals(that.conditionValues) : that.conditionValues != null) {
            return false;
        }
        if (this.firstCondValue != null ? !this.firstCondValue.equals(that.firstCondValue) : that.firstCondValue != null) {
            return false;
        }
        return this.dynamicVariables != null ? this.dynamicVariables.equals(that.dynamicVariables) : that.dynamicVariables == null;
    }

    public int hashCode() {
        int result = this.operator != null ? this.operator.hashCode() : 0;
        result = 31 * result + (this.column != null ? this.column.hashCode() : 0);
        result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
        result = 31 * result + (this.secondColumn != null ? this.secondColumn.hashCode() : 0);
        result = 31 * result + (this.conditionValues != null ? this.conditionValues.hashCode() : 0);
        result = 31 * result + (this.firstCondValue != null ? this.firstCondValue.hashCode() : 0);
        result = 31 * result + (this.dynamicVariables != null ? this.dynamicVariables.hashCode() : 0);
        return result;
    }

    public static enum CompareResultType {
        AlwaysTrue,
        AlwaysFalse,
        Unknown;

    }
}

