/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.metadata.filter.FilterOptimizeTransformer;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.IOptimizeableTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class CaseTupleFilter
extends TupleFilter
implements IOptimizeableTupleFilter {
    private List<TupleFilter> whenFilters;
    private List<TupleFilter> thenFilters;
    private TupleFilter elseFilter;
    private Collection<?> values;
    private int filterIndex;

    public CaseTupleFilter() {
        super(new ArrayList<TupleFilter>(), TupleFilter.FilterOperatorEnum.CASE);
        this.reinit();
    }

    private void reinit() {
        this.children.clear();
        this.filterIndex = 0;
        this.values = Collections.emptyList();
        this.whenFilters = new ArrayList<TupleFilter>();
        this.thenFilters = new ArrayList<TupleFilter>();
        this.elseFilter = null;
    }

    public List<TupleFilter> getWhenFilters() {
        return Collections.unmodifiableList(this.whenFilters);
    }

    public List<TupleFilter> getThenFilters() {
        return Collections.unmodifiableList(this.thenFilters);
    }

    public TupleFilter getElseFilter() {
        return this.elseFilter;
    }

    @Override
    public void addChild(TupleFilter child) {
        if (this.filterIndex % 2 == 0) {
            this.elseFilter = child;
        } else {
            this.whenFilters.add(this.elseFilter);
            this.thenFilters.add(child);
            this.elseFilter = null;
        }
        super.addChild(child);
        ++this.filterIndex;
    }

    public String toString() {
        return "CaseTupleFilter [when=" + this.whenFilters + ", then=" + this.thenFilters + ", else=" + this.elseFilter + ", children=" + this.children + "]";
    }

    @Override
    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        boolean matched = false;
        for (int i = 0; i < this.whenFilters.size(); ++i) {
            TupleFilter whenFilter = this.whenFilters.get(i);
            if (!whenFilter.evaluate(tuple, cs)) continue;
            TupleFilter thenFilter = this.thenFilters.get(i);
            thenFilter.evaluate(tuple, cs);
            this.values = thenFilter.getValues();
            matched = true;
            break;
        }
        if (!matched) {
            if (this.elseFilter != null) {
                this.elseFilter.evaluate(tuple, cs);
                this.values = this.elseFilter.getValues();
            } else {
                this.values = Collections.emptyList();
            }
        }
        return true;
    }

    @Override
    public boolean isEvaluable() {
        return false;
    }

    @Override
    public Collection<?> getValues() {
        return this.values;
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }

    @Override
    public TupleFilter acceptOptimizeTransformer(FilterOptimizeTransformer transformer) {
        ArrayList newChildren = Lists.newArrayList();
        for (TupleFilter tupleFilter : this.getChildren()) {
            if (tupleFilter instanceof IOptimizeableTupleFilter) {
                newChildren.add(((IOptimizeableTupleFilter)((Object)tupleFilter)).acceptOptimizeTransformer(transformer));
                continue;
            }
            newChildren.add(tupleFilter);
        }
        this.reinit();
        this.addChildren(newChildren);
        return transformer.visit(this);
    }
}

