/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cachesync;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cachesync.AbstractCache;
import org.apache.kylin.metadata.cachesync.Broadcaster;

public abstract class SingleValueCache<K, V>
extends AbstractCache<K, V> {
    private final ConcurrentMap<K, V> innerCache;

    public SingleValueCache(KylinConfig config, String syncEntity) {
        this(config, syncEntity, new ConcurrentHashMap());
    }

    public SingleValueCache(KylinConfig config, String syncEntity, ConcurrentMap<K, V> innerCache) {
        super(config, syncEntity);
        this.innerCache = innerCache;
    }

    @Override
    public void put(K key, V value) {
        boolean exists = this.innerCache.containsKey(key);
        this.innerCache.put(key, value);
        if (!exists) {
            this.getBroadcaster().announce(this.syncEntity, Broadcaster.Event.CREATE.getType(), key.toString());
        } else {
            this.getBroadcaster().announce(this.syncEntity, Broadcaster.Event.UPDATE.getType(), key.toString());
        }
    }

    @Override
    public void putLocal(K key, V value) {
        this.innerCache.put(key, value);
    }

    @Override
    public void remove(K key) {
        boolean exists = this.innerCache.containsKey(key);
        this.innerCache.remove(key);
        if (exists) {
            this.getBroadcaster().announce(this.syncEntity, Broadcaster.Event.DROP.getType(), key.toString());
        }
    }

    @Override
    public void removeLocal(K key) {
        this.innerCache.remove(key);
    }

    @Override
    public void clear() {
        this.innerCache.clear();
    }

    @Override
    public int size() {
        return this.innerCache.size();
    }

    public V get(K key) {
        return this.innerCache.get(key);
    }

    public Collection<V> values() {
        return this.innerCache.values();
    }

    public boolean containsKey(String key) {
        return this.innerCache.containsKey(key);
    }

    public Map<K, V> getMap() {
        return Collections.unmodifiableMap(this.innerCache);
    }

    public Set<K> keySet() {
        return this.innerCache.keySet();
    }
}

