/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.badquery;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.metadata.badquery.BadQueryEntry;
import org.apache.kylin.metadata.badquery.BadQueryHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BadQueryHistoryManager {
    public static final Serializer<BadQueryHistory> BAD_QUERY_INSTANCE_SERIALIZER = new JsonSerializer<BadQueryHistory>(BadQueryHistory.class);
    private static final Logger logger = LoggerFactory.getLogger(BadQueryHistoryManager.class);
    private KylinConfig kylinConfig;

    public static BadQueryHistoryManager getInstance(KylinConfig config) {
        return config.getManager(BadQueryHistoryManager.class);
    }

    static BadQueryHistoryManager newInstance(KylinConfig config) throws IOException {
        return new BadQueryHistoryManager(config);
    }

    private BadQueryHistoryManager(KylinConfig config) throws IOException {
        logger.info("Initializing BadQueryHistoryManager with config " + config);
        this.kylinConfig = config;
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.kylinConfig);
    }

    public BadQueryHistory getBadQueriesForProject(String project) throws IOException {
        BadQueryHistory badQueryHistory = this.getStore().getResource(this.getResourcePathForProject(project), BAD_QUERY_INSTANCE_SERIALIZER);
        if (badQueryHistory == null) {
            badQueryHistory = new BadQueryHistory(project);
        }
        logger.debug("Loaded " + badQueryHistory.getEntries().size() + " Bad Query(s)");
        return badQueryHistory;
    }

    public BadQueryHistory upsertEntryToProject(BadQueryEntry badQueryEntry, String project) throws IOException {
        if (StringUtils.isEmpty((CharSequence)project) || badQueryEntry.getAdj() == null || badQueryEntry.getSql() == null) {
            throw new IllegalArgumentException();
        }
        BadQueryHistory badQueryHistory = this.getBadQueriesForProject(project);
        NavigableSet<BadQueryEntry> entries = badQueryHistory.getEntries();
        entries.remove(badQueryEntry);
        entries.add(badQueryEntry);
        int maxSize = this.kylinConfig.getBadQueryHistoryNum();
        if (entries.size() > maxSize) {
            entries.pollFirst();
        }
        this.getStore().checkAndPutResource(badQueryHistory.getResourcePath(), badQueryHistory, BAD_QUERY_INSTANCE_SERIALIZER);
        return badQueryHistory;
    }

    public void removeBadQueryHistory(String project) throws IOException {
        this.getStore().deleteResource(this.getResourcePathForProject(project));
    }

    public String getResourcePathForProject(String project) {
        return "/bad_query/" + project + ".json";
    }
}

