/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTForwardingScanner;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTCodeSystem;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureAggregator;

public class GTStreamAggregateScanner
extends GTForwardingScanner {
    private final GTScanRequest req;
    private final Comparator<GTRecord> keyComparator;

    public GTStreamAggregateScanner(IGTScanner delegated, GTScanRequest scanRequest) {
        super(delegated);
        this.req = (GTScanRequest)Preconditions.checkNotNull((Object)scanRequest, (Object)"scanRequest");
        this.keyComparator = GTRecord.getComparator(scanRequest.getAggrGroupBy());
    }

    @Override
    public Iterator<GTRecord> iterator() {
        return new StreamMergeGTRecordIterator(this.delegated.iterator());
    }

    public Iterator<Object[]> valuesIterator(int[] gtDimsIdx, int[] gtMetricsIdx) {
        return new StreamMergeValuesIterator(this.delegated.iterator(), gtDimsIdx, gtMetricsIdx);
    }

    private class StreamMergeValuesIterator
    extends AbstractStreamMergeIterator<Object[]> {
        private int[] gtDimsIdx;
        private int[] gtMetricsIdx;
        private int[] aggIdx;
        private Object[] result;

        StreamMergeValuesIterator(Iterator<GTRecord> input, int[] gtDimsIdx, int[] gtMetricsIdx) {
            super(input);
            this.gtDimsIdx = gtDimsIdx;
            this.gtMetricsIdx = gtMetricsIdx;
            this.aggIdx = new int[gtMetricsIdx.length];
            for (int i = 0; i < this.aggIdx.length; ++i) {
                int metricIdx = gtMetricsIdx[i];
                this.aggIdx[i] = this.metrics.trueBitIndexOf(metricIdx);
            }
            this.result = new Object[gtDimsIdx.length + gtMetricsIdx.length];
        }

        private void decodeAndSetDimensions(GTRecord record) {
            for (int i = 0; i < this.gtDimsIdx.length; ++i) {
                this.result[i] = record.decodeValue(this.gtDimsIdx[i]);
            }
        }

        @Override
        protected Object[] finalizeResult(GTRecord record) {
            this.decodeAndSetDimensions(record);
            for (int i = 0; i < this.gtMetricsIdx.length; ++i) {
                this.result[this.gtDimsIdx.length + i] = record.decodeValue(this.gtMetricsIdx[i]);
            }
            return this.result;
        }

        @Override
        protected Object[] finalizeResult(GTRecord record, Object[] aggStates) {
            this.decodeAndSetDimensions(record);
            for (int i = 0; i < this.aggIdx.length; ++i) {
                this.result[this.gtDimsIdx.length + i] = aggStates[this.aggIdx[i]];
            }
            return this.result;
        }
    }

    private class StreamMergeGTRecordIterator
    extends AbstractStreamMergeIterator<GTRecord> {
        private GTRecord returnRecord;

        StreamMergeGTRecordIterator(Iterator<GTRecord> input) {
            super(input);
            this.returnRecord = new GTRecord(GTStreamAggregateScanner.this.req.getInfo());
        }

        @Override
        protected GTRecord finalizeResult(GTRecord record) {
            return record;
        }

        @Override
        protected GTRecord finalizeResult(GTRecord record, Object[] aggStates) {
            for (int c : this.dimensions) {
                this.returnRecord.cols[c] = record.cols[c];
            }
            byte[] bytes = this.measureCodec.encode(aggStates).array();
            int[] sizes = this.measureCodec.getMeasureSizes();
            int offset = 0;
            for (int i = 0; i < this.metrics.trueBitCount(); ++i) {
                int c = this.metrics.trueBitAt(i);
                this.returnRecord.cols[c].reset(bytes, offset, sizes[i]);
                offset += sizes[i];
            }
            return this.returnRecord;
        }
    }

    private abstract class AbstractStreamMergeIterator<E>
    implements Iterator<E> {
        final PeekingIterator<GTRecord> input;
        final IGTCodeSystem codeSystem;
        final ImmutableBitSet dimensions;
        final ImmutableBitSet metrics;
        final String[] metricFuncs;
        final BufferedMeasureCodec measureCodec;
        private final GTRecord first;

        AbstractStreamMergeIterator(Iterator<GTRecord> input) {
            this.input = Iterators.peekingIterator(input);
            this.codeSystem = GTStreamAggregateScanner.this.req.getInfo().getCodeSystem();
            this.dimensions = GTStreamAggregateScanner.this.req.getDimensions();
            this.metrics = GTStreamAggregateScanner.this.req.getAggrMetrics();
            this.metricFuncs = GTStreamAggregateScanner.this.req.getAggrMetricsFuncs();
            this.measureCodec = GTStreamAggregateScanner.this.req.createMeasureCodec();
            this.first = new GTRecord(GTStreamAggregateScanner.this.req.getInfo());
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        private boolean isSameKey(GTRecord o1, GTRecord o2) {
            return GTStreamAggregateScanner.this.keyComparator.compare(o1, o2) == 0;
        }

        private boolean shouldMergeNext(GTRecord current) {
            return this.input.hasNext() && this.isSameKey(current, (GTRecord)this.input.peek());
        }

        protected abstract E finalizeResult(GTRecord var1);

        protected abstract E finalizeResult(GTRecord var1, Object[] var2);

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.first.shallowCopyFrom((GTRecord)this.input.next());
            if (!this.shouldMergeNext(this.first)) {
                return this.finalizeResult(this.first);
            }
            MeasureAggregator[] aggrs = this.codeSystem.newMetricsAggregators(this.metrics, this.metricFuncs);
            this.aggregate(aggrs, this.first);
            this.aggregate(aggrs, (GTRecord)this.input.next());
            while (this.shouldMergeNext(this.first)) {
                this.aggregate(aggrs, (GTRecord)this.input.next());
            }
            Object[] aggStates = new Object[aggrs.length];
            for (int i = 0; i < aggStates.length; ++i) {
                aggStates[i] = aggrs[i].getState();
            }
            return this.finalizeResult(this.first, aggStates);
        }

        protected void aggregate(MeasureAggregator[] aggregators, GTRecord record) {
            for (int i = 0; i < aggregators.length; ++i) {
                int c = this.metrics.trueBitAt(i);
                Object metric = this.codeSystem.decodeColumnValue(c, record.cols[c].asBuffer());
                aggregators[i].aggregate(metric);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

