/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.CacheDictionary;
import org.apache.kylin.dict.global.AppendDictSlice;
import org.apache.kylin.dict.global.AppendDictSliceKey;
import org.apache.kylin.dict.global.GlobalDictHDFSStore;
import org.apache.kylin.dict.global.GlobalDictMetadata;
import org.apache.kylin.dict.global.GlobalDictStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendTrieDictionary<T>
extends CacheDictionary<T> {
    public static final byte[] HEAD_MAGIC = new byte[]{65, 112, 112, 101, 99, 100, 84, 114, 105, 101, 68, 105, 99, 116};
    public static final int HEAD_SIZE_I = HEAD_MAGIC.length;
    private static final Logger logger = LoggerFactory.getLogger(AppendTrieDictionary.class);
    private transient Boolean isSaveAbsolutePath = false;
    private transient String baseDir;
    private transient GlobalDictMetadata metadata;
    private transient LoadingCache<AppendDictSliceKey, AppendDictSlice> dictCache;

    public void init(String baseDir) throws IOException {
        this.baseDir = this.convertToAbsolutePath(baseDir);
        final GlobalDictHDFSStore globalDictStore = new GlobalDictHDFSStore(this.baseDir);
        Long[] versions = ((GlobalDictStore)globalDictStore).listAllVersions();
        if (versions.length == 0) {
            this.metadata = new GlobalDictMetadata(0, 0, 0, 0, null, new TreeMap<AppendDictSliceKey, String>());
            return;
        }
        long latestVersion = versions[versions.length - 1];
        final Path latestVersionPath = ((GlobalDictStore)globalDictStore).getVersionDir(latestVersion);
        this.metadata = ((GlobalDictStore)globalDictStore).getMetadata(latestVersion);
        this.bytesConvert = this.metadata.bytesConverter;
        this.dictCache = CacheBuilder.newBuilder().softValues().removalListener((RemovalListener)new RemovalListener<AppendDictSliceKey, AppendDictSlice>(){

            public void onRemoval(RemovalNotification<AppendDictSliceKey, AppendDictSlice> notification) {
                logger.info("Evict slice with key {} and value {} caused by {}, size {}/{}", new Object[]{notification.getKey(), notification.getValue(), notification.getCause(), AppendTrieDictionary.this.dictCache.size(), ((AppendTrieDictionary)AppendTrieDictionary.this).metadata.sliceFileMap.size()});
            }
        }).build((CacheLoader)new CacheLoader<AppendDictSliceKey, AppendDictSlice>(){

            public AppendDictSlice load(AppendDictSliceKey key) throws Exception {
                AppendDictSlice slice = globalDictStore.readSlice(latestVersionPath.toString(), ((AppendTrieDictionary)AppendTrieDictionary.this).metadata.sliceFileMap.get(key));
                logger.trace("Load slice with key {} and value {}", (Object)key, (Object)slice);
                return slice;
            }
        });
    }

    @Override
    public int getIdFromValueBytesWithoutCache(byte[] value, int offset, int len, int roundingFlag) {
        AppendDictSlice slice;
        byte[] val = Arrays.copyOfRange(value, offset, offset + len);
        AppendDictSliceKey sliceKey = this.metadata.sliceFileMap.floorKey(AppendDictSliceKey.wrap(val));
        if (sliceKey == null) {
            sliceKey = this.metadata.sliceFileMap.firstKey();
        }
        try {
            slice = (AppendDictSlice)this.dictCache.get((Object)sliceKey);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to load slice with key " + sliceKey, e.getCause());
        }
        return slice.getIdFromValueBytesImpl(value, offset, len, roundingFlag);
    }

    @Override
    public int getMinId() {
        return this.metadata.baseId;
    }

    @Override
    public int getMaxId() {
        return this.metadata.maxId;
    }

    @Override
    public int getSizeOfId() {
        return 4;
    }

    @Override
    public int getSizeOfValue() {
        return this.metadata.maxValueLength;
    }

    @Override
    protected byte[] getValueBytesFromIdWithoutCache(int id) {
        throw new UnsupportedOperationException("AppendTrieDictionary can't retrieve value from id");
    }

    @Override
    public AppendTrieDictionary copyToAnotherMeta(KylinConfig srcConfig, KylinConfig dstConfig) throws IOException {
        GlobalDictHDFSStore store = new GlobalDictHDFSStore(this.baseDir);
        String dstBaseDir = ((GlobalDictStore)store).copyToAnotherMeta(srcConfig, dstConfig);
        AppendTrieDictionary<T> newDict = new AppendTrieDictionary<T>();
        newDict.init(dstBaseDir);
        return newDict;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.convertToRelativePath(this.baseDir));
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.init(in.readUTF());
    }

    @Override
    public void dump(PrintStream out) {
        out.println(String.format(Locale.ROOT, "Total %d values and %d slices", this.metadata.nValues, this.metadata.sliceFileMap.size()));
    }

    public int hashCode() {
        return Objects.hashCode(this.baseDir);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AppendTrieDictionary) {
            AppendTrieDictionary that = (AppendTrieDictionary)o;
            return Objects.equals(this.baseDir, that.baseDir);
        }
        return false;
    }

    public String toString() {
        return String.format(Locale.ROOT, "AppendTrieDictionary(%s)", this.baseDir);
    }

    @Override
    public boolean contains(Dictionary other) {
        return false;
    }

    private String convertToRelativePath(String path) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String hdfsWorkingDir = kylinConfig.getHdfsWorkingDirectory();
        if (!this.isSaveAbsolutePath.booleanValue() && path.startsWith(hdfsWorkingDir)) {
            return path.substring(hdfsWorkingDir.length());
        }
        return path;
    }

    private String convertToAbsolutePath(String path) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Path basicPath = new Path(path);
        if (basicPath.toUri().getScheme() == null) {
            return kylinConfig.getHdfsWorkingDirectory() + path;
        }
        String[] paths = path.split("/resources/GlobalDict/");
        if (paths.length == 2) {
            return kylinConfig.getHdfsWorkingDirectory() + "/resources/GlobalDict/" + paths[1];
        }
        paths = path.split("/resources/SegmentDict/");
        if (paths.length == 2) {
            return kylinConfig.getHdfsWorkingDirectory() + "/resources/SegmentDict/" + paths[1];
        }
        throw new RuntimeException("the basic directory of global dictionary only support the format which contains '/resources/GlobalDict/' or '/resources/SegmentDict/'");
    }

    void setSaveAbsolutePath(Boolean flag) {
        this.isSaveAbsolutePath = flag;
    }
}

