/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.gridtable;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.DynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class CuboidToGridTableMappingExt
extends CuboidToGridTableMapping {
    private final List<TblColRef> dynDims;
    private final List<DynamicFunctionDesc> dynFuncs;
    private ImmutableBitSet dynamicDims;
    private List<DataType> dynGtDataTypes;
    private List<ImmutableBitSet> dynGtColBlocks;
    private Map<TblColRef, Integer> dynDim2gt;
    private Map<FunctionDesc, Integer> dynMetrics2gt;

    public CuboidToGridTableMappingExt(Cuboid cuboid, List<TblColRef> dynDims, List<DynamicFunctionDesc> dynFuncs) {
        super(cuboid);
        this.dynDims = dynDims;
        this.dynFuncs = dynFuncs;
        this.init();
    }

    private void init() {
        this.dynGtDataTypes = Lists.newArrayList();
        this.dynGtColBlocks = Lists.newArrayList();
        this.dynDim2gt = Maps.newHashMap();
        this.dynMetrics2gt = Maps.newHashMap();
        int gtColIdx = super.getColumnCount();
        BitSet rtColBlock = new BitSet();
        for (TblColRef rtDim : this.dynDims) {
            this.dynDim2gt.put(rtDim, gtColIdx);
            this.dynGtDataTypes.add(rtDim.getType());
            rtColBlock.set(gtColIdx);
            ++gtColIdx;
        }
        this.dynamicDims = new ImmutableBitSet(rtColBlock);
        for (DynamicFunctionDesc rtFunc : this.dynFuncs) {
            this.dynMetrics2gt.put(rtFunc, gtColIdx);
            this.dynGtDataTypes.add(rtFunc.getReturnDataType());
            rtColBlock.set(gtColIdx);
            ++gtColIdx;
        }
        this.dynGtColBlocks.add(new ImmutableBitSet(rtColBlock));
    }

    public ImmutableBitSet getDynamicDims() {
        return this.dynamicDims;
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount() + this.dynDims.size() + this.dynFuncs.size();
    }

    @Override
    public DataType[] getDataTypes() {
        return (DataType[])ArrayUtils.addAll((Object[])super.getDataTypes(), (Object[])this.dynGtDataTypes.toArray(new DataType[this.dynGtDataTypes.size()]));
    }

    @Override
    public ImmutableBitSet[] getColumnBlocks() {
        return (ImmutableBitSet[])ArrayUtils.addAll((Object[])super.getColumnBlocks(), (Object[])this.dynGtColBlocks.toArray(new ImmutableBitSet[this.dynGtColBlocks.size()]));
    }

    @Override
    public int getIndexOf(TblColRef dimension) {
        Integer i = super.getIndexOf(dimension);
        if (i < 0) {
            i = this.dynDim2gt.get(dimension);
        }
        return i == null ? -1 : i;
    }

    @Override
    public int getIndexOf(FunctionDesc metric) {
        Integer r = super.getIndexOf(metric);
        if (r < 0) {
            r = this.dynMetrics2gt.get(metric);
        }
        return r == null ? -1 : r;
    }

    @Override
    public int[] getMetricsIndexes(Collection<FunctionDesc> metrics) {
        int[] result = new int[metrics.size()];
        int i = 0;
        for (FunctionDesc metric : metrics) {
            result[i++] = this.getIndexOf(metric);
        }
        return result;
    }
}

