/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.gridtable;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class CuboidToGridTableMapping {
    private final Cuboid cuboid;
    private List<DataType> gtDataTypes;
    private List<ImmutableBitSet> gtColBlocks;
    private int nDimensions;
    private Map<TblColRef, Integer> dim2gt;
    private ImmutableBitSet gtPrimaryKey;
    private int nMetrics;
    private Map<FunctionDesc, Integer> metrics2gt;

    public CuboidToGridTableMapping(Cuboid cuboid) {
        this.cuboid = cuboid;
        this.init();
    }

    private void init() {
        int gtColIdx = 0;
        this.gtDataTypes = Lists.newArrayList();
        this.gtColBlocks = Lists.newArrayList();
        this.dim2gt = Maps.newHashMap();
        BitSet pk = new BitSet();
        for (TblColRef dimension : this.cuboid.getColumns()) {
            this.gtDataTypes.add(dimension.getType());
            this.dim2gt.put(dimension, gtColIdx);
            pk.set(gtColIdx);
            ++gtColIdx;
        }
        this.gtPrimaryKey = new ImmutableBitSet(pk);
        this.gtColBlocks.add(this.gtPrimaryKey);
        this.nDimensions = gtColIdx;
        assert (this.nDimensions == this.cuboid.getColumns().size());
        ArrayList metricsColBlocks = Lists.newArrayList();
        for (HBaseColumnFamilyDesc familyDesc : this.cuboid.getCubeDesc().getHbaseMapping().getColumnFamily()) {
            for (int i = 0; i < familyDesc.getColumns().length; ++i) {
                metricsColBlocks.add(new BitSet());
            }
        }
        this.metrics2gt = Maps.newHashMap();
        for (MeasureDesc measure : this.cuboid.getCubeDesc().getMeasures()) {
            FunctionDesc func = measure.getFunction();
            this.metrics2gt.put(func, gtColIdx);
            this.gtDataTypes.add(func.getReturnDataType());
            int cbIdx = 0;
            for (HBaseColumnFamilyDesc familyDesc : this.cuboid.getCubeDesc().getHbaseMapping().getColumnFamily()) {
                for (HBaseColumnDesc hbaseColDesc : familyDesc.getColumns()) {
                    if (hbaseColDesc.containsMeasure(measure.getName())) {
                        ((BitSet)metricsColBlocks.get(cbIdx)).set(gtColIdx);
                    }
                    ++cbIdx;
                }
            }
            ++gtColIdx;
        }
        for (BitSet set : metricsColBlocks) {
            this.gtColBlocks.add(new ImmutableBitSet(set));
        }
        this.nMetrics = gtColIdx - this.nDimensions;
        assert (this.nMetrics == this.cuboid.getCubeDesc().getMeasures().size());
    }

    public int getColumnCount() {
        return this.nDimensions + this.nMetrics;
    }

    public DataType[] getDataTypes() {
        return this.gtDataTypes.toArray(new DataType[this.gtDataTypes.size()]);
    }

    public ImmutableBitSet getPrimaryKey() {
        return this.gtPrimaryKey;
    }

    public ImmutableBitSet[] getColumnBlocks() {
        return this.gtColBlocks.toArray(new ImmutableBitSet[this.gtColBlocks.size()]);
    }

    public int getIndexOf(TblColRef dimension) {
        Integer i = this.dim2gt.get(dimension);
        return i == null ? -1 : i;
    }

    public int[] getDimIndexes(Collection<TblColRef> dims) {
        int[] result = new int[dims.size()];
        int i = 0;
        for (TblColRef dim : dims) {
            result[i++] = this.getIndexOf(dim);
        }
        return result;
    }

    public int getIndexOf(FunctionDesc metric) {
        Integer r = this.metrics2gt.get(metric);
        return r == null ? -1 : r;
    }

    public int[] getMetricsIndexes(Collection<FunctionDesc> metrics) {
        int[] result = new int[metrics.size()];
        int i = 0;
        for (FunctionDesc metric : metrics) {
            result[i++] = this.getIndexOf(metric);
        }
        return result;
    }

    public List<TblColRef> getCuboidDimensionsInGTOrder() {
        return this.cuboid.getColumns();
    }

    public DimensionEncoding[] getDimensionEncodings(IDimensionEncodingMap dimEncMap) {
        List<TblColRef> dims = this.cuboid.getColumns();
        DimensionEncoding[] dimEncs = new DimensionEncoding[dims.size()];
        for (int i = 0; i < dimEncs.length; ++i) {
            dimEncs[i] = dimEncMap.get(dims.get(i));
        }
        return dimEncs;
    }

    public Map<Integer, Integer> getDependentMetricsMap() {
        HashMap result = Maps.newHashMap();
        List<MeasureDesc> measures = this.cuboid.getCubeDesc().getMeasures();
        for (MeasureDesc child : measures) {
            if (child.getDependentMeasureRef() == null) continue;
            boolean ok = false;
            for (MeasureDesc parent : measures) {
                if (!parent.getName().equals(child.getDependentMeasureRef())) continue;
                int childIndex = this.getIndexOf(child.getFunction());
                int parentIndex = this.getIndexOf(parent.getFunction());
                result.put(childIndex, parentIndex);
                ok = true;
                break;
            }
            if (ok) continue;
            throw new IllegalStateException("Cannot find dependent measure: " + child.getDependentMeasureRef());
        }
        return result.isEmpty() ? Collections.emptyMap() : result;
    }

    public ImmutableBitSet makeGridTableColumns(Set<TblColRef> dimensions) {
        BitSet result = new BitSet();
        for (TblColRef dim : dimensions) {
            int idx = this.getIndexOf(dim);
            if (idx < 0) continue;
            result.set(idx);
        }
        return new ImmutableBitSet(result);
    }

    public ImmutableBitSet makeGridTableColumns(Collection<? extends FunctionDesc> metrics) {
        BitSet result = new BitSet();
        for (FunctionDesc functionDesc : metrics) {
            int idx = this.getIndexOf(functionDesc);
            if (idx < 0) {
                throw new IllegalStateException(functionDesc + " not found in " + this);
            }
            result.set(idx);
        }
        return new ImmutableBitSet(result);
    }

    public String[] makeAggrFuncs(Collection<FunctionDesc> metrics) {
        ArrayList metricList = Lists.newArrayList(metrics);
        Collections.sort(metricList, new Comparator<FunctionDesc>(){

            @Override
            public int compare(FunctionDesc o1, FunctionDesc o2) {
                int a = CuboidToGridTableMapping.this.getIndexOf(o1);
                int b = CuboidToGridTableMapping.this.getIndexOf(o2);
                return a - b;
            }
        });
        String[] result = new String[metricList.size()];
        int i = 0;
        for (FunctionDesc metric : metricList) {
            result[i++] = metric.getExpression();
        }
        return result;
    }

    public Map<TblColRef, Integer> getDim2gt() {
        return ImmutableMap.copyOf(this.dim2gt);
    }
}

