/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStatsUtil;

public class CuboidUtil {
    public static Integer[][] getCuboidBitSet(Long[] cuboidIds, int nRowKey) {
        Preconditions.checkArgument((nRowKey < 64 ? 1 : 0) != 0, (Object)"the size of row key could not be large than 63");
        Integer[][] allCuboidsBitSet = new Integer[cuboidIds.length][];
        for (int j = 0; j < cuboidIds.length; ++j) {
            Long cuboidId = cuboidIds[j];
            allCuboidsBitSet[j] = new Integer[Long.bitCount(cuboidId)];
            long mask = 1L << nRowKey - 1;
            int position = 0;
            for (int i = 0; i < nRowKey; ++i) {
                if ((mask & cuboidId) > 0L) {
                    allCuboidsBitSet[j][position] = i;
                    ++position;
                }
                mask >>= 1;
            }
        }
        return allCuboidsBitSet;
    }

    public static int getLongestDepth(Set<Long> cuboidSet) {
        Map<Long, List<Long>> directChildrenCache = CuboidStatsUtil.createDirectChildrenCache(cuboidSet);
        ArrayList cuboids = Lists.newArrayList(cuboidSet);
        Collections.sort(cuboids, new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return -Long.compare(o1, o2);
            }
        });
        int longestDepth = 0;
        HashMap cuboidDepthMap = Maps.newHashMap();
        for (Long cuboid : cuboids) {
            int parentDepth = cuboidDepthMap.get(cuboid) == null ? 0 : (Integer)cuboidDepthMap.get(cuboid);
            for (Long childCuboid : directChildrenCache.get(cuboid)) {
                if (cuboidDepthMap.get(childCuboid) != null && (Integer)cuboidDepthMap.get(childCuboid) >= parentDepth + 1) continue;
                cuboidDepthMap.put(childCuboid, parentDepth + 1);
                if (longestDepth >= parentDepth + 1) continue;
                longestDepth = parentDepth + 1;
            }
        }
        return longestDepth;
    }
}

