/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.common.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryContextFacade {
    private static final Logger logger = LoggerFactory.getLogger(QueryContextFacade.class);
    private static final ConcurrentMap<String, QueryContext> RUNNING_CTX_MAP = Maps.newConcurrentMap();
    private static final ThreadLocal<QueryContext> CURRENT_CTX = new ThreadLocal<QueryContext>(){

        @Override
        protected QueryContext initialValue() {
            QueryContext queryContext = new QueryContext();
            RUNNING_CTX_MAP.put(queryContext.getQueryId(), queryContext);
            return queryContext;
        }
    };

    public static QueryContext current() {
        return CURRENT_CTX.get();
    }

    public static void resetCurrent() {
        QueryContext queryContext = CURRENT_CTX.get();
        if (queryContext != null) {
            RUNNING_CTX_MAP.remove(queryContext.getQueryId());
            CURRENT_CTX.remove();
        }
    }

    public static void stopQuery(String queryId, String info) {
        QueryContext queryContext = (QueryContext)RUNNING_CTX_MAP.get(queryId);
        if (queryContext != null) {
            queryContext.stopEarly(info);
        } else {
            logger.info("the query:{} is not existed", (Object)queryId);
        }
    }

    public static TreeSet<QueryContext> getAllRunningQueries() {
        TreeSet runningQueries = Sets.newTreeSet((Comparator)new Comparator<QueryContext>(){

            @Override
            public int compare(QueryContext o1, QueryContext o2) {
                if (o2.getAccumulatedMillis() > o1.getAccumulatedMillis()) {
                    return 1;
                }
                if (o2.getAccumulatedMillis() < o1.getAccumulatedMillis()) {
                    return -1;
                }
                return o1.getQueryId().compareTo(o2.getQueryId());
            }
        });
        runningQueries.addAll(RUNNING_CTX_MAP.values());
        return runningQueries;
    }

    public static TreeSet<QueryContext> getLongRunningQueries(long runningTime) {
        TreeSet<QueryContext> allRunningQueries = QueryContextFacade.getAllRunningQueries();
        QueryContext tmpCtx = new QueryContext(runningTime + 1L);
        return (TreeSet)allRunningQueries.headSet(tmpCtx);
    }
}

