/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.BitSet;
import org.apache.kylin.util.BitSetSerializer;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class KryoUtils {
    private static ThreadLocal<Kryo> _Kryo = new ThreadLocal();

    private KryoUtils() {
        throw new IllegalStateException("Class KryoUtils is an utility class !");
    }

    public static byte[] serialize(Object obj) {
        Kryo kryo = KryoUtils.getKryo();
        Output output = new Output(1024, 0x800000);
        kryo.writeObject(output, obj);
        return output.toBytes();
    }

    public static <T> T deserialize(byte[] bytes, Class<T> clazz) {
        Kryo kryo = KryoUtils.getKryo();
        Input input = new Input(bytes);
        return (T)kryo.readObject(input, clazz);
    }

    public static <T> T copy(T origin, Class<T> clazz) {
        byte[] bytes = KryoUtils.serialize(origin);
        return KryoUtils.deserialize(bytes, clazz);
    }

    public static Kryo getKryo() {
        if (_Kryo.get() == null) {
            Kryo kryo = new Kryo();
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
            kryo.register(BitSet.class, (Serializer)new BitSetSerializer());
            _Kryo.set(kryo);
        }
        return _Kryo.get();
    }
}

