/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.storage.hbase.steps.CubeHFileJob;
import org.apache.kylin.storage.hbase.steps.HBaseJobSteps;

public class HBaseMRSteps
extends HBaseJobSteps {
    public HBaseMRSteps(CubeSegment seg) {
        super(seg);
    }

    @Override
    public HadoopShellExecutable createCreateHTableStep(String jobId) {
        return this.createCreateHTableStep(jobId, CuboidModeEnum.CURRENT);
    }

    @Override
    public AbstractExecutable createConvertCuboidToHfileStep(String jobId) {
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        String inputPath = cuboidRootPath + (cuboidRootPath.endsWith("/") ? "" : "/") + "*";
        MapReduceExecutable createHFilesStep = new MapReduceExecutable();
        createHFilesStep.setName("Convert Cuboid Data to HFile");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"cubename", (String)this.seg.getRealization().getName());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"partitions", (String)(this.getRowkeyDistributionOutputPath(jobId) + "/part-r-00000_hfile"));
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"input", (String)inputPath);
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"output", (String)this.getHFilePath(jobId));
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"htablename", (String)this.seg.getStorageLocationIdentifier());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"jobname", (String)("Kylin_HFile_Generator_" + this.seg.getRealization().getName() + "_Step"));
        createHFilesStep.setMapReduceParams(cmd.toString());
        createHFilesStep.setMapReduceJobClass(CubeHFileJob.class);
        createHFilesStep.setCounterSaveAs(",,byteSizeBytes");
        return createHFilesStep;
    }
}

