/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.expression.BinaryTupleExpression;
import org.apache.kylin.metadata.expression.CaseTupleExpression;
import org.apache.kylin.metadata.expression.ColumnTupleExpression;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.expression.NoneTupleExpression;
import org.apache.kylin.metadata.expression.NumberTupleExpression;
import org.apache.kylin.metadata.expression.RexCallTupleExpression;
import org.apache.kylin.metadata.expression.StringTupleExpression;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleExpressionSerializer {
    private static final Logger logger = LoggerFactory.getLogger(TupleExpressionSerializer.class);
    private static final int BUFFER_SIZE = 65536;
    private static final Map<Integer, TupleExpression.ExpressionOperatorEnum> ID_OP_MAP = Maps.newHashMap();

    public static byte[] serialize(TupleExpression rootExpr, IFilterCodeSystem<?> cs) {
        return TupleExpressionSerializer.serialize(rootExpr, null, cs);
    }

    public static byte[] serialize(TupleExpression rootExpr, Decorator decorator, IFilterCodeSystem<?> cs) {
        ByteBuffer buffer;
        int bufferSize = 65536;
        while (true) {
            try {
                buffer = ByteBuffer.allocate(bufferSize);
                Serializer serializer = new Serializer(decorator, cs, buffer);
                rootExpr.accept(serializer);
            }
            catch (BufferOverflowException e) {
                logger.info("Buffer size {} cannot hold the expression, resizing to 4 times", (Object)bufferSize);
                bufferSize *= 4;
                continue;
            }
            break;
        }
        byte[] result = new byte[buffer.position()];
        System.arraycopy(buffer.array(), 0, result, 0, buffer.position());
        return result;
    }

    private static void serializeExpression(int flag, TupleExpression expr, ByteBuffer buffer, IFilterCodeSystem<?> cs) {
        if (flag < 0) {
            BytesUtil.writeVInt(-1, buffer);
        } else {
            int opVal = expr.getOperator().getValue();
            BytesUtil.writeVInt(opVal, buffer);
            expr.serialize(cs, buffer);
            BytesUtil.writeVInt(flag, buffer);
        }
    }

    public static TupleExpression deserialize(byte[] bytes, IFilterCodeSystem<?> cs) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        TupleExpression rootTuple = null;
        Stack<TupleExpression> parentStack = new Stack<TupleExpression>();
        while (buffer.hasRemaining()) {
            int hasChild;
            int opVal = BytesUtil.readVInt(buffer);
            if (opVal < 0) {
                parentStack.pop();
                continue;
            }
            TupleExpression tuple = TupleExpressionSerializer.createTupleExpression(opVal);
            tuple.deserialize(cs, buffer);
            if (rootTuple == null) {
                rootTuple = tuple;
                parentStack.push(tuple);
                BytesUtil.readVInt(buffer);
                continue;
            }
            TupleExpression parentExpression = (TupleExpression)parentStack.peek();
            if (parentExpression != null) {
                parentExpression.addChild(tuple);
            }
            if ((hasChild = BytesUtil.readVInt(buffer)) != 1) continue;
            parentStack.push(tuple);
        }
        return rootTuple;
    }

    private static TupleExpression createTupleExpression(int opVal) {
        TupleExpression.ExpressionOperatorEnum op = ID_OP_MAP.get(opVal);
        if (op == null) {
            throw new IllegalStateException("operator value is " + opVal);
        }
        TupleExpression tuple = null;
        switch (op) {
            case PLUS: 
            case MINUS: 
            case MULTIPLE: 
            case DIVIDE: {
                tuple = new BinaryTupleExpression(op);
                break;
            }
            case NUMBER: {
                tuple = new NumberTupleExpression(null);
                break;
            }
            case STRING: {
                tuple = new StringTupleExpression(null);
                break;
            }
            case COLUMN: {
                tuple = new ColumnTupleExpression(null);
                break;
            }
            case CASE: {
                tuple = new CaseTupleExpression(null, null);
                break;
            }
            default: {
                throw new IllegalStateException("Error ExpressionOperatorEnum: " + op.getValue());
            }
        }
        return tuple;
    }

    static {
        for (TupleExpression.ExpressionOperatorEnum op : TupleExpression.ExpressionOperatorEnum.values()) {
            ID_OP_MAP.put(op.getValue(), op);
        }
    }

    private static class Serializer
    implements ExpressionVisitor {
        private final Decorator decorator;
        private final IFilterCodeSystem<?> cs;
        private final ByteBuffer buffer;

        private Serializer(Decorator decorator, IFilterCodeSystem<?> cs, ByteBuffer buffer) {
            this.decorator = decorator;
            this.cs = cs;
            this.buffer = buffer;
        }

        @Override
        public TupleExpression visitNumber(NumberTupleExpression numExpr) {
            TupleExpressionSerializer.serializeExpression(0, numExpr, this.buffer, this.cs);
            return numExpr;
        }

        @Override
        public TupleExpression visitString(StringTupleExpression strExpr) {
            TupleExpressionSerializer.serializeExpression(0, strExpr, this.buffer, this.cs);
            return strExpr;
        }

        @Override
        public TupleExpression visitColumn(ColumnTupleExpression colExpr) {
            if (this.decorator != null) {
                colExpr = new ColumnTupleExpression(this.decorator.mapCol(colExpr.getColumn()));
            }
            TupleExpressionSerializer.serializeExpression(0, colExpr, this.buffer, this.cs);
            return colExpr;
        }

        @Override
        public TupleExpression visitBinary(BinaryTupleExpression binaryExpr) {
            TupleExpressionSerializer.serializeExpression(1, binaryExpr, this.buffer, this.cs);
            TupleExpression left = binaryExpr.getLeft().accept(this);
            TupleExpression right = binaryExpr.getRight().accept(this);
            TupleExpressionSerializer.serializeExpression(-1, binaryExpr, this.buffer, this.cs);
            return this.decorator == null ? binaryExpr : new BinaryTupleExpression(binaryExpr.getOperator(), Lists.newArrayList((Object[])new TupleExpression[]{left, right}));
        }

        @Override
        public TupleExpression visitCaseCall(CaseTupleExpression caseExpr) {
            if (this.decorator != null) {
                ArrayList whenList = Lists.newArrayListWithExpectedSize((int)caseExpr.getWhenList().size());
                for (Pair<TupleFilter, TupleExpression> entry : caseExpr.getWhenList()) {
                    TupleFilter filter = this.decorator.convertInnerFilter(entry.getFirst());
                    TupleExpression whenEntry = this.decorator.convertInnerExpression(entry.getSecond());
                    whenList.add(new Pair<TupleFilter, TupleExpression>(filter, whenEntry));
                }
                TupleExpression elseExpr = caseExpr.getElseExpr();
                if (elseExpr != null) {
                    elseExpr = this.decorator.convertInnerExpression(elseExpr);
                }
                caseExpr = new CaseTupleExpression(whenList, elseExpr);
            }
            TupleExpressionSerializer.serializeExpression(0, caseExpr, this.buffer, this.cs);
            return caseExpr;
        }

        @Override
        public TupleExpression visitRexCall(RexCallTupleExpression rexCallExpr) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TupleExpression visitNone(NoneTupleExpression noneExpr) {
            return noneExpr;
        }
    }

    public static interface Decorator {
        public TblColRef mapCol(TblColRef var1);

        public TupleExpression convertInnerExpression(TupleExpression var1);

        public TupleFilter convertInnerFilter(TupleFilter var1);
    }
}

