/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.BytesConverter;
import org.apache.kylin.dict.CacheDictionary;
import org.apache.kylin.dict.TrieDictionary;

public class TrieDictionaryForest<T>
extends CacheDictionary<T> {
    private static final long serialVersionUID = 1L;
    private ArrayList<TrieDictionary<T>> trees;
    private ArrayList<ByteArray> valueDivide;
    private ArrayList<Integer> accuOffset;
    private ArrayList<ByteArray> maxValue;
    private int minId;
    private int maxId;
    private int sizeOfId;
    private int sizeOfValue;

    public TrieDictionaryForest() {
    }

    public TrieDictionaryForest(ArrayList<TrieDictionary<T>> trees, ArrayList<ByteArray> valueDivide, ArrayList<Integer> accuOffset, BytesConverter<T> bytesConverter, int baseId) {
        this.init(trees, valueDivide, accuOffset, bytesConverter, baseId);
    }

    private void init(ArrayList<TrieDictionary<T>> trees, ArrayList<ByteArray> valueDivide, ArrayList<Integer> accuOffset, BytesConverter<T> bytesConverter, int baseId) {
        this.trees = trees;
        this.valueDivide = valueDivide;
        this.accuOffset = accuOffset;
        this.bytesConvert = bytesConverter;
        this.baseId = baseId;
        this.initConstantValue();
        this.initForestCache();
    }

    @Override
    public int getMinId() {
        return this.minId;
    }

    @Override
    public int getMaxId() {
        return this.maxId;
    }

    @Override
    public int getSizeOfId() {
        return this.sizeOfId;
    }

    @Override
    public int getSizeOfValue() {
        return this.sizeOfValue;
    }

    @Override
    protected int getIdFromValueBytesWithoutCache(byte[] value, int offset, int len, int roundingFlag) throws IllegalArgumentException {
        int index;
        if (this.trees.size() == 1) {
            index = 0;
        } else {
            ByteArray search = new ByteArray(value, offset, len);
            index = this.findIndexByValue(search);
            if (index < 0) {
                if (roundingFlag > 0) {
                    return this.getMinId();
                }
                throw new IllegalArgumentException("Value '" + Bytes.toString(value, offset, len) + "' (" + Bytes.toStringBinary(value, offset, len) + ") not exists!");
            }
            if (roundingFlag > 0) {
                ByteArray maxValueOfTree = this.maxValue.get(index);
                if (search.compareTo(maxValueOfTree) > 0) {
                    ++index;
                }
                if (index >= this.trees.size()) {
                    throw new IllegalArgumentException("Value '" + Bytes.toString(value, offset, len) + "' (" + Bytes.toStringBinary(value, offset, len) + ") not exists!");
                }
            }
        }
        TrieDictionary<T> tree = this.trees.get(index);
        int id = tree.getIdFromValueBytesWithoutCache(value, offset, len, roundingFlag);
        if (id == -1) {
            throw new IllegalArgumentException("Value '" + Bytes.toString(value, offset, len) + "' (" + Bytes.toStringBinary(value, offset, len) + ") not exists!");
        }
        id += this.accuOffset.get(index).intValue();
        return id += this.baseId;
    }

    @Override
    protected byte[] getValueBytesFromIdWithoutCache(int id) throws IllegalArgumentException {
        int index = this.trees.size() == 1 ? 0 : this.findIndexById(id);
        int treeInnerOffset = this.getTreeInnerOffset(id, index);
        TrieDictionary<T> tree = this.trees.get(index);
        byte[] result = tree.getValueBytesFromIdWithoutCache(treeInnerOffset);
        return result;
    }

    private int getTreeInnerOffset(int id, int index) {
        id -= this.baseId;
        return id -= this.accuOffset.get(index).intValue();
    }

    @Override
    public void dump(PrintStream out) {
        out.println("TrieDictionaryForest");
        out.println("baseId:" + this.baseId);
        StringBuilder sb = new StringBuilder();
        sb.append("value divide:");
        for (ByteArray ba : this.valueDivide) {
            sb.append(this.bytesConvert.convertFromBytes(ba.array(), 0, ba.length()) + " ");
        }
        sb.append("\noffset divide:");
        for (Integer offset : this.accuOffset) {
            sb.append(offset + " ");
        }
        out.println(sb.toString());
        for (int i = 0; i < this.trees.size(); ++i) {
            out.println("----tree " + i + "--------");
            this.trees.get(i).dump(out);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.writeHead(out);
        this.writeBody(out);
    }

    private void writeHead(DataOutput out) throws IOException {
        int i;
        ByteArrayOutputStream byteBuf = new ByteArrayOutputStream();
        DataOutputStream headOut = new DataOutputStream(byteBuf);
        headOut.writeInt(this.baseId);
        headOut.writeUTF(this.bytesConvert == null ? "" : this.bytesConvert.getClass().getName());
        headOut.writeInt(this.accuOffset.size());
        for (i = 0; i < this.accuOffset.size(); ++i) {
            headOut.writeInt(this.accuOffset.get(i));
        }
        headOut.writeInt(this.valueDivide.size());
        for (i = 0; i < this.valueDivide.size(); ++i) {
            ByteArray ba = this.valueDivide.get(i);
            byte[] byteStr = ba.toBytes();
            headOut.writeInt(byteStr.length);
            headOut.write(byteStr);
        }
        headOut.writeInt(this.trees.size());
        headOut.close();
        byte[] head = byteBuf.toByteArray();
        out.writeInt(head.length);
        out.write(head);
    }

    private void writeBody(DataOutput out) throws IOException {
        for (int i = 0; i < this.trees.size(); ++i) {
            TrieDictionary<T> tree = this.trees.get(i);
            tree.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        try {
            int headSize = in.readInt();
            int baseId = in.readInt();
            String converterName = in.readUTF();
            BytesConverter bytesConverter = null;
            if (!converterName.isEmpty()) {
                bytesConverter = ClassUtil.forName(converterName, BytesConverter.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            int accuSize = in.readInt();
            ArrayList<Integer> accuOffset = new ArrayList<Integer>();
            for (int i = 0; i < accuSize; ++i) {
                accuOffset.add(in.readInt());
            }
            int valueDivideSize = in.readInt();
            ArrayList<ByteArray> valueDivide = new ArrayList<ByteArray>();
            for (int i = 0; i < valueDivideSize; ++i) {
                int length = in.readInt();
                byte[] buffer = new byte[length];
                in.readFully(buffer);
                valueDivide.add(new ByteArray(buffer, 0, buffer.length));
            }
            int treeSize = in.readInt();
            ArrayList<TrieDictionary<T>> trees = new ArrayList<TrieDictionary<T>>();
            for (int i = 0; i < treeSize; ++i) {
                TrieDictionary dict = new TrieDictionary();
                dict.readFields(in);
                trees.add(dict);
            }
            this.init(trees, valueDivide, accuOffset, bytesConverter, baseId);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean contains(Dictionary other) {
        if (other.getSize() > this.getSize()) {
            return false;
        }
        for (int i = other.getMinId(); i <= other.getMaxId(); ++i) {
            Object v = other.getValueFromId(i);
            if (this.containsValue(v)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.baseId;
        result = 31 * result + (this.trees == null ? 0 : this.trees.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrieDictionaryForest other = (TrieDictionaryForest)obj;
        if (this.baseId != other.baseId) {
            return false;
        }
        return !(this.trees == null ? other.trees != null : !this.trees.equals(other.trees));
    }

    List<TrieDictionary<T>> getTrees() {
        return Collections.unmodifiableList(this.trees);
    }

    BytesConverter<T> getBytesConvert() {
        return this.bytesConvert;
    }

    private int findIndexByValue(ByteArray value) {
        int index = TrieDictionaryForest.lowerBound(value, this.valueDivide);
        return index;
    }

    private int findIndexById(Integer id) {
        int index = TrieDictionaryForest.lowerBound(id = Integer.valueOf(id - this.baseId), this.accuOffset);
        if (index < 0) {
            throw new IllegalArgumentException("Tree Not Found. index < 0");
        }
        return index;
    }

    private static <K extends Comparable> int lowerBound(K lookfor, ArrayList<K> list) {
        if (list == null || list.isEmpty()) {
            return -1;
        }
        int left = 0;
        int right = list.size() - 1;
        int mid = 0;
        boolean found = false;
        int comp = 0;
        while (!found && left <= right) {
            mid = left + (right - left) / 2;
            comp = lookfor.compareTo(list.get(mid));
            if (comp < 0) {
                right = mid - 1;
                continue;
            }
            if (comp > 0) {
                left = mid + 1;
                continue;
            }
            found = true;
        }
        if (found) {
            return mid;
        }
        return Math.min(left, right);
    }

    private void initConstantValue() throws IllegalStateException {
        this.initMaxValueForEachTrie();
        this.initMaxId();
        this.initMinId();
        this.initSizeOfId();
        this.initSizeOfValue();
    }

    private void initMaxValueForEachTrie() {
        this.maxValue = new ArrayList();
        if (this.trees == null || this.trees.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.trees.size(); ++i) {
            Object curTreeMax = this.trees.get(i).getValueFromId(this.trees.get(i).getMaxId());
            byte[] b1 = this.bytesConvert.convertToBytes(curTreeMax);
            ByteArray ba1 = new ByteArray(b1, 0, b1.length);
            this.maxValue.add(ba1);
        }
    }

    private void initMaxId() {
        if (this.trees.isEmpty()) {
            this.maxId = this.baseId - 1;
            return;
        }
        int index = this.trees.size() - 1;
        this.maxId = this.accuOffset.get(index) + this.trees.get(index).getMaxId() + this.baseId;
    }

    private void initMinId() {
        if (this.trees.isEmpty()) {
            this.minId = this.baseId;
            return;
        }
        this.minId = this.trees.get(0).getMinId() + this.baseId;
    }

    private void initSizeOfId() {
        if (this.trees.isEmpty()) {
            this.sizeOfId = 1;
            return;
        }
        int maxOffset = this.accuOffset.get(this.accuOffset.size() - 1);
        TrieDictionary<T> lastTree = this.trees.get(this.trees.size() - 1);
        this.sizeOfId = BytesUtil.sizeForValue((long)(this.baseId + maxOffset + lastTree.getMaxId()) + 1L);
    }

    private void initSizeOfValue() {
        int maxValue = 0;
        for (TrieDictionary<T> tree : this.trees) {
            maxValue = Math.max(maxValue, tree.getSizeOfValue());
        }
        this.sizeOfValue = maxValue;
    }

    private void initForestCache() {
        this.enableCache();
        for (TrieDictionary<T> tree : this.trees) {
            tree.disableCache();
        }
    }
}

