/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.gridtable;

import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.cube.gridtable.AsymmetricRecordComparator;
import org.apache.kylin.cube.gridtable.ComparatorEx;
import org.apache.kylin.cube.gridtable.RecordComparator;
import org.apache.kylin.gridtable.IGTComparator;

public class RecordComparators {
    public static RecordComparator getRangeStartComparator(final IGTComparator comp) {
        return new RecordComparator(new ComparatorEx<ByteArray>(){

            boolean isMinNull(byte[] array) {
                if (array == null) {
                    return true;
                }
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] == 0) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int compare(ByteArray a, ByteArray b) {
                if (this.isMinNull(a.array())) {
                    if (this.isMinNull(b.array())) {
                        return 0;
                    }
                    return -1;
                }
                if (this.isMinNull(b.array())) {
                    return 1;
                }
                return comp.compare(a, b);
            }
        });
    }

    public static RecordComparator getRangeEndComparator(final IGTComparator comp) {
        return new RecordComparator(new ComparatorEx<ByteArray>(){

            @Override
            public int compare(ByteArray a, ByteArray b) {
                if (a.array() == null) {
                    if (b.array() == null) {
                        return 0;
                    }
                    return 1;
                }
                if (b.array() == null) {
                    return -1;
                }
                return comp.compare(a, b);
            }
        });
    }

    public static RecordComparator getRangeStartEndComparator(final IGTComparator comp) {
        return new AsymmetricRecordComparator(new ComparatorEx<ByteArray>(){

            @Override
            public int compare(ByteArray a, ByteArray b) {
                if (a.array() == null || b.array() == null) {
                    return -1;
                }
                return comp.compare(a, b);
            }
        });
    }
}

